/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies;

import com.intellij.externalDependencies.ProjectExternalDependency;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DependencyOnPlugin
implements ProjectExternalDependency,
Comparable<DependencyOnPlugin> {
    @NonNls
    private static final String IDE_BUILD_BASELINE_PLACEHOLDER = "<ide.build.baseline>";
    private final String myPluginId;
    @NlsSafe
    private final String myMinVersion;
    @NlsSafe
    private final String myMaxVersion;

    public DependencyOnPlugin(@NotNull String pluginId, @NlsSafe @Nullable String minVersion, @NlsSafe @Nullable String maxVersion) {
        if (pluginId == null) {
            DependencyOnPlugin.$$$reportNull$$$0(0);
        }
        this.myPluginId = pluginId;
        this.myMinVersion = minVersion;
        this.myMaxVersion = maxVersion;
    }

    @NlsSafe
    public String getPluginId() {
        return this.myPluginId;
    }

    @Nullable
    @NlsSafe
    public String getRawMinVersion() {
        return this.myMinVersion;
    }

    @Nullable
    @NlsSafe
    public String getRawMaxVersion() {
        return this.myMaxVersion;
    }

    @Nullable
    @NlsSafe
    public String getMinVersion() {
        return DependencyOnPlugin.preprocessVersionRequirement(this.myMinVersion);
    }

    @Nullable
    @NlsSafe
    public String getMaxVersion() {
        return DependencyOnPlugin.preprocessVersionRequirement(this.myMaxVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyOnPlugin plugin = (DependencyOnPlugin)o;
        return this.myPluginId.equals(plugin.myPluginId) && Objects.equals(this.myMinVersion, plugin.myMinVersion) && Objects.equals(this.myMaxVersion, plugin.myMaxVersion);
    }

    public int hashCode() {
        return 31 * (31 * this.myPluginId.hashCode() + Comparing.hashcode((Object)this.myMinVersion)) + Comparing.hashcode((Object)this.myMaxVersion);
    }

    @Override
    public int compareTo(DependencyOnPlugin o) {
        return ContainerUtil.compareLexicographically(Arrays.asList(this.myPluginId, this.myMinVersion, this.myMaxVersion), Arrays.asList(o.myPluginId, o.myMinVersion, o.myMaxVersion));
    }

    private static String preprocessVersionRequirement(@NlsSafe String version) {
        String baseline = String.valueOf(ApplicationInfo.getInstance().getBuild().getBaselineVersion());
        return version != null ? version.replace(IDE_BUILD_BASELINE_PLACEHOLDER, baseline) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginId", "com/intellij/externalDependencies/DependencyOnPlugin", "<init>"));
    }
}

