/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.visualLayer;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import java.awt.Font;
import java.awt.FontMetrics;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0017\u001a\u00020\u00052\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\u0014\u0010\u001a\u001a\u00020\u00052\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR#\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/intellij/formatting/visualLayer/InlayPresentation;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fillerLength", "", "vertical", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;IZ)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getFillerLength", "()I", "getVertical", "()Z", "editorFontMetrics", "Ljava/awt/FontMetrics;", "kotlin.jvm.PlatformType", "getEditorFontMetrics", "()Ljava/awt/FontMetrics;", "editorFontMetrics$delegate", "Lkotlin/Lazy;", "calcWidthInPixels", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcHeightInPixels", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class InlayPresentation
implements EditorCustomElementRenderer {
    @NotNull
    private final Editor editor;
    private final int fillerLength;
    private final boolean vertical;
    @NotNull
    private final Lazy editorFontMetrics$delegate;

    public InlayPresentation(@NotNull Editor editor2, int fillerLength, boolean vertical) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.fillerLength = fillerLength;
        this.vertical = vertical;
        this.editorFontMetrics$delegate = LazyKt.lazy(() -> InlayPresentation.editorFontMetrics_delegate$lambda$0(this));
    }

    public /* synthetic */ InlayPresentation(Editor editor2, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(editor2, n, bl);
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public final int getFillerLength() {
        return this.fillerLength;
    }

    public final boolean getVertical() {
        return this.vertical;
    }

    private final FontMetrics getEditorFontMetrics() {
        Lazy lazy = this.editorFontMetrics$delegate;
        return (FontMetrics)lazy.getValue();
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.vertical ? 0 : this.getEditorFontMetrics().stringWidth(StringsKt.repeat((CharSequence)" ", (int)this.fillerLength));
    }

    public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return (this.vertical ? this.fillerLength : 1) * this.getEditorFontMetrics().getHeight();
    }

    @NotNull
    public final Editor component1() {
        return this.editor;
    }

    public final int component2() {
        return this.fillerLength;
    }

    public final boolean component3() {
        return this.vertical;
    }

    @NotNull
    public final InlayPresentation copy(@NotNull Editor editor2, int fillerLength, boolean vertical) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return new InlayPresentation(editor2, fillerLength, vertical);
    }

    public static /* synthetic */ InlayPresentation copy$default(InlayPresentation inlayPresentation, Editor editor2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            editor2 = inlayPresentation.editor;
        }
        if ((n2 & 2) != 0) {
            n = inlayPresentation.fillerLength;
        }
        if ((n2 & 4) != 0) {
            bl = inlayPresentation.vertical;
        }
        return inlayPresentation.copy(editor2, n, bl);
    }

    @NotNull
    public String toString() {
        return "InlayPresentation(editor=" + this.editor + ", fillerLength=" + this.fillerLength + ", vertical=" + this.vertical + ")";
    }

    public int hashCode() {
        int result2 = this.editor.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.fillerLength);
        result2 = result2 * 31 + Boolean.hashCode(this.vertical);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InlayPresentation)) {
            return false;
        }
        InlayPresentation inlayPresentation = (InlayPresentation)other;
        if (!Intrinsics.areEqual((Object)this.editor, (Object)inlayPresentation.editor)) {
            return false;
        }
        if (this.fillerLength != inlayPresentation.fillerLength) {
            return false;
        }
        return this.vertical == inlayPresentation.vertical;
    }

    private static final FontMetrics editorFontMetrics_delegate$lambda$0(InlayPresentation this$0) {
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font editorFont = font;
        return this$0.editor.getContentComponent().getFontMetrics(editorFont);
    }
}

