/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.util.Ref;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBHtmlPaneConfiguration;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/LimitedWidthJBHtmlPane;", "Lcom/intellij/ui/components/JBHtmlPane;", "styleConfiguration", "Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration;", "paneConfiguration", "Lcom/intellij/ui/components/JBHtmlPaneConfiguration;", "prefSizeWasComputed", "Lcom/intellij/openapi/util/Ref;", "", "hintHint", "Lcom/intellij/ui/HintHint;", "layeredPane", "Ljavax/swing/JLayeredPane;", "<init>", "(Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration;Lcom/intellij/ui/components/JBHtmlPaneConfiguration;Lcom/intellij/openapi/util/Ref;Lcom/intellij/ui/HintHint;Ljavax/swing/JLayeredPane;)V", "prefSize", "Ljava/awt/Dimension;", "getPreferredSize", "setPreferredSize", "", "preferredSize", "intellij.platform.ide.impl"})
final class LimitedWidthJBHtmlPane
extends JBHtmlPane {
    @NotNull
    private final Ref<Boolean> prefSizeWasComputed;
    @NotNull
    private final HintHint hintHint;
    @Nullable
    private final JLayeredPane layeredPane;
    @Nullable
    private Dimension prefSize;

    public LimitedWidthJBHtmlPane(@NotNull JBHtmlPaneStyleConfiguration styleConfiguration, @NotNull JBHtmlPaneConfiguration paneConfiguration, @NotNull Ref<Boolean> prefSizeWasComputed, @NotNull HintHint hintHint, @Nullable JLayeredPane layeredPane2) {
        Intrinsics.checkNotNullParameter((Object)styleConfiguration, (String)"styleConfiguration");
        Intrinsics.checkNotNullParameter((Object)paneConfiguration, (String)"paneConfiguration");
        Intrinsics.checkNotNullParameter(prefSizeWasComputed, (String)"prefSizeWasComputed");
        Intrinsics.checkNotNullParameter((Object)hintHint, (String)"hintHint");
        super(styleConfiguration, paneConfiguration);
        this.prefSizeWasComputed = prefSizeWasComputed;
        this.hintHint = hintHint;
        this.layeredPane = layeredPane2;
    }

    @NotNull
    public Dimension getPreferredSize() {
        if (!((Boolean)this.prefSizeWasComputed.get()).booleanValue() && this.hintHint.isAwtTooltip()) {
            JRootPane rootPane;
            JLayeredPane lp = this.layeredPane;
            if (lp == null && (rootPane = UIUtil.getRootPane((Component)((Component)((Object)this)))) != null && rootPane.getSize().width > 0) {
                lp = rootPane.getLayeredPane();
            }
            Dimension size2 = null;
            if (lp != null) {
                AppUIUtil.targetToDevice((Component)((Object)this), lp);
                Dimension dimension = lp.getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
                size2 = dimension;
                this.prefSizeWasComputed.set((Object)true);
            } else {
                Dimension dimension = ScreenUtil.getScreenRectangle((int)0, (int)0).getSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
                size2 = dimension;
            }
            int fitWidth = (int)((double)size2.width * 0.8);
            Dimension prefSizeOriginal = super.getPreferredSize();
            if (prefSizeOriginal.width > fitWidth) {
                this.setSize(new Dimension(fitWidth, Integer.MAX_VALUE));
                Dimension fixedWidthSize = super.getPreferredSize();
                Dimension minSize = super.getMinimumSize();
                this.prefSize = new Dimension(Math.max(fitWidth, minSize.width), fixedWidthSize.height);
            } else {
                this.prefSize = new Dimension(prefSizeOriginal);
            }
        }
        Dimension s = this.prefSize == null ? super.getPreferredSize() : new Dimension(this.prefSize);
        Border border = this.getBorder();
        if (border != null) {
            Border it = border;
            boolean bl = false;
            JBInsets.addTo((Dimension)s, (Insets)it.getBorderInsets((Component)((Object)this)));
        }
        Intrinsics.checkNotNull((Object)s);
        return s;
    }

    public void setPreferredSize(@NotNull Dimension preferredSize) {
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        super.setPreferredSize(preferredSize);
        this.prefSize = preferredSize;
    }
}

