/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.Logs;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/WindowsAltSuppressor;", "Lcom/intellij/ide/IdeEventQueue$NonLockedEventDispatcher;", "<init>", "()V", "waitingForAltRelease", "", "robot", "Ljava/awt/Robot;", "dispatch", "e", "Ljava/awt/AWTEvent;", "dispatchKeyEvent", "ke", "Ljava/awt/event/KeyEvent;", "intellij.platform.ide.impl"})
final class WindowsAltSuppressor
implements IdeEventQueue.NonLockedEventDispatcher {
    private boolean waitingForAltRelease;
    @Nullable
    private Robot robot;

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e instanceof KeyEvent && this.dispatchKeyEvent((KeyEvent)e);
    }

    private final boolean dispatchKeyEvent(KeyEvent ke) {
        boolean pureAlt;
        boolean bl = pureAlt = ke.getKeyCode() == 18 && (ke.getModifiers() | 8) == 8;
        if (!pureAlt) {
            this.waitingForAltRelease = false;
            return false;
        }
        UISettings uiSettings = UISettings.Companion.getInstanceOrNull();
        if (uiSettings == null || !SystemInfoRt.isWindows || !Registry.Companion.is("actionSystem.win.suppressAlt", true) || !uiSettings.getHideToolStripes() && !uiSettings.getPresentationMode()) {
            return false;
        }
        Component component2 = ke.getComponent();
        boolean dispatch = true;
        if (ke.getID() == 401) {
            dispatch = !this.waitingForAltRelease;
        } else if (ke.getID() == 402) {
            if (this.waitingForAltRelease) {
                this.waitingForAltRelease = false;
                dispatch = false;
            } else if (component2 != null) {
                EventQueue.invokeLater(() -> WindowsAltSuppressor.dispatchKeyEvent$lambda$0(component2, this));
            }
        }
        return !dispatch;
    }

    private static final void dispatchKeyEvent$lambda$0(Component $component, WindowsAltSuppressor this$0) {
        try {
            Window window = ComponentUtil.getWindow((Component)$component);
            if (window == null || !window.isActive()) {
                return;
            }
            this$0.waitingForAltRelease = true;
            if (this$0.robot == null) {
                this$0.robot = new Robot();
            }
            Robot robot = this$0.robot;
            Intrinsics.checkNotNull((Object)robot);
            robot.keyPress(18);
            Robot robot2 = this$0.robot;
            Intrinsics.checkNotNull((Object)robot2);
            robot2.keyRelease(18);
        }
        catch (AWTException e1) {
            Logs.LOG.debug((Throwable)e1);
        }
    }
}

