/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0014J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH$J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH$\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/actions/CloseProjectsActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "showWelcomeFrameIfNeeded", "update", "getProjectEvenIfNotInitialized", "Lcom/intellij/openapi/project/Project;", "shouldShow", "", "canClose", "project", "currentProject", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nCloseProjectsActionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloseProjectsActionBase.kt\ncom/intellij/ide/actions/CloseProjectsActionBase\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n3919#2:66\n4434#2,2:67\n1869#3,2:69\n*S KotlinDebug\n*F\n+ 1 CloseProjectsActionBase.kt\ncom/intellij/ide/actions/CloseProjectsActionBase\n*L\n31#1:66\n31#1:67,2\n32#1:69,2\n*E\n"})
public abstract class CloseProjectsActionBase
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Frontend {
    public CloseProjectsActionBase() {
        this.getTemplatePresentation().setApplicationScope(true);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = this.getProjectEvenIfNotInitialized(e);
        if (project2 == null) {
            return;
        }
        Project currentProject = project2;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$filter$iv = projectArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Project it = (Project)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!this.canClose(it, currentProject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project it = (Project)element$iv;
            boolean bl = false;
            WindowManager.getInstance().updateDefaultFrameInfoOnProjectClose(it);
            WriteIntentReadAction.run(() -> CloseProjectsActionBase.actionPerformed$lambda$1$0(it));
            RecentProjectsManager.Companion.getInstance().updateLastProjectPath();
        }
        this.showWelcomeFrameIfNeeded();
    }

    protected void showWelcomeFrameIfNeeded() {
        WelcomeFrame.Companion.showIfNoProjectOpened$default(WelcomeFrame.Companion, null, 1, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = this.getProjectEvenIfNotInitialized(e);
        e.getPresentation().setEnabledAndVisible(project2 != null && !project2.isDefault() && this.shouldShow(e));
    }

    @Nullable
    protected final Project getProjectEvenIfNotInitialized(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getProject();
        if (object == null) {
            ProjectFrameHelper projectFrameHelper = ProjectFrameHelper.Companion.getFrameHelper(ComponentUtil.getWindow((Component)((Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT))));
            object = projectFrameHelper != null ? projectFrameHelper.getProject() : null;
        }
        return object;
    }

    protected abstract boolean shouldShow(@NotNull AnActionEvent var1);

    protected abstract boolean canClose(@NotNull Project var1, @NotNull Project var2);

    private static final void actionPerformed$lambda$1$0(Project $it) {
        ProjectManager.getInstance().closeAndDispose($it);
    }
}

