/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeDependentAction;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DumpThreadsAction
extends IdeDependentAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpThreadsAction.$$$reportNull$$$0(0);
        }
        DumpThreadsAction.dumpThreads(e.getProject());
    }

    public static void dumpThreads(@Nullable Project project2) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Path dumpDir = PerformanceWatcher.getInstance().dumpThreads("", false, false);
            Notification notification2 = DumpThreadsAction.createNotification(dumpDir);
            notification2.notify(project2);
        });
    }

    @NotNull
    private static Notification createNotification(@Nullable Path file2) {
        NotificationGroup group2 = NotificationGroupManager.getInstance().getNotificationGroup("Dump Threads Group");
        if (file2 != null) {
            String url = FileUtil.getUrl((File)file2.toFile());
            Notification notification2 = group2.createNotification(IdeBundle.message((String)"thread.dump.is.taken", (Object[])new Object[]{url}), NotificationType.INFORMATION).setListener(RevealFileAction.FILE_SELECTING_LISTENER);
            if (notification2 == null) {
                DumpThreadsAction.$$$reportNull$$$0(1);
            }
            return notification2;
        }
        Notification notification3 = group2.createNotification(IdeBundle.message((String)"failed.to.take.thread.dump", (Object[])new Object[0]), NotificationType.INFORMATION);
        if (notification3 == null) {
            DumpThreadsAction.$$$reportNull$$$0(2);
        }
        return notification3;
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DumpThreadsAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/DumpThreadsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/DumpThreadsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

