/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.HideAllToolWindowsActionKt;
import com.intellij.ide.actions.MaximizeEditorInSplitAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.toolWindow.ToolWindowEventSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/actions/HideAllToolWindowsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.ide.impl"})
public final class HideAllToolWindowsAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project2 = event.getProject();
        if (project2 == null) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        ToolWindowManagerImpl toolWindowManagerImpl = toolWindowManager instanceof ToolWindowManagerImpl ? (ToolWindowManagerImpl)toolWindowManager : null;
        if (toolWindowManagerImpl == null) {
            return;
        }
        ToolWindowManagerImpl toolWindowManager2 = toolWindowManagerImpl;
        Sequence idsToHide = HideAllToolWindowsActionKt.access$getIdsToHide(toolWindowManager2);
        if (SequencesKt.none((Sequence)idsToHide)) {
            DesktopLayout desktopLayout = toolWindowManager2.getLayoutToRestoreLater();
            if (desktopLayout != null) {
                DesktopLayout it = desktopLayout;
                boolean bl = false;
                toolWindowManager2.setLayoutToRestoreLater(null);
                toolWindowManager2.setLayout(it);
            }
        } else {
            DesktopLayout layout2 = toolWindowManager2.getLayout().copy();
            toolWindowManager2.clearSideStack();
            for (String id2 : idsToHide) {
                ToolWindowManagerImpl.hideToolWindow$default(toolWindowManager2, id2, false, false, false, ToolWindowEventSource.HideAllWindowsAction, 14, null);
            }
            toolWindowManager2.setLayoutToRestoreLater(layout2);
            toolWindowManager2.activateEditorComponent();
        }
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation2 = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        Presentation presentation3 = presentation2;
        presentation3.setEnabled(false);
        Project project2 = event.getProject();
        if (project2 == null) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project2);
        Intrinsics.checkNotNull((Object)toolWindowManager, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowManagerEx");
        ToolWindowManagerEx toolWindowManager2 = (ToolWindowManagerEx)toolWindowManager;
        if (SequencesKt.any((Sequence)HideAllToolWindowsActionKt.access$getIdsToHide(toolWindowManager2))) {
            presentation3.setEnabled(true);
            presentation3.putClientProperty(MaximizeEditorInSplitAction.Companion.getCURRENT_STATE_IS_MAXIMIZED_KEY(), (Object)false);
            presentation3.setText(IdeBundle.message((String)"action.hide.all.windows", (Object[])new Object[0]));
        } else if (toolWindowManager2.getLayoutToRestoreLater() != null) {
            presentation3.setEnabled(true);
            presentation3.setText(IdeBundle.message((String)"action.restore.windows", (Object[])new Object[0]));
            presentation3.putClientProperty(MaximizeEditorInSplitAction.Companion.getCURRENT_STATE_IS_MAXIMIZED_KEY(), (Object)true);
            return;
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

