/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.jetbrains.Extensions;
import com.jetbrains.GraphicsUtils;
import com.jetbrains.JBR;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class MoveWindowBuiltinDisplayAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MoveWindowBuiltinDisplayAction.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        GraphicsUtils grUtils = JBR.getGraphicsUtils((Extensions[])new Extensions[]{Extensions.BUILTIN_DISPLAY_CHECKER});
        if (grUtils == null) {
            return;
        }
        Window activeFrame = IdeFrameImpl.getActiveFrame();
        if (activeFrame == null) {
            return;
        }
        GraphicsDevice currentDevice = activeFrame.getGraphicsConfiguration().getDevice();
        if (grUtils.isBuiltinDisplay(currentDevice)) {
            return;
        }
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i2 = 0; i2 < devices.length; ++i2) {
            if (!grUtils.isBuiltinDisplay(devices[i2])) continue;
            activeFrame.setLocation(devices[i2].getDefaultConfiguration().getBounds().x, activeFrame.getY());
            break;
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = IdeEventQueue.getInstance().isDispatchingOnMainThread ? ActionUpdateThread.EDT : ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            MoveWindowBuiltinDisplayAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MoveWindowBuiltinDisplayAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabledAndVisible(false);
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || JBR.getGraphicsUtils((Extensions[])new Extensions[]{Extensions.BUILTIN_DISPLAY_CHECKER}) == null) {
            return;
        }
        GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = g.getScreenDevices();
        if (devices == null) {
            return;
        }
        e.getPresentation().setEnabledAndVisible(devices.length > 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/MoveWindowBuiltinDisplayAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/MoveWindowBuiltinDisplayAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

