/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.ide.actions.RecentLocationItem;
import com.intellij.ide.actions.RecentLocationsAction;
import com.intellij.ide.actions.RecentLocationsDataModel;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0005\u0012\u001a\u0010\t\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u001e\u001a\u00020\u0006J\u001f\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u00132\u0006\u0010\u001e\u001a\u00020\u0006J/\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u00132\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u0002J\u0018\u0010\"\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\bH\u0003J$\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00070\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010'\u001a\u00020\bH\u0002J$\u0010(\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007J#\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002\u00a2\u0006\u0002\u00101J\u0018\u00102\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u00103\u001a\u000200H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R,\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001b\u0010\u0017\u00a8\u00064"}, d2={"Lcom/intellij/ide/actions/RecentLocationsDataModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "placesSupplier", "Ljava/util/function/Function;", "", "", "Lcom/intellij/openapi/fileEditor/impl/IdeDocumentHistoryImpl$PlaceInfo;", "placesRemover", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/function/Function;Lkotlin/jvm/functions/Function1;)V", "navigationPlaces", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lcom/intellij/ide/actions/RecentLocationItem;", "changedPlaces", "navigationPlacesBreadcrumbsMap", "", "", "Lorg/jetbrains/annotations/Nls;", "getNavigationPlacesBreadcrumbsMap", "()Ljava/util/Map;", "navigationPlacesBreadcrumbsMap$delegate", "Lkotlin/Lazy;", "changedPlacedBreadcrumbsMap", "getChangedPlacedBreadcrumbsMap", "changedPlacedBreadcrumbsMap$delegate", "getPlaces", "changed", "getBreadcrumbsMap", "collectBreadcrumbs", "items", "getBreadcrumbs", "placeInfo", "calculateItems", "createPlaceLinePairs", "newLocationItem", "place", "removeItems", "isChanged", "getTrimmedRange", "", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "lineNumber", "", "(Lcom/intellij/openapi/editor/Document;I)[Lcom/intellij/openapi/util/TextRange;", "getLinesRange", "line", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nRecentLocationsDataModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecentLocationsDataModel.kt\ncom/intellij/ide/actions/RecentLocationsDataModel\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n697#2:232\n730#2,4:233\n2746#3,3:237\n1563#3:241\n1634#3,3:242\n774#3:245\n865#3,2:246\n1#4:240\n*S KotlinDebug\n*F\n+ 1 RecentLocationsDataModel.kt\ncom/intellij/ide/actions/RecentLocationsDataModel\n*L\n52#1:232\n52#1:233,4\n95#1:237,3\n133#1:241\n133#1:242,3\n143#1:245\n143#1:246,2\n*E\n"})
public final class RecentLocationsDataModel {
    @NotNull
    private final Project project;
    @Nullable
    private final Function<Boolean, List<IdeDocumentHistoryImpl.PlaceInfo>> placesSupplier;
    @Nullable
    private final Function1<List<IdeDocumentHistoryImpl.PlaceInfo>, Unit> placesRemover;
    @NotNull
    private final SynchronizedClearableLazy<List<RecentLocationItem>> navigationPlaces;
    @NotNull
    private final SynchronizedClearableLazy<List<RecentLocationItem>> changedPlaces;
    @NotNull
    private final Lazy navigationPlacesBreadcrumbsMap$delegate;
    @NotNull
    private final Lazy changedPlacedBreadcrumbsMap$delegate;

    public RecentLocationsDataModel(@NotNull Project project2, @Nullable Function<Boolean, List<IdeDocumentHistoryImpl.PlaceInfo>> placesSupplier, @Nullable Function1<? super List<IdeDocumentHistoryImpl.PlaceInfo>, Unit> placesRemover) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.placesSupplier = placesSupplier;
        this.placesRemover = placesRemover;
        this.navigationPlaces = this.calculateItems(this.project, false);
        this.changedPlaces = this.calculateItems(this.project, true);
        this.navigationPlacesBreadcrumbsMap$delegate = LazyKt.lazy(() -> RecentLocationsDataModel.navigationPlacesBreadcrumbsMap_delegate$lambda$0(this));
        this.changedPlacedBreadcrumbsMap$delegate = LazyKt.lazy(() -> RecentLocationsDataModel.changedPlacedBreadcrumbsMap_delegate$lambda$0(this));
    }

    private final Map<IdeDocumentHistoryImpl.PlaceInfo, String> getNavigationPlacesBreadcrumbsMap() {
        Lazy lazy = this.navigationPlacesBreadcrumbsMap$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<IdeDocumentHistoryImpl.PlaceInfo, String> getChangedPlacedBreadcrumbsMap() {
        Lazy lazy = this.changedPlacedBreadcrumbsMap$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final List<RecentLocationItem> getPlaces(boolean changed) {
        return changed ? (List)this.changedPlaces.getValue() : (List)this.navigationPlaces.getValue();
    }

    @NotNull
    public final Map<IdeDocumentHistoryImpl.PlaceInfo, String> getBreadcrumbsMap(boolean changed) {
        return changed ? this.getChangedPlacedBreadcrumbsMap() : this.getNavigationPlacesBreadcrumbsMap();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<IdeDocumentHistoryImpl.PlaceInfo, String> collectBreadcrumbs(Project project2, List<RecentLocationItem> items2) {
        void $this$associateByTo$iv$iv;
        Sequence $this$associateBy$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)items2), (Function1)((Function1)collectBreadcrumbs.1.INSTANCE));
        boolean $i$f$associateBy = false;
        Sequence sequence = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            IdeDocumentHistoryImpl.PlaceInfo placeInfo = (IdeDocumentHistoryImpl.PlaceInfo)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            IdeDocumentHistoryImpl.PlaceInfo it = (IdeDocumentHistoryImpl.PlaceInfo)element$iv$iv;
            void var13_13 = it;
            boolean bl2 = false;
            String string = this.getBreadcrumbs(project2, it);
            map2.put(var13_13, string);
        }
        return destination$iv$iv;
    }

    @Nls
    private final String getBreadcrumbs(Project project2, IdeDocumentHistoryImpl.PlaceInfo placeInfo) {
        RangeMarker rangeMarker = placeInfo.getCaretPosition();
        String string = placeInfo.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        if (rangeMarker == null) {
            return fileName;
        }
        FileBreadcrumbsCollector fileBreadcrumbsCollector = FileBreadcrumbsCollector.findBreadcrumbsCollector((Project)project2, (VirtualFile)placeInfo.getFile());
        if (fileBreadcrumbsCollector == null) {
            return fileName;
        }
        FileBreadcrumbsCollector collector = fileBreadcrumbsCollector;
        Iterable iterable = collector.computeCrumbs(placeInfo.getFile(), rangeMarker.getDocument(), rangeMarker.getStartOffset(), Boolean.valueOf(true));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"computeCrumbs(...)");
        Iterable crumbs = iterable;
        if (!crumbs.iterator().hasNext()) {
            return fileName;
        }
        String separator = " > ";
        String result2 = CollectionsKt.joinToString$default((Iterable)crumbs, (CharSequence)separator, null, null, (int)0, null, RecentLocationsDataModel::getBreadcrumbs$lambda$0, (int)30, null);
        return result2;
    }

    private final SynchronizedClearableLazy<List<RecentLocationItem>> calculateItems(Project project2, boolean changed) {
        return new SynchronizedClearableLazy(() -> RecentLocationsDataModel.calculateItems$lambda$0(this, project2, changed));
    }

    private final List<RecentLocationItem> createPlaceLinePairs(Project project2, boolean changed) {
        ArrayList<RecentLocationItem> result2 = new ArrayList<RecentLocationItem>();
        if (this.placesSupplier != null) {
            for (IdeDocumentHistoryImpl.PlaceInfo place : this.placesSupplier.apply(changed)) {
                RecentLocationItem recentLocationItem = this.newLocationItem(place);
                if (recentLocationItem == null) continue;
                result2.add(recentLocationItem);
            }
        } else {
            int maxPlaces = UISettings.Companion.getInstance().getRecentLocationsLimit();
            List list2 = ContainerUtil.reverse(changed ? IdeDocumentHistory.getInstance(project2).getChangePlaces() : IdeDocumentHistory.getInstance(project2).getBackPlaces());
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"reverse(...)");
            List places = list2;
            for (IdeDocumentHistoryImpl.PlaceInfo place : places) {
                boolean bl;
                block8: {
                    Iterable $this$none$iv = result2;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            RecentLocationItem it = (RecentLocationItem)element$iv;
                            boolean bl2 = false;
                            if (!IdeDocumentHistory.getInstance(project2).isSame(place, it.info)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    Intrinsics.checkNotNull((Object)place);
                    RecentLocationItem recentLocationItem = this.newLocationItem(place);
                    if (recentLocationItem == null) continue;
                    result2.add(recentLocationItem);
                }
                if (result2.size() < maxPlaces) continue;
                break;
            }
        }
        return result2;
    }

    private final RecentLocationItem newLocationItem(IdeDocumentHistoryImpl.PlaceInfo place) {
        CharSequence charSequence;
        boolean bl;
        RangeMarker positionOffset = place.getCaretPosition();
        if (positionOffset == null || !positionOffset.isValid()) {
            return null;
        }
        boolean bl2 = bl = positionOffset.getStartOffset() == positionOffset.getEndOffset();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Document document2 = positionOffset.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document fileDocument = document2;
        int lineNumber = fileDocument.getLineNumber(positionOffset.getStartOffset());
        Object[] ranges = this.getTrimmedRange(fileDocument, lineNumber);
        CharSequence charSequence2 = ArraysKt.joinToString$default((Object[])ranges, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> RecentLocationsDataModel.newLocationItem$lambda$0(fileDocument, arg_0), (int)30, null);
        if (charSequence2.length() == 0) {
            boolean bl3 = false;
            charSequence = RecentLocationsAction.getEmptyFileText();
        } else {
            charSequence = charSequence2;
        }
        String documentText = (String)charSequence;
        int linesShift = !(ranges.length == 0) ? fileDocument.getLineNumber(ranges[0].getStartOffset()) : 0;
        Intrinsics.checkNotNull((Object)documentText);
        return new RecentLocationItem(place, documentText, linesShift, (TextRange[])ranges);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeItems(@NotNull Project project2, boolean isChanged, @NotNull List<RecentLocationItem> items2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        List list2 = isChanged ? (List)this.changedPlaces.drop() : (List)this.navigationPlaces.drop();
        Function1<List<IdeDocumentHistoryImpl.PlaceInfo>, Unit> function1 = this.placesRemover;
        if (function1 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Function1<List<IdeDocumentHistoryImpl.PlaceInfo>, Unit> it = function1;
            boolean bl = false;
            Iterable iterable = items2;
            Function1<List<IdeDocumentHistoryImpl.PlaceInfo>, Unit> function12 = it;
            boolean $i$f$map = false;
            void var11_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                RecentLocationItem recentLocationItem = (RecentLocationItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it2.info);
            }
            function12.invoke((Object)((List)destination$iv$iv));
            return;
        }
        IdeDocumentHistory ideDocumentHistory = IdeDocumentHistory.getInstance(project2);
        for (RecentLocationItem item : items2) {
            List list3;
            if (isChanged) {
                list3 = ideDocumentHistory.getChangePlaces();
            } else {
                void $this$filterTo$iv$iv;
                List<IdeDocumentHistoryImpl.PlaceInfo> list4 = ideDocumentHistory.getBackPlaces();
                Intrinsics.checkNotNullExpressionValue(list4, (String)"getBackPlaces(...)");
                Iterable $this$filter$iv = list4;
                boolean $i$f$filter = false;
                Iterable $i$f$map = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    IdeDocumentHistoryImpl.PlaceInfo it = (IdeDocumentHistoryImpl.PlaceInfo)element$iv$iv;
                    boolean bl = false;
                    if (!IdeDocumentHistory.getInstance(project2).isSame(it, item.info)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list3 = (List)destination$iv$iv;
            }
            for (IdeDocumentHistoryImpl.PlaceInfo it : list3) {
                if (isChanged) {
                    ideDocumentHistory.removeChangePlace(it);
                    continue;
                }
                ideDocumentHistory.removeBackPlace(it);
            }
        }
    }

    private final TextRange[] getTrimmedRange(Document document2, int lineNumber) {
        TextRange range = this.getLinesRange(document2, lineNumber);
        String string = document2.getText(TextRange.create((int)range.getStartOffset(), (int)range.getEndOffset()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text2 = string;
        String string2 = StringUtil.substringBefore((String)text2, (String)StringUtil.trimLeading((String)text2));
        Intrinsics.checkNotNull((Object)string2);
        int newLinesBefore = StringUtil.countNewLines((CharSequence)string2);
        String string3 = StringUtil.substringAfter((String)text2, (String)StringUtil.trimTrailing((String)text2));
        Intrinsics.checkNotNull((Object)string3);
        int newLinesAfter = StringUtil.countNewLines((CharSequence)string3);
        int firstLine = document2.getLineNumber(range.getStartOffset());
        int firstLineAdjusted = firstLine + newLinesBefore;
        int lastLine = document2.getLineNumber(range.getEndOffset());
        int lastLineAdjusted = lastLine - newLinesAfter;
        int n = 0;
        int n2 = lastLineAdjusted - firstLineAdjusted + 1;
        TextRange[] textRangeArray = new TextRange[n2];
        while (n < n2) {
            int n3 = n++;
            int startOffset = document2.getLineStartOffset(firstLineAdjusted + n3);
            int endOffset = document2.getLineEndOffset(firstLineAdjusted + n3);
            textRangeArray[n3] = TextRange.create((int)startOffset, (int)(startOffset + Math.min(endOffset - startOffset, 1000)));
        }
        TextRange[] result2 = textRangeArray;
        return result2;
    }

    private final TextRange getLinesRange(Document document2, int line) {
        TextRange textRange;
        int endOffset;
        int lineCount = document2.getLineCount();
        if (lineCount == 0) {
            TextRange textRange2 = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"EMPTY_RANGE");
            return textRange2;
        }
        int beforeAfterLinesCount = Registry.Companion.intValue("recent.locations.lines.before.and.after", 2);
        int before = Math.min(beforeAfterLinesCount, line);
        int after = Math.min(beforeAfterLinesCount, lineCount - line);
        int linesBefore = before + beforeAfterLinesCount - after;
        int linesAfter = after + beforeAfterLinesCount - before;
        int startLine = Math.max(line - linesBefore, 0);
        int endLine = Math.min(line + linesAfter, lineCount - 1);
        int startOffset = document2.getLineStartOffset(startLine);
        if (startOffset <= (endOffset = document2.getLineEndOffset(endLine))) {
            TextRange textRange3 = TextRange.create((int)startOffset, (int)endOffset);
            Intrinsics.checkNotNull((Object)textRange3);
            textRange = textRange3;
        } else {
            TextRange textRange4 = DocumentUtil.getLineTextRange((Document)document2, (int)line);
            Intrinsics.checkNotNull((Object)textRange4);
            textRange = textRange4;
        }
        return textRange;
    }

    private static final Map navigationPlacesBreadcrumbsMap_delegate$lambda$0(RecentLocationsDataModel this$0) {
        return this$0.collectBreadcrumbs(this$0.project, (List)this$0.navigationPlaces.getValue());
    }

    private static final Map changedPlacedBreadcrumbsMap_delegate$lambda$0(RecentLocationsDataModel this$0) {
        return this$0.collectBreadcrumbs(this$0.project, (List)this$0.changedPlaces.getValue());
    }

    private static final CharSequence getBreadcrumbs$lambda$0(Crumb it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final List calculateItems$lambda$0(RecentLocationsDataModel this$0, Project $project, boolean $changed) {
        return this$0.createPlaceLinePairs($project, $changed);
    }

    private static final CharSequence newLocationItem$lambda$0(Document $fileDocument, TextRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $fileDocument.getText(it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

