/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.StretchSplitActionKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0005\u0016\u0017\u0018\u0019\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/actions/StretchSplitAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "direction", "Lcom/intellij/ide/actions/StretchSplitAction$StretchDirection;", "<init>", "(Lcom/intellij/ide/actions/StretchSplitAction$StretchDirection;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "stretch", "editor", "Lcom/intellij/openapi/editor/Editor;", "moveDivider", "pixelSplitter", "Lcom/intellij/openapi/ui/Splitter;", "shrinkFirstComponent", "", "findSplitter", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "StretchDirection", "StretchToTop", "StretchToLeft", "StretchToBottom", "StretchToRight", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public abstract class StretchSplitAction
extends DumbAwareAction {
    @NotNull
    private final StretchDirection direction;

    public StretchSplitAction(@NotNull StretchDirection direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.direction = direction;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        this.stretch(editor3, this.direction);
    }

    private final void stretch(Editor editor2, StretchDirection direction) {
        Splitter splitter2 = this.findSplitter(editor2);
        Intrinsics.checkNotNull((Object)splitter2);
        Splitter pixelSplitter = splitter2;
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                this.moveDivider(pixelSplitter, true);
                break;
            }
            case 2: {
                this.moveDivider(pixelSplitter, true);
                break;
            }
            case 3: {
                this.moveDivider(pixelSplitter, false);
                break;
            }
            case 4: {
                this.moveDivider(pixelSplitter, false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void moveDivider(Splitter pixelSplitter, boolean shrinkFirstComponent) {
        int step2 = 50;
        int delta = 10;
        int minSize = step2 + delta;
        int totalLength = StretchSplitActionKt.access$getFirstComponentLength(pixelSplitter) + StretchSplitActionKt.access$getSecondComponentLength(pixelSplitter);
        if (shrinkFirstComponent) {
            if (StretchSplitActionKt.access$getFirstComponentLength(pixelSplitter) > minSize) {
                pixelSplitter.setProportion((float)(StretchSplitActionKt.access$getFirstComponentLength(pixelSplitter) - step2) / (float)totalLength);
            }
        } else if (StretchSplitActionKt.access$getSecondComponentLength(pixelSplitter) > minSize) {
            pixelSplitter.setProportion((float)(StretchSplitActionKt.access$getFirstComponentLength(pixelSplitter) + step2) / (float)totalLength);
        }
    }

    private final Splitter findSplitter(Editor editor2) {
        JComponent jComponent = editor2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent editorComponent = jComponent;
        Component pixelSplitter = ComponentUtil.findParentByCondition((Component)editorComponent, arg_0 -> StretchSplitAction.findSplitter$lambda$1(arg_0 -> StretchSplitAction.findSplitter$lambda$0(this, arg_0), arg_0));
        if (pixelSplitter instanceof Splitter) {
            return (Splitter)pixelSplitter;
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        boolean enabled2 = editor2 != null && this.findSplitter(editor2) != null;
        e.getPresentation().setEnabled(enabled2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private static final boolean findSplitter$lambda$0(StretchSplitAction this$0, Component p) {
        return p instanceof Splitter && ((Splitter)p).isVertical() == (this$0.direction == StretchDirection.TOP || this$0.direction == StretchDirection.BOTTOM) && ((Splitter)p).getProportion() > 0.0f && ((Splitter)p).getProportion() < 1.0f;
    }

    private static final boolean findSplitter$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/actions/StretchSplitAction$StretchDirection;", "", "<init>", "(Ljava/lang/String;I)V", "TOP", "LEFT", "BOTTOM", "RIGHT", "intellij.platform.ide.impl"})
    public static final class StretchDirection
    extends Enum<StretchDirection> {
        public static final /* enum */ StretchDirection TOP = new StretchDirection();
        public static final /* enum */ StretchDirection LEFT = new StretchDirection();
        public static final /* enum */ StretchDirection BOTTOM = new StretchDirection();
        public static final /* enum */ StretchDirection RIGHT = new StretchDirection();
        private static final /* synthetic */ StretchDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static StretchDirection[] values() {
            return (StretchDirection[])$VALUES.clone();
        }

        public static StretchDirection valueOf(String value) {
            return Enum.valueOf(StretchDirection.class, value);
        }

        @NotNull
        public static EnumEntries<StretchDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stretchDirectionArray = new StretchDirection[]{StretchDirection.TOP, StretchDirection.LEFT, StretchDirection.BOTTOM, StretchDirection.RIGHT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ide/actions/StretchSplitAction$StretchToBottom;", "Lcom/intellij/ide/actions/StretchSplitAction;", "<init>", "()V", "intellij.platform.ide.impl"})
    public static final class StretchToBottom
    extends StretchSplitAction {
        public StretchToBottom() {
            super(StretchDirection.BOTTOM);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ide/actions/StretchSplitAction$StretchToLeft;", "Lcom/intellij/ide/actions/StretchSplitAction;", "<init>", "()V", "intellij.platform.ide.impl"})
    public static final class StretchToLeft
    extends StretchSplitAction {
        public StretchToLeft() {
            super(StretchDirection.LEFT);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ide/actions/StretchSplitAction$StretchToRight;", "Lcom/intellij/ide/actions/StretchSplitAction;", "<init>", "()V", "intellij.platform.ide.impl"})
    public static final class StretchToRight
    extends StretchSplitAction {
        public StretchToRight() {
            super(StretchDirection.RIGHT);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ide/actions/StretchSplitAction$StretchToTop;", "Lcom/intellij/ide/actions/StretchSplitAction;", "<init>", "()V", "intellij.platform.ide.impl"})
    public static final class StretchToTop
    extends StretchSplitAction {
        public StretchToTop() {
            super(StretchDirection.TOP);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StretchDirection.values().length];
            try {
                nArray[StretchDirection.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StretchDirection.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StretchDirection.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StretchDirection.RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

