/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ToolWindowsGroup
extends ActionGroup
implements DumbAware,
ActionRemoteBehaviorSpecification.Frontend {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToolWindowsGroup.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(ToolWindowsGroup.getEventProject((AnActionEvent)e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ToolWindowsGroup.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        Project project2 = ToolWindowsGroup.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            if (EMPTY_ARRAY == null) {
                ToolWindowsGroup.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        List<ActivateToolWindowAction> result2 = ToolWindowsGroup.getToolWindowActions(project2, false);
        AnAction[] anActionArray = result2.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            ToolWindowsGroup.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    public static List<ActivateToolWindowAction> getToolWindowActions(@NotNull Project project2, boolean shouldSkipShown) {
        if (project2 == null) {
            ToolWindowsGroup.$$$reportNull$$$0(4);
        }
        ActionManager actionManager = ActionManager.getInstance();
        ToolWindowManagerEx manager2 = ToolWindowManagerEx.getInstanceEx(project2);
        ArrayList<ActivateToolWindowAction> result2 = new ArrayList<ActivateToolWindowAction>();
        for (ToolWindow window : manager2.getToolWindows()) {
            String actionId;
            AnAction action2;
            if (shouldSkipShown && window.isShowStripeButton() && window.isAvailable() && manager2.isStripeButtonShow(window) || !((action2 = actionManager.getAction(actionId = ActivateToolWindowAction.Manager.getActionIdForToolWindow(window.getId()))) instanceof ActivateToolWindowAction)) continue;
            result2.add((ActivateToolWindowAction)action2);
        }
        AnAction activateGroup = actionManager.getAction("ActivateToolWindowActions");
        if (activateGroup instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group2 = (DefaultActionGroup)activateGroup;
            for (AnAction child : children2 = group2.getChildren(actionManager)) {
                String windowId;
                ToolWindow window;
                if (!(child instanceof ActivateToolWindowAction) || result2.contains(child) || (window = manager2.getToolWindow(windowId = ((ActivateToolWindowAction)child).getToolWindowId())) != null && window.isShowStripeButton() && shouldSkipShown && manager2.isStripeButtonShow(window)) continue;
                result2.add((ActivateToolWindowAction)child);
            }
        }
        result2.sort(ToolWindowsGroup.getActionComparator());
        return result2;
    }

    @NotNull
    private static Comparator<ActivateToolWindowAction> getActionComparator() {
        Comparator<ActivateToolWindowAction> comparator = ToolWindowsGroup.comparingMnemonic().thenComparing(it -> it.getToolWindowId(), String.CASE_INSENSITIVE_ORDER);
        if (comparator == null) {
            ToolWindowsGroup.$$$reportNull$$$0(5);
        }
        return comparator;
    }

    @NotNull
    private static Comparator<ActivateToolWindowAction> comparingMnemonic() {
        Comparator<ActivateToolWindowAction> comparator = Comparator.comparingInt(it -> {
            int mnemonic = ActivateToolWindowAction.Manager.getMnemonicForToolWindow(it.getToolWindowId());
            return mnemonic != -1 ? mnemonic : Integer.MAX_VALUE;
        });
        if (comparator == null) {
            ToolWindowsGroup.$$$reportNull$$$0(6);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ToolWindowsGroup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ToolWindowsGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionComparator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "comparingMnemonic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

