/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.HTMLEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerFacade;
import com.intellij.platform.ide.customization.ExternalProductResourceUrls;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WhatsNewAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            WhatsNewAction.$$$reportNull$$$0(0);
        }
        boolean available = ExternalProductResourceUrls.getInstance().getWhatIsNewPageUrl() != null;
        e.getPresentation().setEnabledAndVisible(available);
        if (available) {
            e.getPresentation().setText(IdeBundle.messagePointer((String)"whats.new.action.custom.text", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
            e.getPresentation().setDescription(IdeBundle.messagePointer((String)"whats.new.action.custom.description", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            WhatsNewAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        Url whatsNewUrl;
        if (e == null) {
            WhatsNewAction.$$$reportNull$$$0(2);
        }
        if ((whatsNewUrl = ExternalProductResourceUrls.getInstance().getWhatIsNewPageUrl()) == null) {
            throw new IllegalStateException();
        }
        String url = whatsNewUrl.toExternalForm();
        if (ApplicationManager.getApplication().isInternal() && (e.getModifiers() & 1) != 0) {
            String title2 = IdeBundle.message((String)"whats.new.action.custom.text", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
            String prompt = IdeBundle.message((String)"browser.url.popup", (Object[])new Object[0]);
            url = Messages.showInputDialog((Project)e.getProject(), (String)prompt, (String)title2, null, (String)url, null);
            if (url == null) {
                return;
            }
        }
        if ((project2 = e.getProject()) != null && JBCefApp.isSupported() && !ScreenReader.isActive()) {
            WhatsNewAction.openWhatsNewPage(project2, url, false);
        } else {
            BrowserUtil.browse((String)IdeUrlTrackingParametersProvider.getInstance().augmentUrl(url));
        }
    }

    @ApiStatus.Internal
    public static void openWhatsNewPage(@NotNull Project project2, @NotNull String url, boolean onUpgrade) {
        if (project2 == null) {
            WhatsNewAction.$$$reportNull$$$0(3);
        }
        if (url == null) {
            WhatsNewAction.$$$reportNull$$$0(4);
        }
        if (!JBCefApp.isSupported() || ScreenReader.isActive()) {
            String name2 = ApplicationNamesInfo.getInstance().getFullProductName();
            String version = ApplicationInfo.getInstance().getShortVersion();
            String notificationText = IdeBundle.message((String)(ScreenReader.isActive() ? "whats.new.notification.text.regular.language" : "whats.new.notification.text"), (Object[])new Object[]{name2, version});
            ((UpdateCheckerFacade)ApplicationManager.getApplication().getService(UpdateCheckerFacade.class)).getNotificationGroupForIdeUpdateResults().createNotification(notificationText, NotificationType.INFORMATION).setIcon(AllIcons.Nodes.PpWeb).setDisplayId("ide.whats.new").addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"whats.new.notification.action", (Object[])new Object[0]), () -> BrowserUtil.browse((String)url))).notify(project2);
        } else {
            WhatsNewAction.openWhatsNewPage(project2, url, onUpgrade, null);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static FileEditor openWhatsNewPage(@NotNull Project project2, @NotNull String url, boolean includePlatformData, @Nullable HTMLEditorProvider.JsQueryHandler queryHandler) {
        if (project2 == null) {
            WhatsNewAction.$$$reportNull$$$0(5);
        }
        if (url == null) {
            WhatsNewAction.$$$reportNull$$$0(6);
        }
        if (!JBCefApp.isSupported()) {
            throw new IllegalStateException("JCEF is not supported on this system");
        }
        boolean darkTheme = StartupUiUtil.INSTANCE.isDarkTheme();
        Map<String, String> parameters = WhatsNewAction.getRequestParameters(includePlatformData);
        HTMLEditorProvider.Request request = HTMLEditorProvider.Request.url(Urls.newFromEncoded((String)url).addParameters(parameters).toExternalForm());
        try (InputStream stream = WhatsNewAction.class.getResourceAsStream("whatsNewTimeoutText.html");){
            if (stream != null) {
                request.withTimeoutHtml(new String(stream.readAllBytes(), StandardCharsets.UTF_8).replace("__THEME__", darkTheme ? "theme-dark" : "").replace("__TITLE__", IdeBundle.message((String)"whats.new.timeout.title", (Object[])new Object[0])).replace("__MESSAGE__", IdeBundle.message((String)"whats.new.timeout.message", (Object[])new Object[0])).replace("__ACTION__", IdeBundle.message((String)"whats.new.timeout.action", (Object[])new Object[]{url})));
            }
        }
        catch (IOException e) {
            Logger.getInstance(WhatsNewAction.class).error((Throwable)e);
        }
        request.withQueryHandler(queryHandler);
        String title2 = IdeBundle.message((String)"update.whats.new", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        return HTMLEditorProvider.openEditor(project2, title2, request);
    }

    private static Map<String, String> getRequestParameters(boolean includePlatformData) {
        Object theme;
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("var", "embed");
        Object object = theme = StartupUiUtil.INSTANCE.isDarkTheme() ? "dark" : "light";
        if (ExperimentalUI.isNewUI()) {
            theme = (String)theme + "-new-ui";
        }
        parameters.put("theme", (String)theme);
        parameters.put("lang", Locale.getDefault().toLanguageTag().toLowerCase(Locale.ENGLISH));
        if (includePlatformData) {
            String arch;
            String os;
            String string = OS.CURRENT == OS.Windows ? "windows" : (OS.CURRENT == OS.macOS ? "mac" : (os = OS.CURRENT == OS.Linux ? "linux" : null));
            String string2 = CpuArch.CURRENT == CpuArch.X86_64 ? "" : (arch = CpuArch.CURRENT == CpuArch.ARM64 ? "ARM64" : null);
            if (os != null && arch != null) {
                parameters.put("platform", os + arch);
                parameters.put("product", ApplicationInfo.getInstance().getBuild().getProductCode());
            }
        }
        return parameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/WhatsNewAction";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/WhatsNewAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openWhatsNewPage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

