/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.speedSearch;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.speedSearch.SpeedSearchActionHandlerKt;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.speedSearch.SpeedSearchActivator;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0013\u001a\u00020\u000bJ\u0006\u0010\u0014\u001a\u00020\u000bJ\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/ide/actions/speedSearch/SpeedSearchActionHandler;", "", "targetComponent", "Ljavax/swing/JComponent;", "speedSearch", "Lcom/intellij/ui/speedSearch/SpeedSearchActivator;", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/ui/speedSearch/SpeedSearchActivator;)V", "getTargetComponent", "()Ljavax/swing/JComponent;", "requestFocus", "", "getRequestFocus", "()Z", "setRequestFocus", "(Z)V", "showGotItTooltip", "getShowGotItTooltip", "setShowGotItTooltip", "isSpeedSearchAvailable", "isSpeedSearchActive", "activateSpeedSearch", "", "doActivateSpeedSearch", "component", "isPreCloseGotItEvent", "event", "Ljava/awt/event/KeyEvent;", "isCloseGotItEvent", "isInOurFrame", "isGotItCloseKey", "getActionShortcut", "", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSpeedSearchActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpeedSearchActionHandler.kt\ncom/intellij/ide/actions/speedSearch/SpeedSearchActionHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class SpeedSearchActionHandler {
    @NotNull
    private final JComponent targetComponent;
    @NotNull
    private final SpeedSearchActivator speedSearch;
    private boolean requestFocus;
    private boolean showGotItTooltip;

    public SpeedSearchActionHandler(@NotNull JComponent targetComponent, @NotNull SpeedSearchActivator speedSearch2) {
        Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
        Intrinsics.checkNotNullParameter((Object)speedSearch2, (String)"speedSearch");
        this.targetComponent = targetComponent;
        this.speedSearch = speedSearch2;
    }

    @NotNull
    public final JComponent getTargetComponent() {
        return this.targetComponent;
    }

    public final boolean getRequestFocus() {
        return this.requestFocus;
    }

    public final void setRequestFocus(boolean bl) {
        this.requestFocus = bl;
    }

    public final boolean getShowGotItTooltip() {
        return this.showGotItTooltip;
    }

    public final void setShowGotItTooltip(boolean bl) {
        this.showGotItTooltip = bl;
    }

    public final boolean isSpeedSearchAvailable() {
        return this.speedSearch.isAvailable();
    }

    public final boolean isSpeedSearchActive() {
        return this.speedSearch.isActive();
    }

    public final void activateSpeedSearch() {
        if (this.isSpeedSearchAvailable() && !this.isSpeedSearchActive()) {
            if (this.requestFocus) {
                this.targetComponent.requestFocusInWindow();
            }
            this.doActivateSpeedSearch();
        }
    }

    private final void doActivateSpeedSearch() {
        this.speedSearch.activate();
        JComponent jComponent = this.speedSearch.getTextField();
        if (jComponent == null) {
            return;
        }
        JComponent component2 = jComponent;
        if (this.showGotItTooltip) {
            this.showGotItTooltip(component2);
        }
    }

    private final void showGotItTooltip(JComponent component2) {
        String string;
        String shortcut = this.getActionShortcut();
        if (shortcut == null) {
            string = ActionsBundle.message((String)"action.SpeedSearch.GotItTooltip.textWithoutShortcuts", (Object[])new Object[0]);
        } else {
            Object[] objectArray = new Object[]{shortcut};
            string = ActionsBundle.message((String)"action.SpeedSearch.GotItTooltip.text", (Object[])objectArray);
        }
        String gotItMessage = string;
        Intrinsics.checkNotNull((Object)gotItMessage);
        GotItTooltip gotItTooltip = new GotItTooltip("speed.search.shown", gotItMessage, null, 4, null).withPosition(Balloon.Position.atRight);
        IdeEventQueue.Companion.getInstance().addDispatcher(arg_0 -> SpeedSearchActionHandler.showGotItTooltip$lambda$0(this, component2, gotItTooltip, arg_0), (Disposable)gotItTooltip);
        gotItTooltip.show(component2, (Function2<? super Component, ? super Balloon, ? extends Point>)((Function2)SpeedSearchActionHandler::showGotItTooltip$lambda$1));
    }

    private final boolean isPreCloseGotItEvent(KeyEvent event, JComponent component2) {
        return this.isInOurFrame(event, component2) && this.isGotItCloseKey(event) && (event.getID() == 401 || event.getID() == 400);
    }

    private final boolean isCloseGotItEvent(KeyEvent event, JComponent component2) {
        return this.isInOurFrame(event, component2) && this.isGotItCloseKey(event) && event.getID() == 402;
    }

    private final boolean isInOurFrame(KeyEvent event, JComponent component2) {
        Object object;
        return Intrinsics.areEqual((Object)ComponentUtil.getWindow((Component)component2), (Object)ComponentUtil.getWindow((Component)((object = event.getSource()) instanceof Component ? (Component)object : null)));
    }

    private final boolean isGotItCloseKey(KeyEvent event) {
        return event.getModifiersEx() == 0 && (event.getID() == 400 ? SpeedSearchActionHandlerKt.access$getGOT_IT_CLOSE_KEY_CHARS$p().contains(Character.valueOf(event.getKeyChar())) : SpeedSearchActionHandlerKt.access$getGOT_IT_CLOSE_KEY_CODES$p().contains(event.getKeyCode()));
    }

    private final String getActionShortcut() {
        String string;
        Shortcut shortcut;
        Object[] objectArray;
        ShortcutSet shortcutSet;
        AnAction anAction = ActionManager.getInstance().getAction("SpeedSearch");
        if (anAction != null && (shortcutSet = anAction.getShortcutSet()) != null && (objectArray = shortcutSet.getShortcuts()) != null && (shortcut = (Shortcut)ArraysKt.firstOrNull((Object[])objectArray)) != null) {
            Shortcut it = shortcut;
            boolean bl = false;
            string = KeymapUtil.getShortcutText((Shortcut)it);
        } else {
            string = null;
        }
        return string;
    }

    private static final boolean showGotItTooltip$lambda$0(SpeedSearchActionHandler this$0, JComponent $component, GotItTooltip $gotItTooltip, AWTEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof KeyEvent)) {
            bl = false;
        } else if (this$0.isPreCloseGotItEvent((KeyEvent)event, $component)) {
            bl = true;
        } else if (this$0.isCloseGotItEvent((KeyEvent)event, $component)) {
            $gotItTooltip.hidePopup$intellij_platform_ide_impl(true);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final Point showGotItTooltip$lambda$1(Component c, Balloon balloon2) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"<unused var>");
        return new Point(c.getWidth(), c.getHeight() / 2);
    }
}

