/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.OpenInRightSplitAction;
import com.intellij.ide.ui.MouseTracker;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBListWithOpenInRightSplit<T>
extends JBList<T> {
    private final MouseTracker mouseTracker;
    @Nullable
    private final HelpTooltip myTooltip;
    @Nullable
    private final Condition<? super T> myCheckRightSplitter;

    @NotNull
    public static <T> JBList<T> createListWithOpenInRightSplitter(@NotNull ListModel<T> dataModel, @Nullable Condition<? super T> checkRightSplitter) {
        if (dataModel == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(0);
        }
        return Registry.is((String)"lists.use.open.in.right.splitter") ? new JBListWithOpenInRightSplit<T>(dataModel, checkRightSplitter) : new JBList(dataModel);
    }

    private void updateHover() {
        boolean isHovered = this.isHovered();
        this.setCursor(isHovered ? Cursor.getPredefinedCursor(12) : null);
        if (this.myTooltip != null && !isHovered) {
            HelpTooltip.hide((Component)((Object)this));
        }
    }

    private boolean isHovered() {
        int index;
        Point mousePoint = this.mouseTracker.getMousePoint();
        int n = index = mousePoint == null ? -1 : this.locationToIndex(mousePoint);
        if (index == -1) {
            return false;
        }
        Object at = this.getModel().getElementAt(index);
        if (!this.canOpenInSplitter(at)) {
            return false;
        }
        return this.getIconRectangle(index).contains(mousePoint);
    }

    public JBListWithOpenInRightSplit(@NotNull ListModel<T> dataModel, @Nullable Condition<? super T> checkRightSplitter) {
        if (dataModel == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(1);
        }
        super(dataModel);
        this.myCheckRightSplitter = checkRightSplitter;
        this.mouseTracker = new MouseTracker((JComponent)((Object)this));
        this.mouseTracker.addMoveListener(new MouseTracker.MoveListener(){

            @Override
            public void changed(@Nullable Point oldMousePoint, @Nullable Point newMousePoint) {
                JBListWithOpenInRightSplit.this.updateHover();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point point = e.getPoint();
                int index = JBListWithOpenInRightSplit.this.locationToIndex(point);
                if (index != -1 && JBListWithOpenInRightSplit.this.getIconRectangle(index).contains(point)) {
                    JBListWithOpenInRightSplit.this.invokeAction();
                    e.consume();
                }
            }
        });
        AnAction action2 = ActionManager.getInstance().getAction(JBListWithOpenInRightSplit.getActionId());
        if (action2 != null) {
            String text2 = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2);
            this.myTooltip = new HelpTooltip().setTitle(StringUtil.notNullize((String)action2.getTemplatePresentation().getText())).setShortcut(text2);
            this.myTooltip.installOn((JComponent)((Object)this));
            HelpTooltip.setMasterPopupOpenCondition((Component)((Object)this), () -> this.isHovered());
        } else {
            this.myTooltip = null;
        }
        if (action2 != null) {
            OpenInRightSplitAction.Companion.overrideDoubleClickWithOneClick((JComponent)((Object)this));
        }
    }

    public void paint(Graphics g) {
        Rectangle iconRect;
        int index;
        super.paint(g);
        boolean isSelectedUnderMouse = false;
        Point mousePoint = this.mouseTracker.getMousePoint();
        if (mousePoint != null && (index = this.locationToIndex(mousePoint)) != -1 && this.canOpenInSplitter(this.getModel().getElementAt(index))) {
            isSelectedUnderMouse = this.getSelectedIndex() == index;
            iconRect = this.getIconRectangle(index);
            boolean isIconHover = iconRect.contains(mousePoint);
            Icon icon2 = JBListWithOpenInRightSplit.getIcon();
            if (isSelectedUnderMouse) {
                icon2 = IconLoader.getDarkIcon((Icon)icon2, (boolean)true);
            }
            if (!isIconHover && !isSelectedUnderMouse) {
                icon2 = IconLoader.getTransparentIcon((Icon)icon2);
            }
            icon2 = JBListWithOpenInRightSplit.toSize(icon2);
            icon2.paintIcon((Component)((Object)this), g, iconRect.x, iconRect.y);
        }
        if ((index = this.getSelectedIndex()) != -1 && !isSelectedUnderMouse && this.canOpenInSplitter(this.getModel().getElementAt(index))) {
            iconRect = this.getIconRectangle(index);
            Icon icon3 = JBListWithOpenInRightSplit.getIcon();
            icon3 = IconLoader.getDarkIcon((Icon)icon3, (boolean)true);
            icon3 = JBListWithOpenInRightSplit.toSize(icon3);
            icon3.paintIcon((Component)((Object)this), g, iconRect.x, iconRect.y);
        }
    }

    private boolean canOpenInSplitter(@NotNull T item) {
        if (item == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(2);
        }
        return this.myCheckRightSplitter == null || this.myCheckRightSplitter.value(item);
    }

    @NotNull
    private Rectangle getIconRectangle(int index) {
        Rectangle bounds = this.getCellBounds(index, index);
        Rectangle visibleRect = this.getVisibleRect();
        visibleRect.setSize(visibleRect.width - this.getInsets().right, visibleRect.height);
        bounds = bounds.intersection(visibleRect);
        Icon icon2 = JBListWithOpenInRightSplit.toSize(JBListWithOpenInRightSplit.getIcon());
        return new Rectangle((int)bounds.getMaxX() - icon2.getIconWidth(), bounds.y + (bounds.height - icon2.getIconHeight()) / 2, icon2.getIconWidth(), icon2.getIconHeight());
    }

    @NotNull
    private static Icon toSize(@NotNull Icon icon2) {
        if (icon2 == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(3);
        }
        Dimension defaultSize = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
        Icon icon3 = IconUtil.toSize((Icon)icon2, (int)((int)defaultSize.getWidth()), (int)((int)defaultSize.getHeight()));
        if (icon3 == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(4);
        }
        return icon3;
    }

    private void invokeAction() {
        HelpTooltip.dispose((Component)((Object)this));
        AnAction action2 = ActionManager.getInstance().getAction(JBListWithOpenInRightSplit.getActionId());
        ActionUtil.invokeAction((AnAction)action2, (Component)((Object)this), (String)((Object)((Object)this)).getClass().getName(), null, null);
    }

    public Dimension getPreferredSize() {
        Dimension size2 = new Dimension(super.getPreferredSize());
        size2.width += ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width;
        return size2;
    }

    @NotNull
    @NonNls
    private static String getActionId() {
        return "OpenInRightSplit";
    }

    @NotNull
    private static Icon getIcon() {
        Icon icon2 = AllIcons.Actions.SplitVertically;
        if (icon2 == null) {
            JBListWithOpenInRightSplit.$$$reportNull$$$0(5);
        }
        return icon2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ui/JBListWithOpenInRightSplit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ui/JBListWithOpenInRightSplit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toSize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createListWithOpenInRightSplitter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canOpenInSplitter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toSize";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

