/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.GeneralLocalSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.ConfigurableWebBrowser;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.ReloadMode;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.table.IconTableCellRenderer;
import com.intellij.util.ui.table.TableModelEditor;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0019H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016J\u000e\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006'"}, d2={"Lcom/intellij/ide/browsers/BrowserSettingsConfigurable;", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "<init>", "()V", "browsersTable", "Ljavax/swing/JComponent;", "browsersEditor", "Lcom/intellij/util/ui/table/TableModelEditor;", "Lcom/intellij/ide/browsers/ConfigurableWebBrowser;", "alternativeBrowserPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "defaultBrowserPolicyComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/ide/browsers/DefaultBrowserPolicy;", "serverReloadModeComboBox", "Lcom/intellij/ide/browsers/ReloadMode;", "previewReloadModeComboBox", "showBrowserHover", "Lcom/intellij/ui/components/JBCheckBox;", "showBrowserHoverXml", "customPathValue", "", "root", "Lcom/intellij/openapi/ui/DialogPanel;", "updateCustomPathTextFieldValue", "", "browser", "setCustomPathToFirstListed", "createComponent", "isModified", "", "apply", "defaultBrowser", "getDefaultBrowser", "()Lcom/intellij/ide/browsers/DefaultBrowserPolicy;", "reset", "selectBrowser", "Lcom/intellij/ide/browsers/WebBrowser;", "Companion", "intellij.platform.ide.impl"})
public final class BrowserSettingsConfigurable
implements UnnamedConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private JComponent browsersTable;
    private TableModelEditor<ConfigurableWebBrowser> browsersEditor;
    private TextFieldWithBrowseButton alternativeBrowserPathField;
    private ComboBox<DefaultBrowserPolicy> defaultBrowserPolicyComboBox;
    private ComboBox<ReloadMode> serverReloadModeComboBox;
    private ComboBox<ReloadMode> previewReloadModeComboBox;
    private JBCheckBox showBrowserHover;
    private JBCheckBox showBrowserHoverXml;
    @Nullable
    private String customPathValue;
    @Nullable
    private DialogPanel root;
    @NotNull
    private static final TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String> PATH_COLUMN_INFO;
    @NotNull
    private static final TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, Boolean> ACTIVE_COLUMN_INFO;
    @NotNull
    private static final ColumnInfo<?, ?>[] COLUMNS;

    private final void updateCustomPathTextFieldValue(DefaultBrowserPolicy browser) {
        switch (WhenMappings.$EnumSwitchMapping$0[browser.ordinal()]) {
            case 1: {
                TextFieldWithBrowseButton textFieldWithBrowseButton = this.alternativeBrowserPathField;
                if (textFieldWithBrowseButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
                    textFieldWithBrowseButton = null;
                }
                textFieldWithBrowseButton.setText(this.customPathValue);
                break;
            }
            case 2: {
                this.setCustomPathToFirstListed();
                break;
            }
            default: {
                TextFieldWithBrowseButton textFieldWithBrowseButton = this.alternativeBrowserPathField;
                if (textFieldWithBrowseButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
                    textFieldWithBrowseButton = null;
                }
                textFieldWithBrowseButton.setText("");
            }
        }
    }

    private final void setCustomPathToFirstListed() {
        TableModelEditor<ConfigurableWebBrowser> tableModelEditor = this.browsersEditor;
        if (tableModelEditor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browsersEditor");
            tableModelEditor = null;
        }
        ListTableModel<ConfigurableWebBrowser> listTableModel = tableModelEditor.getModel();
        Intrinsics.checkNotNullExpressionValue(listTableModel, (String)"getModel(...)");
        ListTableModel<ConfigurableWebBrowser> model2 = listTableModel;
        int n = model2.getRowCount();
        for (int i2 = 0; i2 < n; ++i2) {
            ConfigurableWebBrowser browser = (ConfigurableWebBrowser)((Object)model2.getRowValue(i2));
            if (!browser.isActive() || browser.getPath() == null) continue;
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.alternativeBrowserPathField;
            if (textFieldWithBrowseButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
                textFieldWithBrowseButton = null;
            }
            textFieldWithBrowseButton.setText(browser.getPath());
            return;
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.alternativeBrowserPathField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
            textFieldWithBrowseButton = null;
        }
        textFieldWithBrowseButton.setText("");
    }

    @Nullable
    public JComponent createComponent() {
        this.root = com.intellij.ui.dsl.builder.BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> BrowserSettingsConfigurable.createComponent$lambda$0(this, arg_0)));
        return (JComponent)this.root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        TableModelEditor<ConfigurableWebBrowser> tableModelEditor;
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        DefaultBrowserPolicy defaultBrowserPolicy = this.getDefaultBrowser();
        Intrinsics.checkNotNull((Object)((Object)browserManager));
        if (BrowserSettingsConfigurable.Companion.getDefaultBrowserPolicy(browserManager) != defaultBrowserPolicy) return true;
        boolean bl = browserManager.isShowBrowserHover();
        JBCheckBox jBCheckBox = this.showBrowserHover;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHover");
            jBCheckBox = null;
        }
        if (bl != jBCheckBox.isSelected()) return true;
        boolean bl2 = browserManager.isShowBrowserHoverXml();
        JBCheckBox jBCheckBox2 = this.showBrowserHoverXml;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHoverXml");
            jBCheckBox2 = null;
        }
        if (bl2 != jBCheckBox2.isSelected()) return true;
        ReloadMode reloadMode = browserManager.getWebPreviewReloadMode();
        ComboBox<ReloadMode> comboBox = this.previewReloadModeComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewReloadModeComboBox");
            comboBox = null;
        }
        if (reloadMode != comboBox.getItem()) return true;
        ReloadMode reloadMode2 = browserManager.getWebServerReloadMode();
        ComboBox<ReloadMode> comboBox2 = this.serverReloadModeComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverReloadModeComboBox");
            comboBox2 = null;
        }
        if (reloadMode2 != comboBox2.getItem()) {
            return true;
        }
        if (defaultBrowserPolicy == DefaultBrowserPolicy.ALTERNATIVE) {
            String string = GeneralLocalSettings.Companion.getInstance().getBrowserPath();
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.alternativeBrowserPathField;
            if (textFieldWithBrowseButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
                textFieldWithBrowseButton = null;
            }
            if (!Comparing.strEqual((String)string, (String)textFieldWithBrowseButton.getText())) {
                return true;
            }
        }
        if ((tableModelEditor = this.browsersEditor) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browsersEditor");
            tableModelEditor = null;
        }
        boolean bl3 = tableModelEditor.isModified();
        return bl3;
    }

    public void apply() {
        GeneralLocalSettings settings = GeneralLocalSettings.Companion.getInstance();
        settings.setUseDefaultBrowser(this.getDefaultBrowser() == DefaultBrowserPolicy.SYSTEM);
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.alternativeBrowserPathField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
            textFieldWithBrowseButton = null;
        }
        if (textFieldWithBrowseButton.isEnabled()) {
            TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.alternativeBrowserPathField;
            if (textFieldWithBrowseButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
                textFieldWithBrowseButton2 = null;
            }
            String string = textFieldWithBrowseButton2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            settings.setBrowserPath(string);
        }
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        JBCheckBox jBCheckBox = this.showBrowserHover;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHover");
            jBCheckBox = null;
        }
        browserManager.setShowBrowserHover(jBCheckBox.isSelected());
        JBCheckBox jBCheckBox2 = this.showBrowserHoverXml;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHoverXml");
            jBCheckBox2 = null;
        }
        browserManager.setShowBrowserHoverXml(jBCheckBox2.isSelected());
        browserManager.defaultBrowserPolicy = this.getDefaultBrowser();
        ComboBox<ReloadMode> comboBox = this.previewReloadModeComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewReloadModeComboBox");
            comboBox = null;
        }
        browserManager.webPreviewReloadMode = (ReloadMode)comboBox.getItem();
        ComboBox<ReloadMode> comboBox2 = this.serverReloadModeComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverReloadModeComboBox");
            comboBox2 = null;
        }
        browserManager.webServerReloadMode = (ReloadMode)comboBox2.getItem();
        TableModelEditor<ConfigurableWebBrowser> tableModelEditor = this.browsersEditor;
        if (tableModelEditor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browsersEditor");
            tableModelEditor = null;
        }
        browserManager.setList(tableModelEditor.apply());
    }

    private final DefaultBrowserPolicy getDefaultBrowser() {
        ComboBox<DefaultBrowserPolicy> comboBox = this.defaultBrowserPolicyComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultBrowserPolicyComboBox");
            comboBox = null;
        }
        Object object = comboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ide.browsers.DefaultBrowserPolicy");
        return (DefaultBrowserPolicy)((Object)object);
    }

    public void reset() {
        WebBrowserManager browserManager = WebBrowserManager.getInstance();
        Intrinsics.checkNotNull((Object)((Object)browserManager));
        DefaultBrowserPolicy effectiveDefaultBrowserPolicy = BrowserSettingsConfigurable.Companion.getDefaultBrowserPolicy(browserManager);
        ComboBox<DefaultBrowserPolicy> comboBox = this.defaultBrowserPolicyComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultBrowserPolicyComboBox");
            comboBox = null;
        }
        comboBox.setSelectedItem((Object)effectiveDefaultBrowserPolicy);
        ComboBox<ReloadMode> comboBox2 = this.previewReloadModeComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewReloadModeComboBox");
            comboBox2 = null;
        }
        comboBox2.setItem((Object)browserManager.getWebPreviewReloadMode());
        ComboBox<ReloadMode> comboBox3 = this.serverReloadModeComboBox;
        if (comboBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverReloadModeComboBox");
            comboBox3 = null;
        }
        comboBox3.setItem((Object)browserManager.getWebServerReloadMode());
        JBCheckBox jBCheckBox = this.showBrowserHover;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHover");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(browserManager.isShowBrowserHover());
        JBCheckBox jBCheckBox2 = this.showBrowserHoverXml;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showBrowserHoverXml");
            jBCheckBox2 = null;
        }
        jBCheckBox2.setSelected(browserManager.isShowBrowserHoverXml());
        TableModelEditor<ConfigurableWebBrowser> tableModelEditor = this.browsersEditor;
        if (tableModelEditor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browsersEditor");
            tableModelEditor = null;
        }
        tableModelEditor.reset(browserManager.getList());
        this.customPathValue = GeneralLocalSettings.Companion.getInstance().getBrowserPath();
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.alternativeBrowserPathField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
            textFieldWithBrowseButton = null;
        }
        textFieldWithBrowseButton.setEnabled(effectiveDefaultBrowserPolicy == DefaultBrowserPolicy.ALTERNATIVE);
        this.updateCustomPathTextFieldValue(effectiveDefaultBrowserPolicy);
    }

    public final void selectBrowser(@NotNull WebBrowser browser) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        if (browser instanceof ConfigurableWebBrowser) {
            TableModelEditor<ConfigurableWebBrowser> tableModelEditor = this.browsersEditor;
            if (tableModelEditor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"browsersEditor");
                tableModelEditor = null;
            }
            tableModelEditor.selectItem((ConfigurableWebBrowser)browser);
        }
    }

    private static final Unit createComponent$lambda$0(BrowserSettingsConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        TableModelEditor.DialogItemEditor itemEditor2 = new TableModelEditor.DialogItemEditor<ConfigurableWebBrowser>(this$0){
            final /* synthetic */ BrowserSettingsConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            public Class<ConfigurableWebBrowser> getItemClass() {
                return ConfigurableWebBrowser.class;
            }

            public ConfigurableWebBrowser clone(ConfigurableWebBrowser item, boolean forInPlaceEditing) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                return new ConfigurableWebBrowser(forInPlaceEditing ? item.getId() : UUID.randomUUID(), item.getFamily(), item.getName(), item.getPath(), item.isActive(), forInPlaceEditing ? item.getSpecificSettings() : this.cloneSettings(item));
            }

            public void edit(ConfigurableWebBrowser browser, Function<? super ConfigurableWebBrowser, ? extends ConfigurableWebBrowser> mutator, boolean isAdd) {
                Intrinsics.checkNotNullParameter((Object)((Object)browser), (String)"browser");
                Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
                BrowserSpecificSettings settings = this.cloneSettings(browser);
                if (settings != null) {
                    ShowSettingsUtil showSettingsUtil = ShowSettingsUtil.getInstance();
                    JComponent jComponent = BrowserSettingsConfigurable.access$getBrowsersTable$p(this.this$0);
                    if (jComponent == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"browsersTable");
                        jComponent = null;
                    }
                    if (showSettingsUtil.editConfigurable((Component)jComponent, settings.createConfigurable())) {
                        ((ConfigurableWebBrowser)((Object)mutator.fun((Object)((Object)browser)))).setSpecificSettings(settings);
                    }
                }
            }

            private final BrowserSpecificSettings cloneSettings(ConfigurableWebBrowser browser) {
                BrowserSpecificSettings browserSpecificSettings = browser.getSpecificSettings();
                if (browserSpecificSettings == null) {
                    return null;
                }
                BrowserSpecificSettings settings = browserSpecificSettings;
                BrowserSpecificSettings browserSpecificSettings2 = browser.getFamily().createBrowserSpecificSettings();
                Intrinsics.checkNotNull((Object)browserSpecificSettings2);
                BrowserSpecificSettings newSettings = browserSpecificSettings2;
                TableModelEditor.cloneUsingXmlSerialization(settings, newSettings);
                return newSettings;
            }

            public void applyEdited(ConfigurableWebBrowser oldItem, ConfigurableWebBrowser newItem) {
                Intrinsics.checkNotNullParameter((Object)((Object)oldItem), (String)"oldItem");
                Intrinsics.checkNotNullParameter((Object)((Object)newItem), (String)"newItem");
                oldItem.setSpecificSettings(newItem.getSpecificSettings());
            }

            public boolean isEditable(ConfigurableWebBrowser browser) {
                Intrinsics.checkNotNullParameter((Object)((Object)browser), (String)"browser");
                return browser.getSpecificSettings() != null;
            }

            public boolean isRemovable(ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                return !WebBrowserManager.getInstance().isPredefinedBrowser(item);
            }
        };
        TableModelEditor tableModelEditor = new TableModelEditor(COLUMNS, itemEditor2, IdeBundle.message((String)"settings.browsers.no.web.browsers.configured", (Object[])new Object[0])).modelListener(new TableModelEditor.DataChangedListener<ConfigurableWebBrowser>(this$0){
            final /* synthetic */ BrowserSettingsConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            public void tableChanged(TableModelEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.update();
            }

            public void dataChanged(ColumnInfo<ConfigurableWebBrowser, ?> columnInfo, int rowIndex) {
                Intrinsics.checkNotNullParameter(columnInfo, (String)"columnInfo");
                if (columnInfo == BrowserSettingsConfigurable.access$getPATH_COLUMN_INFO$cp() || columnInfo == BrowserSettingsConfigurable.access$getACTIVE_COLUMN_INFO$cp()) {
                    this.update();
                }
            }

            private final void update() {
                if (BrowserSettingsConfigurable.access$getDefaultBrowser(this.this$0) == DefaultBrowserPolicy.FIRST) {
                    BrowserSettingsConfigurable.access$setCustomPathToFirstListed(this.this$0);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue(tableModelEditor, (String)"modelListener(...)");
        this$0.browsersEditor = tableModelEditor;
        Panel.row$default($this$panel, null, arg_0 -> BrowserSettingsConfigurable.createComponent$lambda$0$0(this$0, arg_0), 1, null).resizableRow();
        String string = IdeBundle.message((String)"settings.browsers.default.browser", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, (Function1<? super Row, Unit>)((Function1)arg_0 -> BrowserSettingsConfigurable.createComponent$lambda$0$1(this$0, arg_0)));
        Panel.group$default($this$panel, IdeBundle.message((String)"settings.browsers.show.browser.popup.in.the.editor", (Object[])new Object[0]), false, arg_0 -> BrowserSettingsConfigurable.createComponent$lambda$0$2(this$0, arg_0), 2, null);
        Panel.group$default($this$panel, IdeBundle.message((String)"settings.browsers.reload.behavior", (Object[])new Object[0]), false, arg_0 -> BrowserSettingsConfigurable.createComponent$lambda$0$3(this$0, arg_0), 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$0(BrowserSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TableModelEditor<ConfigurableWebBrowser> tableModelEditor = this$0.browsersEditor;
        if (tableModelEditor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"browsersEditor");
            tableModelEditor = null;
        }
        JComponent jComponent = tableModelEditor.createComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createComponent(...)");
        this$0.browsersTable = $this$row.cell(jComponent).align(Align.FILL).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$1(BrowserSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ArrayList<DefaultBrowserPolicy> defaultBrowserPolicies = new ArrayList<DefaultBrowserPolicy>();
        if (BrowserLauncherAppless.Companion.canUseSystemDefaultBrowserPolicy()) {
            defaultBrowserPolicies.add(DefaultBrowserPolicy.SYSTEM);
        }
        defaultBrowserPolicies.add(DefaultBrowserPolicy.FIRST);
        defaultBrowserPolicies.add(DefaultBrowserPolicy.ALTERNATIVE);
        this$0.defaultBrowserPolicyComboBox = $this$row.comboBox((Collection)defaultBrowserPolicies, BuilderKt.textListCellRenderer((String)"", BrowserSettingsConfigurable::createComponent$lambda$0$1$0)).applyToComponent(arg_0 -> BrowserSettingsConfigurable.createComponent$lambda$0$1$1(this$0, arg_0)).getComponent();
        this$0.alternativeBrowserPathField = (TextFieldWithBrowseButton)$this$row.cell((JComponent)new TextFieldWithBrowseButton()).applyToComponent((Function1<JComponent, Unit>)((Function1)BrowserSettingsConfigurable::createComponent$lambda$0$1$2)).align(AlignX.FILL.INSTANCE).getComponent();
        return Unit.INSTANCE;
    }

    private static final String createComponent$lambda$0$1$0(DefaultBrowserPolicy value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        return switch (WhenMappings.$EnumSwitchMapping$0[value.ordinal()]) {
            case 3 -> IdeBundle.message((String)"settings.browsers.system.default", (Object[])new Object[0]);
            case 2 -> IdeBundle.message((String)"settings.browsers.first.listed", (Object[])new Object[0]);
            case 1 -> IdeBundle.message((String)"settings.browsers.custom.path", (Object[])new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit createComponent$lambda$0$1$1(BrowserSettingsConfigurable this$0, ComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addItemListener(arg_0 -> BrowserSettingsConfigurable.createComponent$lambda$0$1$1$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final void createComponent$lambda$0$1$1$0(BrowserSettingsConfigurable this$0, ItemEvent e) {
        boolean customPathEnabled;
        boolean bl = customPathEnabled = e.getItem() == DefaultBrowserPolicy.ALTERNATIVE;
        if (e.getStateChange() == 2) {
            if (customPathEnabled) {
                TextFieldWithBrowseButton textFieldWithBrowseButton = this$0.alternativeBrowserPathField;
                if (textFieldWithBrowseButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
                    textFieldWithBrowseButton = null;
                }
                this$0.customPathValue = textFieldWithBrowseButton.getText();
            }
        } else if (e.getStateChange() == 1) {
            TextFieldWithBrowseButton textFieldWithBrowseButton = this$0.alternativeBrowserPathField;
            if (textFieldWithBrowseButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"alternativeBrowserPathField");
                textFieldWithBrowseButton = null;
            }
            textFieldWithBrowseButton.setEnabled(customPathEnabled);
            Object object = e.getItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ide.browsers.DefaultBrowserPolicy");
            this$0.updateCustomPathTextFieldValue((DefaultBrowserPolicy)((Object)object));
        }
    }

    private static final Unit createComponent$lambda$0$1$2(TextFieldWithBrowseButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addBrowseFolderListener(null, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor().withTitle(IdeBundle.message((String)"title.select.path.to.browser", (Object[])new Object[0])));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$2(BrowserSettingsConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default($this$group, null, arg_0 -> BrowserSettingsConfigurable.createComponent$lambda$0$2$0(this$0, arg_0), 1, null);
        Panel.row$default($this$group, null, arg_0 -> BrowserSettingsConfigurable.createComponent$lambda$0$2$1(this$0, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$2$0(BrowserSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"settings.browsers.show.browser.popup.html", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.showBrowserHover = $this$row.checkBox(string).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$2$1(BrowserSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"settings.browsers.show.browser.popup.xml", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.showBrowserHoverXml = $this$row.checkBox(string).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$3(BrowserSettingsConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        String string = IdeBundle.message((String)"setting.value.reload.mode.server", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$group.row(string, (Function1<? super Row, Unit>)((Function1)arg_0 -> BrowserSettingsConfigurable.createComponent$lambda$0$3$0(this$0, arg_0)));
        String string2 = IdeBundle.message((String)"setting.value.reload.mode.preview", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$group.row(string2, (Function1<? super Row, Unit>)((Function1)arg_0 -> BrowserSettingsConfigurable.createComponent$lambda$0$3$1(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$0$3$0(BrowserSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.serverReloadModeComboBox = $this$row.comboBox((Collection)ReloadMode.getEntries(), BuilderKt.textListCellRenderer((String)"", BrowserSettingsConfigurable::createComponent$lambda$0$3$0$0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final String createComponent$lambda$0$3$0$0(ReloadMode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTitle();
    }

    private static final Unit createComponent$lambda$0$3$1(BrowserSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.previewReloadModeComboBox = $this$row.comboBox((Collection)ReloadMode.getEntries(), BuilderKt.textListCellRenderer((String)"", BrowserSettingsConfigurable::createComponent$lambda$0$3$1$0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final String createComponent$lambda$0$3$1$0(ReloadMode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTitle();
    }

    public static final /* synthetic */ JComponent access$getBrowsersTable$p(BrowserSettingsConfigurable $this) {
        return $this.browsersTable;
    }

    public static final /* synthetic */ TableModelEditor.EditableColumnInfo access$getPATH_COLUMN_INFO$cp() {
        return PATH_COLUMN_INFO;
    }

    public static final /* synthetic */ TableModelEditor.EditableColumnInfo access$getACTIVE_COLUMN_INFO$cp() {
        return ACTIVE_COLUMN_INFO;
    }

    public static final /* synthetic */ DefaultBrowserPolicy access$getDefaultBrowser(BrowserSettingsConfigurable $this) {
        return $this.getDefaultBrowser();
    }

    public static final /* synthetic */ void access$setCustomPathToFirstListed(BrowserSettingsConfigurable $this) {
        $this.setCustomPathToFirstListed();
    }

    static {
        ColumnInfo[] columnInfoArray = IdeBundle.message((String)"settings.browsers.column.path", (Object[])new Object[0]);
        PATH_COLUMN_INFO = new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String>((String)columnInfoArray){

            public String valueOf(ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                return PathUtil.toSystemDependentName((String)item.getPath());
            }

            public void setValue(ConfigurableWebBrowser item, String value) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                item.setPath(value);
            }

            public TableCellEditor getEditor(ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                return (TableCellEditor)((Object)new LocalPathCellEditor().fileChooserDescriptor(FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor()).normalizePath(true));
            }
        };
        ACTIVE_COLUMN_INFO = new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, Boolean>(){

            public Class<?> getColumnClass() {
                return Boolean.TYPE;
            }

            public Boolean valueOf(ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                return item.isActive();
            }

            public void setValue(ConfigurableWebBrowser item, boolean value) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                item.setActive(value);
            }
        };
        columnInfoArray = new ColumnInfo[4];
        columnInfoArray[0] = ACTIVE_COLUMN_INFO;
        String string = IdeBundle.message((String)"settings.browsers.column.name", (Object[])new Object[0]);
        columnInfoArray[1] = new TableModelEditor.EditableColumnInfo<ConfigurableWebBrowser, String>(string){

            public String valueOf(ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                String string = item.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return string;
            }

            public void setValue(ConfigurableWebBrowser item, String value) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                item.setName(value);
            }
        };
        string = IdeBundle.message((String)"settings.browsers.column.family", (Object[])new Object[0]);
        columnInfoArray[2] = new ColumnInfo<ConfigurableWebBrowser, BrowserFamily>(string){

            public Class<?> getColumnClass() {
                return BrowserFamily.class;
            }

            public BrowserFamily valueOf(ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                BrowserFamily browserFamily = item.getFamily();
                Intrinsics.checkNotNullExpressionValue((Object)browserFamily, (String)"getFamily(...)");
                return browserFamily;
            }

            public void setValue(ConfigurableWebBrowser item, BrowserFamily value) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                item.setFamily(value);
                item.setSpecificSettings(value.createBrowserSpecificSettings());
            }

            public TableCellRenderer getRenderer(ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                IconTableCellRenderer<Iconable> iconTableCellRenderer = IconTableCellRenderer.ICONABLE;
                Intrinsics.checkNotNullExpressionValue(iconTableCellRenderer, (String)"ICONABLE");
                return iconTableCellRenderer;
            }

            public boolean isCellEditable(ConfigurableWebBrowser item) {
                Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                return !WebBrowserManager.getInstance().isPredefinedBrowser(item);
            }
        };
        columnInfoArray[3] = PATH_COLUMN_INFO;
        COLUMNS = columnInfoArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/browsers/BrowserSettingsConfigurable$Companion;", "", "<init>", "()V", "PATH_COLUMN_INFO", "Lcom/intellij/util/ui/table/TableModelEditor$EditableColumnInfo;", "Lcom/intellij/ide/browsers/ConfigurableWebBrowser;", "", "ACTIVE_COLUMN_INFO", "", "COLUMNS", "", "Lcom/intellij/util/ui/ColumnInfo;", "[Lcom/intellij/util/ui/ColumnInfo;", "getDefaultBrowserPolicy", "Lcom/intellij/ide/browsers/DefaultBrowserPolicy;", "manager", "Lcom/intellij/ide/browsers/WebBrowserManager;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final DefaultBrowserPolicy getDefaultBrowserPolicy(WebBrowserManager manager2) {
            DefaultBrowserPolicy defaultBrowserPolicy = manager2.getDefaultBrowserPolicy();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)defaultBrowserPolicy), (String)"getDefaultBrowserPolicy(...)");
            DefaultBrowserPolicy policy = defaultBrowserPolicy;
            return policy != DefaultBrowserPolicy.SYSTEM || BrowserLauncherAppless.Companion.canUseSystemDefaultBrowserPolicy() ? policy : DefaultBrowserPolicy.ALTERNATIVE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DefaultBrowserPolicy.values().length];
            try {
                nArray[DefaultBrowserPolicy.ALTERNATIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DefaultBrowserPolicy.FIRST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DefaultBrowserPolicy.SYSTEM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

