/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserActionKt;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.util.BitUtil;
import com.intellij.util.Url;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/browsers/actions/BaseOpenInBrowserAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "<init>", "(Lcom/intellij/ide/browsers/WebBrowser;)V", "getBrowser", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "Handler", "intellij.platform.ide.impl"})
public final class BaseOpenInBrowserAction
extends DumbAwareAction {
    @NotNull
    private final WebBrowser browser;

    public BaseOpenInBrowserAction(@NotNull WebBrowser browser) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        super(() -> BaseOpenInBrowserAction._init_$lambda$0(browser), null, () -> BaseOpenInBrowserAction._init_$lambda$1(browser));
        this.browser = browser;
    }

    private final WebBrowser getBrowser() {
        return WebBrowserManager.getInstance().isActive(this.browser) && this.browser.getPath() != null ? this.browser : null;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        WebBrowser browser = this.getBrowser();
        if (browser == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        OpenInBrowserRequest result2 = null;
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"unknown")) {
            DataContext dataContext2 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            OpenInBrowserRequest openInBrowserRequest = result2 = BaseOpenInBrowserActionKt.access$createRequest(dataContext2, true);
            boolean isApplicable = openInBrowserRequest != null ? openInBrowserRequest.isPhysicalFile() : false;
            e.getPresentation().setEnabledAndVisible(isApplicable);
            if (!isApplicable) {
                return;
            }
            OpenInBrowserRequest openInBrowserRequest2 = result2;
            v3 = openInBrowserRequest2;
            Intrinsics.checkNotNull((Object)openInBrowserRequest2);
        } else {
            OpenInBrowserRequest openInBrowserRequest = Handler.doUpdate(e);
            if (openInBrowserRequest == null) {
                return;
            }
            result2 = openInBrowserRequest;
            v3 = Unit.INSTANCE;
        }
        Object description = this.getTemplatePresentation().getText();
        if (Intrinsics.areEqual((Object)"ContextToolbar", (Object)e.getPlace())) {
            String string;
            Shortcut shortcut = KeymapUtil.getPrimaryShortcut((String)"WebOpenInAction");
            boolean htmlFile = WebBrowserXmlService.Companion.getInstance().isHtmlFile((PsiElement)result2.getFile());
            if (shortcut != null && htmlFile) {
                Object[] objectArray = new Object[]{KeymapUtil.getShortcutText((Shortcut)shortcut)};
                string = IdeBundle.message((String)"browser.shortcut.or.shift", (Object[])objectArray);
            } else {
                string = shortcut != null && !htmlFile ? KeymapUtil.getShortcutText((Shortcut)shortcut) : (shortcut == null && htmlFile ? IdeBundle.message((String)"browser.shortcut", (Object[])new Object[0]) : "");
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String shortcutInfo = string2;
            if (((CharSequence)shortcutInfo).length() > 0) {
                description = (String)description + " (" + shortcutInfo + ")";
            }
        }
        e.getPresentation().setText((String)description);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            WebBrowser webBrowser = this.getBrowser();
            if (webBrowser == null) break block0;
            WebBrowser it = webBrowser;
            boolean bl = false;
            Handler.INSTANCE.openInBrowser$intellij_platform_ide_impl(e, it);
        }
    }

    private static final String _init_$lambda$0(WebBrowser $browser) {
        return $browser.getName();
    }

    private static final Icon _init_$lambda$1(WebBrowser $browser) {
        return $browser.getIcon();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J+\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u001f\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/browsers/actions/BaseOpenInBrowserAction$Handler;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "doUpdate", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "openInBrowser", "", "request", "preferLocalUrl", "", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "openInBrowser$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nBaseOpenInBrowserAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseOpenInBrowserAction.kt\ncom/intellij/ide/browsers/actions/BaseOpenInBrowserAction$Handler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,168:1\n13#2:169\n*S KotlinDebug\n*F\n+ 1 BaseOpenInBrowserAction.kt\ncom/intellij/ide/browsers/actions/BaseOpenInBrowserAction$Handler\n*L\n28#1:169\n*E\n"})
    public static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();
        @NotNull
        private static final Logger LOG;

        private Handler() {
        }

        @JvmStatic
        @Nullable
        public static final OpenInBrowserRequest doUpdate(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DataContext dataContext2 = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            OpenInBrowserRequest request = BaseOpenInBrowserActionKt.access$createRequest(dataContext2, false);
            boolean applicable = request != null && SequencesKt.any(WebBrowserServiceImpl.Companion.getProviders(request));
            event.getPresentation().setEnabledAndVisible(applicable);
            return applicable ? request : null;
        }

        public final void openInBrowser$intellij_platform_ide_impl(@NotNull OpenInBrowserRequest request, boolean preferLocalUrl, @Nullable WebBrowser browser) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            try {
                Collection collection = WebBrowserService.getInstance().getUrlsToOpen(request, preferLocalUrl);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getUrlsToOpen(...)");
                Collection urls = collection;
                if (!urls.isEmpty()) {
                    BaseOpenInBrowserActionKt.chooseUrl(urls).onSuccess(arg_0 -> Handler.openInBrowser$lambda$1(arg_0 -> Handler.openInBrowser$lambda$0(browser, request, arg_0), arg_0));
                }
            }
            catch (WebBrowserUrlProvider.BrowserException e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)IdeBundle.message((String)"browser.error", (Object[])new Object[0]));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        public static /* synthetic */ void openInBrowser$intellij_platform_ide_impl$default(Handler handler, OpenInBrowserRequest openInBrowserRequest, boolean bl, WebBrowser webBrowser, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                webBrowser = null;
            }
            handler.openInBrowser$intellij_platform_ide_impl(openInBrowserRequest, bl, webBrowser);
        }

        public final void openInBrowser$intellij_platform_ide_impl(@NotNull AnActionEvent event, @Nullable WebBrowser browser) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DataContext dataContext2 = event.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
                OpenInBrowserRequest openInBrowserRequest = BaseOpenInBrowserActionKt.access$createRequest(dataContext2, true);
                if (openInBrowserRequest == null) break block0;
                OpenInBrowserRequest it = openInBrowserRequest;
                boolean bl = false;
                INSTANCE.openInBrowser$intellij_platform_ide_impl(it, BitUtil.isSet((int)event.getModifiers(), (int)1), browser);
            }
        }

        private static final Unit openInBrowser$lambda$0(WebBrowser $browser, OpenInBrowserRequest $request, Url url) {
            FileDocumentManager.getInstance().saveAllDocuments();
            BrowserLauncher browserLauncher = BrowserLauncher.Companion.getInstance();
            String string = url.toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
            browserLauncher.browse(string, $browser, $request.getProject());
            return Unit.INSTANCE;
        }

        private static final void openInBrowser$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        static {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(BaseOpenInBrowserAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }
    }
}

