/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import com.intellij.util.ArrayUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class TransferableList<T>
implements Transferable {
    private static final DataFlavor LIST_DATA_FLAVOR = new DataFlavor(List.class, "Transferable List");
    private static final DataFlavor ALL_HTML_DATA_FLAVOR = DataFlavor.allHtmlFlavor;
    private static final DataFlavor PART_HTML_DATA_FLAVOR = DataFlavor.fragmentHtmlFlavor;
    private final List<T> myList;

    @SafeVarargs
    public TransferableList(T ... array) {
        if (array == null) {
            TransferableList.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(array));
    }

    public TransferableList(List<? extends T> list2) {
        this.myList = Collections.unmodifiableList(list2);
    }

    @Override
    public DataFlavor @NotNull [] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{ALL_HTML_DATA_FLAVOR, PART_HTML_DATA_FLAVOR, DataFlavor.stringFlavor, LIST_DATA_FLAVOR};
        if (dataFlavorArray == null) {
            TransferableList.$$$reportNull$$$0(1);
        }
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor2) {
        return ArrayUtil.contains((Object)flavor2, (Object[])this.getTransferDataFlavors());
    }

    @Override
    public Object getTransferData(DataFlavor flavor2) throws UnsupportedFlavorException, IOException {
        if (flavor2.equals(ALL_HTML_DATA_FLAVOR)) {
            return this.getHTML(this.myList, true);
        }
        if (flavor2.equals(PART_HTML_DATA_FLAVOR)) {
            return this.getHTML(this.myList, false);
        }
        if (flavor2.equals(DataFlavor.stringFlavor)) {
            return this.getText(this.myList);
        }
        if (flavor2.equals(LIST_DATA_FLAVOR)) {
            return this.myList;
        }
        throw new UnsupportedFlavorException(flavor2);
    }

    protected String getHTML(List<? extends T> list2, boolean all) {
        StringBuilder sb = new StringBuilder();
        if (all) {
            sb.append("<html><body>");
        }
        sb.append("<ul>\n");
        for (T object : list2) {
            sb.append("  <li>").append(this.toHTML(object)).append("</li>\n");
        }
        sb.append("</ul>");
        if (all) {
            sb.append("</body></html>");
        }
        return sb.toString();
    }

    protected String getText(List<? extends T> list2) {
        if (list2.size() == 1) {
            return this.toString(list2.get(0));
        }
        StringBuilder sb = new StringBuilder();
        for (T object : list2) {
            sb.append(this.toString(object)).append('\n');
        }
        return sb.toString();
    }

    protected String toHTML(T object) {
        return this.toString(object);
    }

    protected abstract String toString(T var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/dnd/TransferableList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/dnd/TransferableList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransferDataFlavors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

