/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.file;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.file.PListProcessingException;
import com.intellij.openapi.util.Key;
import com.intellij.util.JavaXmlDocumentKt;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Deprecated(message="Use dd-plist library to work with plist files (https://github.com/3breadt/dd-plist)")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J'\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000f\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/file/PListBuddyWrapper;", "", "pListPath", "", "<init>", "(Ljava/lang/String;)V", "UTIL_PATH", "MAX_CHARS_OUTPUT", "", "runCommand", "Lcom/intellij/ide/file/PListBuddyWrapper$CommandResult;", "command", "outputType", "Lcom/intellij/ide/file/PListBuddyWrapper$OutputType;", "commands", "", "(Lcom/intellij/ide/file/PListBuddyWrapper$OutputType;[Ljava/lang/String;)Lcom/intellij/ide/file/PListBuddyWrapper$CommandResult;", "truncateOutput", "output", "readData", "Lorg/w3c/dom/Document;", "dataId", "parseXml", "xmlString", "OutputType", "CommandResult", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class PListBuddyWrapper {
    @NotNull
    private final String pListPath;
    @NotNull
    private final String UTIL_PATH;
    private final int MAX_CHARS_OUTPUT;

    public PListBuddyWrapper(@NotNull String pListPath) {
        Intrinsics.checkNotNullParameter((Object)pListPath, (String)"pListPath");
        this.pListPath = pListPath;
        this.UTIL_PATH = "/usr/libexec/PListBuddy";
        this.MAX_CHARS_OUTPUT = 20;
    }

    @NotNull
    public final CommandResult runCommand(@NotNull String command) throws PListProcessingException {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String[] stringArray = new String[]{command};
        return this.runCommand(OutputType.DEFAULT, stringArray);
    }

    @NotNull
    public final CommandResult runCommand(@NotNull OutputType outputType, String ... commands) throws PListProcessingException {
        Intrinsics.checkNotNullParameter((Object)((Object)outputType), (String)"outputType");
        Intrinsics.checkNotNullParameter((Object)commands, (String)"commands");
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(this.UTIL_PATH);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withExePath(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        for (String command : commands) {
            if (OutputType.XML == outputType) {
                commandLine.addParameter("-x");
            }
            commandLine.addParameter("-c");
            commandLine.addParameter(command);
        }
        commandLine.addParameter(this.pListPath);
        StringBuilder errorMessage = new StringBuilder();
        StringBuilder output = new StringBuilder();
        try {
            OSProcessHandler processHandler = new OSProcessHandler(commandLine);
            processHandler.addProcessListener(new ProcessListener(output, errorMessage){
                final /* synthetic */ StringBuilder $output;
                final /* synthetic */ StringBuilder $errorMessage;
                {
                    this.$output = $output;
                    this.$errorMessage = $errorMessage;
                }

                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    if (Intrinsics.areEqual((Object)ProcessOutputTypes.STDOUT, outputType)) {
                        this.$output.append(event.getText());
                    }
                    if (Intrinsics.areEqual((Object)ProcessOutputTypes.STDERR, outputType)) {
                        this.$errorMessage.append(event.getText());
                    }
                }
            });
            processHandler.startNotify();
            if (!processHandler.waitFor(1000L)) {
                throw new PListProcessingException("Failed to execute command on file " + this.pListPath + " in 1 sec");
            }
            if (!(((CharSequence)errorMessage).length() == 0)) {
                throw new PListProcessingException("PListBuddy execution process for file " + this.pListPath + " returned error: " + errorMessage);
            }
            Integer n = processHandler.getExitCode();
            return new CommandResult(n != null ? n : -1, output.toString());
        }
        catch (ExecutionException exe) {
            throw new PListProcessingException("Failed to run PListBuddy and execute command on file " + this.pListPath + ": " + exe.getLocalizedMessage());
        }
    }

    private final String truncateOutput(String output) {
        Object object;
        if (output.length() < this.MAX_CHARS_OUTPUT) {
            object = output;
        } else {
            String string = output.substring(0, this.MAX_CHARS_OUTPUT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = string + "...";
        }
        return object;
    }

    @NotNull
    public final Document readData(@NotNull String dataId) throws PListProcessingException {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        String command = "Print " + dataId;
        String[] stringArray = new String[]{command};
        CommandResult result2 = this.runCommand(OutputType.XML, stringArray);
        if (result2.getRetCode() != 0) {
            throw new PListProcessingException("PListBuddy return code for command " + command + " is: " + result2.getRetCode());
        }
        String output = result2.getOutput();
        if (output != null && !StringsKt.startsWith$default((String)output, (String)"<?xml", (boolean)false, (int)2, null)) {
            throw new PListProcessingException("Unexpected output for command " + command + ": " + this.truncateOutput(output));
        }
        if (output == null) {
            throw new PListProcessingException("Empty output for command " + command);
        }
        return this.parseXml(output);
    }

    private final Document parseXml(String xmlString) throws PListProcessingException {
        try {
            DocumentBuilder builder = JavaXmlDocumentKt.createDocumentBuilder$default((boolean)false, (int)1, null);
            StringReader stringReader = new StringReader(xmlString);
            InputSource source = new InputSource(stringReader);
            Document document2 = builder.parse(source);
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"parse(...)");
            return document2;
        }
        catch (SAXException e) {
            throw new PListProcessingException("XML read error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new PListProcessingException("XML read error: " + e.getMessage());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/file/PListBuddyWrapper$CommandResult;", "", "retCode", "", "output", "", "<init>", "(ILjava/lang/String;)V", "getRetCode", "()I", "getOutput", "()Ljava/lang/String;", "intellij.platform.ide.impl"})
    public static final class CommandResult {
        private final int retCode;
        @Nullable
        private final String output;

        public CommandResult(int retCode, @Nullable String output) {
            this.retCode = retCode;
            this.output = output;
        }

        public final int getRetCode() {
            return this.retCode;
        }

        @Nullable
        public final String getOutput() {
            return this.output;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/file/PListBuddyWrapper$OutputType;", "", "<init>", "(Ljava/lang/String;I)V", "DEFAULT", "XML", "intellij.platform.ide.impl"})
    public static final class OutputType
    extends Enum<OutputType> {
        public static final /* enum */ OutputType DEFAULT = new OutputType();
        public static final /* enum */ OutputType XML = new OutputType();
        private static final /* synthetic */ OutputType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OutputType[] values() {
            return (OutputType[])$VALUES.clone();
        }

        public static OutputType valueOf(String value) {
            return Enum.valueOf(OutputType.class, value);
        }

        @NotNull
        public static EnumEntries<OutputType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = outputTypeArray = new OutputType[]{OutputType.DEFAULT, OutputType.XML};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

