/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr.ui;

import com.intellij.ide.gdpr.ui.Styles;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J4\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/gdpr/ui/HtmlRtfPane;", "", "<init>", "()V", "linkMap", "", "Lkotlin/ranges/IntRange;", "", "resultPane", "Ljavax/swing/JTextPane;", "mouseMotionListenersList", "", "Ljava/awt/event/MouseMotionListener;", "mouseListenersList", "Ljava/awt/event/MouseListener;", "create", "htmlText", "replaceText", "newText", "clearLinks", "", "process", "Ljavax/swing/text/DefaultStyledDocument;", "htmlContent", "addHyperlinksListeners", "styleNodes", "nodeElement", "Lorg/jsoup/nodes/Element;", "styledDocument", "offsetInDocument", "", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nHtmlRtfPaneConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlRtfPaneConverter.kt\ncom/intellij/ide/gdpr/ui/HtmlRtfPane\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1869#2,2:139\n1869#2,2:141\n1869#2,2:143\n1869#2,2:145\n*S KotlinDebug\n*F\n+ 1 HtmlRtfPaneConverter.kt\ncom/intellij/ide/gdpr/ui/HtmlRtfPane\n*L\n42#1:139,2\n44#1:141,2\n55#1:143,2\n120#1:145,2\n*E\n"})
public final class HtmlRtfPane {
    @NotNull
    private final Map<IntRange, String> linkMap = new LinkedHashMap();
    @NotNull
    private final JTextPane resultPane = new JTextPane();
    @NotNull
    private final List<MouseMotionListener> mouseMotionListenersList = new ArrayList();
    @NotNull
    private final List<MouseListener> mouseListenersList = new ArrayList();

    @NotNull
    public final JTextPane create(@NotNull String htmlText) {
        Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
        this.process(htmlText);
        return this.resultPane;
    }

    @NotNull
    public final JTextPane replaceText(@NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        this.resultPane.getDocument().remove(0, this.resultPane.getDocument().getLength());
        this.clearLinks();
        this.process(newText);
        return this.resultPane;
    }

    private final void clearLinks() {
        EventListener it;
        Iterable $this$forEach$iv = this.mouseListenersList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MouseListener)element$iv;
            boolean bl = false;
            this.resultPane.removeMouseListener((MouseListener)it);
        }
        this.mouseListenersList.clear();
        $this$forEach$iv = this.mouseMotionListenersList;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MouseMotionListener)element$iv;
            boolean bl = false;
            this.resultPane.removeMouseMotionListener((MouseMotionListener)it);
        }
        this.mouseMotionListenersList.clear();
        this.linkMap.clear();
    }

    private final DefaultStyledDocument process(String htmlContent) {
        Document document2 = Jsoup.parse((String)htmlContent, (String)"UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"parse(...)");
        Document document3 = document2;
        Elements elements = document3.getElementsByAttributeValue("class", "licenseContent");
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"getElementsByAttributeValue(...)");
        Element element = (Element)CollectionsKt.firstOrNull((List)((List)elements));
        if (element == null) {
            Element element2 = document3.body();
            element = element2;
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"body(...)");
        }
        Element licenseContentNode = element;
        javax.swing.text.Document document4 = this.resultPane.getDocument();
        Intrinsics.checkNotNull((Object)document4, (String)"null cannot be cast to non-null type javax.swing.text.DefaultStyledDocument");
        DefaultStyledDocument styledDocument = (DefaultStyledDocument)document4;
        Elements elements2 = licenseContentNode.children();
        Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"children(...)");
        Iterable $this$forEach$iv = (Iterable)elements2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Element it = (Element)element$iv;
            boolean bl = false;
            String string2 = it.tagName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tagName(...)");
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string3.toUpperCase(locale), (String)"toUpperCase(...)");
            int n = -1;
            switch (string.hashCode()) {
                case 80: {
                    if (string.equals("P")) {
                        n = 1;
                    }
                    break;
                }
                case 2281: {
                    if (string.equals("H1")) {
                        n = 2;
                    }
                    break;
                }
                case 2282: {
                    if (string.equals("H2")) {
                        n = 3;
                    }
                    break;
                }
            }
            SimpleAttributeSet style = switch (n) {
                case 2 -> Styles.INSTANCE.getH1();
                case 3 -> Styles.INSTANCE.getH2();
                case 1 -> Styles.INSTANCE.getPARAGRAPH();
                default -> Styles.INSTANCE.getREGULAR();
            };
            int start2 = styledDocument.getLength();
            styledDocument.insertString(styledDocument.getLength(), it.text() + "\n", style);
            styledDocument.setParagraphAttributes(start2, it.text().length() + 1, style, false);
            String string4 = it.tagName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"tagName(...)");
            string3 = string4;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string5 = string3.toUpperCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            if (!Intrinsics.areEqual((Object)string5, (Object)"P")) continue;
            Intrinsics.checkNotNull((Object)it);
            this.styleNodes(it, styledDocument, start2, this.linkMap);
        }
        this.addHyperlinksListeners();
        return styledDocument;
    }

    private final void addHyperlinksListeners() {
        MouseAdapter cursorListener2 = new MouseAdapter(this){
            final /* synthetic */ HtmlRtfPane this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void mouseMoved(MouseEvent e) {
                boolean bl;
                block6: {
                    void $this$any$iv;
                    Serializable serializable = e;
                    if (serializable == null || (serializable = ((MouseEvent)serializable).getPoint()) == null || (serializable = ((Point)serializable).getLocation()) == null) {
                        return;
                    }
                    Serializable location = serializable;
                    Iterable iterable = HtmlRtfPane.access$getLinkMap$p(this.this$0).keySet();
                    HtmlRtfPane htmlRtfPane = this.this$0;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            IntRange it = (IntRange)element$iv;
                            boolean bl2 = false;
                            if (!it.contains(HtmlRtfPane.access$getResultPane$p(htmlRtfPane).viewToModel((Point)location))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    HtmlRtfPane.access$getResultPane$p(this.this$0).setCursor(new Cursor(12));
                } else {
                    HtmlRtfPane.access$getResultPane$p(this.this$0).setCursor(new Cursor(0));
                }
            }
        };
        MouseAdapter linkListener2 = new MouseAdapter(this){
            final /* synthetic */ HtmlRtfPane this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void mouseClicked(MouseEvent e) {
                MouseEvent mouseEvent = e;
                boolean bl = mouseEvent != null ? mouseEvent.getButton() == 1 : false;
                if (bl) {
                    Object v2;
                    block5: {
                        void $this$firstOrNull$iv;
                        Point location = e.getPoint().getLocation();
                        Iterable iterable = HtmlRtfPane.access$getLinkMap$p(this.this$0).keySet();
                        HtmlRtfPane htmlRtfPane = this.this$0;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            IntRange it = (IntRange)element$iv;
                            boolean bl2 = false;
                            if (!it.contains(HtmlRtfPane.access$getResultPane$p(htmlRtfPane).viewToModel(location))) continue;
                            v2 = element$iv;
                            break block5;
                        }
                        v2 = null;
                    }
                    IntRange intRange = v2;
                    if (intRange == null) {
                        return;
                    }
                    IntRange range = intRange;
                    String string = (String)HtmlRtfPane.access$getLinkMap$p(this.this$0).get(range);
                    if (string == null) {
                        return;
                    }
                    String link = string;
                    if (Desktop.isDesktopSupported()) {
                        Desktop.getDesktop().browse(new URI(link));
                    }
                }
            }
        };
        this.resultPane.addMouseMotionListener(cursorListener2);
        this.mouseMotionListenersList.add(cursorListener2);
        this.resultPane.addMouseListener(linkListener2);
        this.mouseListenersList.add(linkListener2);
    }

    private final void styleNodes(Element nodeElement, DefaultStyledDocument styledDocument, int offsetInDocument, Map<IntRange, String> linkMap) {
        SimpleAttributeSet style;
        int currentOffset = 0;
        currentOffset = offsetInDocument;
        String string = nodeElement.tagName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tagName(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        switch (string3) {
            case "STRONG": {
                SimpleAttributeSet simpleAttributeSet = Styles.INSTANCE.getBOLD();
                break;
            }
            case "A": {
                String string4 = nodeElement.attr("href");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"attr(...)");
                String linkUrl = string4;
                linkMap.put(new IntRange(currentOffset, currentOffset + nodeElement.text().length() + 1), linkUrl);
                SimpleAttributeSet simpleAttributeSet = Styles.INSTANCE.getLINK();
                break;
            }
            case "HINT": {
                SimpleAttributeSet simpleAttributeSet = Styles.INSTANCE.getHINT();
                break;
            }
            case "SUP": {
                SimpleAttributeSet simpleAttributeSet = null;
                break;
            }
            default: {
                SimpleAttributeSet simpleAttributeSet = style = Styles.INSTANCE.getREGULAR();
            }
        }
        if (style != null) {
            styledDocument.setCharacterAttributes(offsetInDocument, nodeElement.text().length(), style, false);
        }
        if (nodeElement.childNodes().isEmpty()) {
            return;
        }
        List list2 = nodeElement.childNodes();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"childNodes(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            if (it instanceof TextNode) {
                int n;
                if (it.siblingIndex() == 0) {
                    Object e = nodeElement.textNodes().get(0);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jsoup.nodes.TextNode");
                    String string5 = ((TextNode)e).text();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"text(...)");
                    n = StringsKt.trimIndent((String)string5).length();
                } else {
                    n = ((TextNode)it).text().length();
                }
                int length = n;
                currentOffset += length;
            }
            if (!(it instanceof Element)) continue;
            this.styleNodes((Element)it, styledDocument, currentOffset, linkMap);
            currentOffset += ((Element)it).text().length();
        }
    }

    public static final /* synthetic */ Map access$getLinkMap$p(HtmlRtfPane $this) {
        return $this.linkMap;
    }

    public static final /* synthetic */ JTextPane access$getResultPane$p(HtmlRtfPane $this) {
        return $this.resultPane;
    }
}

