/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.actions.NextTabAction;
import com.intellij.ide.actions.PreviousTabAction;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditSaveConfirmationHandler;
import com.intellij.ide.lightEdit.LightEditSaveStatusIcon;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditTabAttributesProvider;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManagerImpl;
import com.intellij.ide.lightEdit.project.LightEditFileEditorManagerImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.util.BitUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.swing.FocusManager;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LightEditTabs
extends JBEditorTabs
implements LightEditorListener,
CloseAction.CloseTarget {
    @NotNull
    private final Project myProject;
    @NotNull
    private final LightEditorManagerImpl myEditorManager;
    @NotNull
    private final ExecutorService myTabUpdateExecutor;

    LightEditTabs(@NotNull Project project2, @NotNull Disposable parentDisposable, @NotNull LightEditorManagerImpl editorManager) {
        if (project2 == null) {
            LightEditTabs.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            LightEditTabs.$$$reportNull$$$0(1);
        }
        if (editorManager == null) {
            LightEditTabs.$$$reportNull$$$0(2);
        }
        super(project2, null, parentDisposable);
        this.myProject = project2;
        this.myEditorManager = editorManager;
        this.myTabUpdateExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Light Edit Tabs Update", (int)1);
        Disposer.register((Disposable)parentDisposable, () -> this.myTabUpdateExecutor.shutdown());
        this.addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                if (oldSelection != null) {
                    oldSelection.setTabColor(null);
                }
                LightEditTabs.this.asyncUpdateTab(newSelection);
                LightEditTabs.this.onSelectionChange(newSelection);
            }
        });
        this.myEditorManager.addListener(this, parentDisposable);
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect();
        busConnection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
                LightEditTabs.this.revalidateAndRepaint();
            }
        });
    }

    void addEditorTab(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(3);
        }
        this.addEditorTab(editorInfo, -1);
    }

    private void addEditorTab(@NotNull LightEditorInfo editorInfo, int index) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(4);
        }
        LightEditFileEditorManagerImpl fileEditorManager = (LightEditFileEditorManagerImpl)FileEditorManager.getInstance((Project)this.myProject);
        EditorComposite editorContainer = fileEditorManager.createEditorComposite(editorInfo);
        TabInfo tabInfo = new TabInfo(editorContainer.getComponent()).setText(editorInfo.getFile().getPresentableName()).setIcon(LightEditTabs.getFileTypeIcon(editorInfo));
        tabInfo.setObject((Object)new TabEditorData(editorInfo, editorContainer));
        DefaultActionGroup tabActions = new DefaultActionGroup();
        tabActions.add((AnAction)new CloseTabAction(editorInfo));
        tabInfo.setTabLabelActions((ActionGroup)tabActions, "EditorTab");
        this.addTabSilently(tabInfo, index);
        this.select(tabInfo, true);
        this.asyncUpdateTab(tabInfo);
        this.myEditorManager.fireEditorSelected(editorInfo);
        ((FileEditorManagerListener)this.myProject.getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileOpened((FileEditorManager)fileEditorManager, editorInfo.getFile());
    }

    @Override
    public void close() {
        TabInfo info = this.getSelectedInfo();
        if (info != null) {
            this.closeTab(info);
        }
    }

    private static Icon getFileTypeIcon(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(5);
        }
        return editorInfo.getFile().getFileType().getIcon();
    }

    private void onSelectionChange(@Nullable TabInfo tabInfo) {
        LightEditorInfo selectedEditorInfo = tabInfo != null ? LightEditTabs.getEditorInfo(tabInfo) : null;
        this.myEditorManager.fireEditorSelected(selectedEditorInfo);
    }

    void selectTab(@NotNull LightEditorInfo info) {
        if (info == null) {
            LightEditTabs.$$$reportNull$$$0(6);
        }
        this.getTabs().stream().filter(tabInfo -> info.equals((Object)LightEditTabs.getEditorInfo(tabInfo))).findFirst().ifPresent(tabInfo -> this.select((TabInfo)tabInfo, true));
    }

    private void closeTab(@NotNull TabInfo tabInfo) {
        LightEditorInfo editorInfo;
        if (tabInfo == null) {
            LightEditTabs.$$$reportNull$$$0(7);
        }
        if ((editorInfo = LightEditTabs.getEditorInfo(tabInfo)) != null && (!editorInfo.isSaveRequired() || this.autosaveDocument(editorInfo) || LightEditUtil.confirmClose(ApplicationBundle.message((String)"light.edit.close.message", (Object[])new Object[0]), ApplicationBundle.message((String)"light.edit.close.title", (Object[])new Object[0]), new LightEditSaveConfirmationHandler(){

            @Override
            public void onSave() {
                LightEditTabs.this.saveDocument(editorInfo);
            }

            @Override
            public void onDiscard() {
                FileEditor fileEditor = editorInfo.getFileEditor();
                if (fileEditor instanceof TextEditor) {
                    Editor editor2 = ((TextEditor)fileEditor).getEditor();
                    FileDocumentManager.getInstance().reloadFromDisk(editor2.getDocument());
                }
            }
        }))) {
            this.removeTab(tabInfo).doWhenDone(() -> this.myEditorManager.closeEditor(editorInfo));
        }
    }

    private boolean autosaveDocument(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(8);
        }
        if (LightEditService.getInstance().isAutosaveMode()) {
            this.saveDocument(editorInfo);
            return true;
        }
        return false;
    }

    void closeTab(@NotNull LightEditorInfo editorInfo) {
        TabInfo tabInfo;
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(9);
        }
        if ((tabInfo = this.findTabInfo(editorInfo)) != null) {
            this.closeTab(tabInfo);
        }
    }

    void saveDocument(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(10);
        }
        if (editorInfo.isNew()) {
            VirtualFile targetFile = LightEditUtil.getPreferredSaveTarget(editorInfo);
            if (targetFile == null) {
                targetFile = LightEditUtil.chooseTargetFile(this.getParent(), editorInfo);
            }
            if (targetFile != null) {
                this.myEditorManager.saveAs(editorInfo, targetFile);
            }
        } else {
            Document document2 = FileDocumentManager.getInstance().getDocument(editorInfo.getFile());
            if (document2 != null) {
                FileDocumentManager.getInstance().saveDocument(document2);
            }
        }
    }

    void replaceTab(@NotNull LightEditorInfo oldInfo, @NotNull LightEditorInfo newInfo) {
        int oldIndex;
        TabInfo oldTabInfo;
        if (oldInfo == null) {
            LightEditTabs.$$$reportNull$$$0(11);
        }
        if (newInfo == null) {
            LightEditTabs.$$$reportNull$$$0(12);
        }
        if ((oldTabInfo = this.findTabInfo(oldInfo)) != null && (oldIndex = this.getIndexOf(oldTabInfo)) >= 0) {
            this.removeTab(oldTabInfo).doWhenDone(() -> this.myEditorManager.closeEditor(oldInfo));
            this.addEditorTab(newInfo, oldIndex);
        }
    }

    @Nullable
    VirtualFile getSelectedFile() {
        LightEditorInfo editorInfo;
        TabInfo info = this.getSelectedInfo();
        if (info != null && (editorInfo = LightEditTabs.getEditorInfo(info)) != null) {
            return editorInfo.getFile();
        }
        return null;
    }

    List<VirtualFile> getOpenFiles() {
        return this.getTabs().stream().map(tab -> LightEditTabs.getEditorInfo(tab)).filter(editorInfo -> editorInfo != null).map(editorInfo -> editorInfo.getFile()).collect(Collectors.toList());
    }

    @Nullable
    FileEditor getSelectedFileEditor() {
        LightEditorInfo editorInfo;
        TabInfo info = this.getSelectedInfo();
        if (info != null && (editorInfo = LightEditTabs.getEditorInfo(info)) != null) {
            return editorInfo.getFileEditor();
        }
        return null;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        VirtualFile[] virtualFileArray;
        if (sink == null) {
            LightEditTabs.$$$reportNull$$$0(13);
        }
        super.uiDataSnapshot(sink);
        sink.set(CommonDataKeys.PROJECT, (Object)this.myProject);
        sink.set(CloseAction.CloseTarget.KEY, (Object)this);
        VirtualFile selection = this.getSelectedFile();
        sink.set(CommonDataKeys.VIRTUAL_FILE, (Object)selection);
        if (selection != null) {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = selection;
        } else {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        }
        sink.set(CommonDataKeys.VIRTUAL_FILE_ARRAY, (Object)virtualFileArray);
    }

    private void asyncUpdateTab(@NotNull TabInfo tabInfo) {
        if (tabInfo == null) {
            LightEditTabs.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.assertEventDispatchThread();
        LightEditorInfo editorInfo = LightEditTabs.getEditorInfo(tabInfo);
        if (editorInfo == null) {
            return;
        }
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(editorInfo.getFile());
        this.asyncUpdateTabs(Collections.singletonList(Pair.createNonNull((Object)tabInfo, (Object)editorInfo)));
    }

    private void asyncUpdateTabs(@NotNull List<? extends Pair.NonNull<TabInfo, LightEditorInfo>> tabEditorPairs) {
        if (tabEditorPairs == null) {
            LightEditTabs.$$$reportNull$$$0(15);
        }
        this.myTabUpdateExecutor.execute(() -> {
            List tabAttributesPairs = ContainerUtil.map((Collection)tabEditorPairs, pair -> Pair.createNonNull((Object)((TabInfo)pair.first), (Object)LightEditTabs.calcAttributes((LightEditorInfo)pair.second)));
            ApplicationManager.getApplication().invokeLater(() -> {
                for (Pair.NonNull attributesPair : tabAttributesPairs) {
                    this.updateTabPresentation((TabInfo)attributesPair.first, (TextAttributes)attributesPair.second);
                }
            });
        });
    }

    private void updateTabPresentation(@NotNull TabInfo tabInfo, @NotNull TextAttributes attributes) {
        if (tabInfo == null) {
            LightEditTabs.$$$reportNull$$$0(16);
        }
        if (attributes == null) {
            LightEditTabs.$$$reportNull$$$0(17);
        }
        tabInfo.setDefaultForeground(attributes.getForegroundColor());
        tabInfo.setTabColor(tabInfo == this.getSelectedInfo() ? attributes.getBackgroundColor() : null);
    }

    @NotNull
    private static TextAttributes calcAttributes(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(18);
        }
        TextAttributes attributes = new TextAttributes();
        attributes.setBackgroundColor(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        LightEditTabAttributesProvider.EP_NAME.getExtensionList().forEach(provider -> {
            TextAttributes provided = provider.calcAttributes(editorInfo);
            if (provided != null) {
                if (provided.getForegroundColor() != null) {
                    attributes.setForegroundColor(provided.getForegroundColor());
                }
                if (provided.getBackgroundColor() != null) {
                    attributes.setBackgroundColor(provided.getBackgroundColor());
                }
            }
        });
        TextAttributes textAttributes = attributes;
        if (textAttributes == null) {
            LightEditTabs.$$$reportNull$$$0(19);
        }
        return textAttributes;
    }

    public void fileStatusChanged(@NotNull Collection<? extends LightEditorInfo> editorInfos) {
        if (editorInfos == null) {
            LightEditTabs.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            List tabEditorPairs = ContainerUtil.mapNotNull((Collection)editorInfos, editorInfo -> {
                TabInfo info = this.findTabInfo((LightEditorInfo)editorInfo);
                if (info == null) {
                    return null;
                }
                return Pair.createNonNull((Object)info, (Object)editorInfo);
            });
            if (!tabEditorPairs.isEmpty()) {
                this.asyncUpdateTabs(tabEditorPairs);
            }
        });
    }

    @Nullable
    private static LightEditorInfo getEditorInfo(@NotNull TabInfo tabInfo) {
        Object data2;
        if (tabInfo == null) {
            LightEditTabs.$$$reportNull$$$0(21);
        }
        return (data2 = tabInfo.getObject()) instanceof TabEditorData ? ((TabEditorData)data2).editorInfo : null;
    }

    @Nullable
    private TabInfo findTabInfo(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(22);
        }
        for (TabInfo tabInfo : this.getTabs()) {
            Object data2 = tabInfo.getObject();
            if (!(data2 instanceof TabEditorData) || !((TabEditorData)data2).editorInfo.equals((Object)editorInfo)) continue;
            return tabInfo;
        }
        return null;
    }

    @Nullable
    public EditorComposite findEditorComposite(@NotNull FileEditor fileEditor) {
        VirtualFile virtualFile;
        if (fileEditor == null) {
            LightEditTabs.$$$reportNull$$$0(23);
        }
        if ((virtualFile = fileEditor.getFile()) != null) {
            for (TabInfo tabInfo : this.getTabs()) {
                EditorComposite composite2;
                Object data2 = tabInfo.getObject();
                if (!(data2 instanceof TabEditorData) || !virtualFile.equals(((TabEditorData)data2).editorInfo.getFile()) || !ContainerUtil.exists((composite2 = ((TabEditorData)data2).editorComposite).getAllEditors(), editor2 -> editor2.equals((Object)fileEditor))) continue;
                return composite2;
            }
        }
        return null;
    }

    boolean isTabNavigationAvailable(@NotNull AnAction navigationAction) {
        Component focusOwner;
        if (navigationAction == null) {
            LightEditTabs.$$$reportNull$$$0(24);
        }
        if (this.getTabCount() > 1 && (focusOwner = FocusManager.getCurrentManager().getFocusOwner()) instanceof EditorComponentImpl) {
            return this.getIndexOf(this.getSelectedInfo()) >= 0 && (navigationAction instanceof PreviousTabAction || navigationAction instanceof NextTabAction);
        }
        return false;
    }

    void navigateToTab(@NotNull AnAction navigationAction) {
        int currIndex;
        if (navigationAction == null) {
            LightEditTabs.$$$reportNull$$$0(25);
        }
        if ((currIndex = this.getIndexOf(this.getSelectedInfo())) >= 0) {
            int newIndex = currIndex;
            if (navigationAction instanceof PreviousTabAction) {
                newIndex = (currIndex > 0 ? currIndex : this.getTabCount()) - 1;
            } else if (navigationAction instanceof NextTabAction) {
                int n = newIndex = currIndex < this.getTabCount() - 1 ? currIndex + 1 : 0;
            }
            if (newIndex != currIndex) {
                TabInfo newInfo = this.getTabAt(newIndex);
                this.select(newInfo, true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: 
            case 14: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabEditorPairs";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditTabs";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfos";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditTabs";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addEditorTab";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectTab";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "closeTab";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "autosaveDocument";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveDocument";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceTab";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "asyncUpdateTab";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "asyncUpdateTabs";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateTabPresentation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "calcAttributes";
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fileStatusChanged";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEditorInfo";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findTabInfo";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findEditorComposite";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isTabNavigationAvailable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "navigateToTab";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19 -> new IllegalStateException(string);
        };
    }

    private record TabEditorData(@NotNull LightEditorInfo editorInfo, @NotNull EditorComposite editorComposite) {
        @NotNull
        private final LightEditorInfo editorInfo;
        @NotNull
        private final EditorComposite editorComposite;

        private TabEditorData(@NotNull LightEditorInfo editorInfo, @NotNull EditorComposite editorComposite) {
            if (editorInfo == null) {
                TabEditorData.$$$reportNull$$$0(0);
            }
            if (editorComposite == null) {
                TabEditorData.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public LightEditorInfo editorInfo() {
            LightEditorInfo lightEditorInfo = this.editorInfo;
            if (lightEditorInfo == null) {
                TabEditorData.$$$reportNull$$$0(2);
            }
            return lightEditorInfo;
        }

        @NotNull
        public EditorComposite editorComposite() {
            EditorComposite editorComposite = this.editorComposite;
            if (editorComposite == null) {
                TabEditorData.$$$reportNull$$$0(3);
            }
            return editorComposite;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editorInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editorComposite";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/lightEdit/LightEditTabs$TabEditorData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/lightEdit/LightEditTabs$TabEditorData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "editorInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "editorComposite";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private final class CloseTabAction
    extends DumbAwareAction
    implements LightEditCompatible {
        private final LightEditorInfo myEditorInfo;
        private final Icon myUnsavedIcon;

        private CloseTabAction(LightEditorInfo editorInfo) {
            if (editorInfo == null) {
                CloseTabAction.$$$reportNull$$$0(0);
            }
            this.myUnsavedIcon = LightEditSaveStatusIcon.create();
            this.myEditorInfo = editorInfo;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseTabAction.$$$reportNull$$$0(1);
            }
            if (e.getInputEvent() instanceof MouseEvent && BitUtil.isSet((int)e.getInputEvent().getModifiersEx(), (int)512)) {
                this.closeAllTabsExceptCurrent();
            } else {
                this.closeCurrentTab();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseTabAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setIcon(this.getIcon());
            e.getPresentation().setHoveredIcon(AllIcons.Actions.CloseHovered);
            e.getPresentation().setVisible(UISettings.getInstance().getShowCloseButton());
            e.getPresentation().setText(IdeBundle.messagePointer((String)"action.presentation.LightEditTabs.text", (Object[])new Object[]{SystemInfo.isMac ? "\u2325" : "Alt+"}));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CloseTabAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        private Icon getIcon() {
            return this.myEditorInfo.isSaveRequired() ? this.myUnsavedIcon : AllIcons.Actions.Close;
        }

        private void closeCurrentTab() {
            TabInfo tabInfo = LightEditTabs.this.findTabInfo(this.myEditorInfo);
            if (tabInfo != null) {
                LightEditTabs.this.closeTab(tabInfo);
            }
        }

        private void closeAllTabsExceptCurrent() {
            LightEditTabs.this.getTabs().stream().filter(tabInfo -> tabInfo != LightEditTabs.this.getSelectedInfo()).forEach(tabInfo -> LightEditTabs.this.closeTab((TabInfo)tabInfo));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editorInfo";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/lightEdit/LightEditTabs$CloseTabAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/lightEdit/LightEditTabs$CloseTabAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

