/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.intentions.openInProject;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditServiceImpl;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorManagerImpl;
import com.intellij.ide.lightEdit.intentions.openInProject.ProjectRootSearchUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditOpenInProjectIntention
implements IntentionAction,
LightEditCompatible,
DumbAware {
    @IntentionName
    @NotNull
    public String getText() {
        String string = ApplicationBundle.message((String)"light.edit.open.in.project.intention", (Object[])new Object[0]);
        if (string == null) {
            LightEditOpenInProjectIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            LightEditOpenInProjectIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile psiFile) {
        if (project2 == null) {
            LightEditOpenInProjectIntention.$$$reportNull$$$0(2);
        }
        return LightEdit.owns((Project)project2);
    }

    public void invoke(@NotNull Project project2, Editor editor2, PsiFile psiFile) throws IncorrectOperationException {
        if (project2 == null) {
            LightEditOpenInProjectIntention.$$$reportNull$$$0(3);
        }
        LightEditOpenInProjectIntention.performOn(project2, psiFile.getVirtualFile());
    }

    public static void performOn(@NotNull Project project2, @NotNull VirtualFile currentFile) throws IncorrectOperationException {
        LightEditorInfo editorInfo;
        if (project2 == null) {
            LightEditOpenInProjectIntention.$$$reportNull$$$0(4);
        }
        if (currentFile == null) {
            LightEditOpenInProjectIntention.$$$reportNull$$$0(5);
        }
        if ((editorInfo = ((LightEditorManagerImpl)LightEditService.getInstance().getEditorManager()).findOpen(currentFile)) == null) {
            return;
        }
        Project openProject2 = LightEditOpenInProjectIntention.findOpenProject(currentFile);
        if (openProject2 != null) {
            LightEditFeatureUsagesUtil.logOpenFileInProject(project2, LightEditFeatureUsagesUtil.ProjectStatus.Open);
        } else {
            VirtualFile projectRoot = ProjectRootSearchUtil.findProjectRoot(project2, currentFile);
            if (projectRoot != null) {
                openProject2 = PlatformProjectOpenProcessor.Companion.doOpenProject(projectRoot.toNioPath(), OpenProjectTask.build());
            }
        }
        if (openProject2 != null) {
            ((LightEditServiceImpl)LightEditService.getInstance()).closeEditor(editorInfo);
            OpenFileAction.openFile(currentFile, openProject2);
        }
    }

    @Nullable
    private static Project findOpenProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditOpenInProjectIntention.$$$reportNull$$$0(6);
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file2)) continue;
            return project2;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/intentions/openInProject/LightEditOpenInProjectIntention";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/intentions/openInProject/LightEditOpenInProjectIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performOn";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findOpenProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

