/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.minimap;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.minimap.MinimapPanel;
import com.intellij.ide.minimap.settings.MinimapSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\tJ\b\u0010\u000b\u001a\u00020\tH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/minimap/MinimapService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "settings", "Lcom/intellij/ide/minimap/settings/MinimapSettings;", "onSettingsChange", "Lkotlin/Function1;", "Lcom/intellij/ide/minimap/settings/MinimapSettings$SettingsChangeType;", "", "updateAllEditors", "dispose", "getEditorImpl", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorOpened", "getPanel", "Ljavax/swing/JPanel;", "fileEditor", "addMinimap", "textEditor", "removeMinimap", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nMinimapService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinimapService.kt\ncom/intellij/ide/minimap/MinimapService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n13805#2,2:103\n1#3:105\n*S KotlinDebug\n*F\n+ 1 MinimapService.kt\ncom/intellij/ide/minimap/MinimapService\n*L\n39#1:103,2\n*E\n"})
public final class MinimapService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MinimapSettings settings = MinimapSettings.Companion.getInstance();
    @NotNull
    private final Function1<MinimapSettings.SettingsChangeType, Unit> onSettingsChange = arg_0 -> MinimapService.onSettingsChange$lambda$0(this, arg_0);
    @NotNull
    private static final Key<MinimapPanel> MINI_MAP_PANEL_KEY;

    public MinimapService() {
        MinimapSettings.Companion.getInstance().getSettingsChangeCallback().plusAssign(this.onSettingsChange);
    }

    public final void updateAllEditors() {
        Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
        Object[] $this$forEach$iv = editorArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorImpl it;
            Editor editor2 = (Editor)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)editor2);
            if (this.getEditorImpl(editor2) == null) continue;
            boolean bl2 = false;
            this.removeMinimap(it);
            if (!this.settings.getState().getEnabled()) continue;
            this.addMinimap(it);
        }
    }

    public void dispose() {
        MinimapSettings.Companion.getInstance().getSettingsChangeCallback().minusAssign(this.onSettingsChange);
    }

    private final EditorImpl getEditorImpl(Editor editor2) {
        EditorImpl editorImpl = editor2 instanceof EditorImpl ? (EditorImpl)editor2 : null;
        if (editorImpl == null) {
            return null;
        }
        EditorImpl editorImpl2 = editorImpl;
        if (editorImpl2.getEditorKind() != EditorKind.MAIN_EDITOR) {
            return null;
        }
        VirtualFile virtualFile = editorImpl2.getVirtualFile();
        if (virtualFile == null && (virtualFile = FileDocumentManager.getInstance().getFile((Document)((EditorImpl)editor2).getDocument())) == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!((Collection)this.settings.getState().getFileTypes()).isEmpty() && !this.settings.getState().getFileTypes().contains(virtualFile2.getFileType().getDefaultExtension())) {
            return null;
        }
        return editorImpl2;
    }

    public final void editorOpened(@NotNull Editor editor2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (!this.settings.getState().getEnabled()) {
                return;
            }
            EditorImpl editorImpl = this.getEditorImpl(editor2);
            if (editorImpl == null) break block1;
            EditorImpl it = editorImpl;
            boolean bl = false;
            this.addMinimap(it);
        }
    }

    private final JPanel getPanel(EditorImpl fileEditor) {
        JComponent jComponent = fileEditor.getComponent();
        return jComponent instanceof JPanel ? (JPanel)jComponent : null;
    }

    private final void addMinimap(EditorImpl textEditor) {
        JPanel jPanel = this.getPanel(textEditor);
        if (jPanel == null) {
            return;
        }
        JPanel panel2 = jPanel;
        String where = this.settings.getState().getRightAligned() ? "After" : "Before";
        LayoutManager layoutManager = panel2.getLayout();
        BorderLayout borderLayout = layoutManager instanceof BorderLayout ? (BorderLayout)layoutManager : null;
        if ((borderLayout != null ? borderLayout.getLayoutComponent(where) : null) == null) {
            Disposable disposable = textEditor.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            MinimapPanel minimapPanel = new MinimapPanel(disposable, textEditor, panel2);
            panel2.add((Component)minimapPanel, where);
            textEditor.putUserData(MINI_MAP_PANEL_KEY, minimapPanel);
            Disposer.register((Disposable)textEditor.getDisposable(), () -> MinimapService.addMinimap$lambda$0(textEditor));
            panel2.revalidate();
            panel2.repaint();
        }
    }

    private final void removeMinimap(EditorImpl editor2) {
        block1: {
            Container container;
            MinimapPanel minimapPanel = (MinimapPanel)editor2.getUserData(MINI_MAP_PANEL_KEY);
            if (minimapPanel == null) {
                return;
            }
            MinimapPanel minimapPanel2 = minimapPanel;
            minimapPanel2.onClose();
            editor2.putUserData(MINI_MAP_PANEL_KEY, null);
            Container container2 = minimapPanel2.getParent();
            if (container2 == null) break block1;
            Container $this$removeMinimap_u24lambda_u240 = container = container2;
            boolean bl = false;
            $this$removeMinimap_u24lambda_u240.remove(minimapPanel2);
            $this$removeMinimap_u24lambda_u240.revalidate();
            $this$removeMinimap_u24lambda_u240.repaint();
        }
    }

    private static final Unit onSettingsChange$lambda$0(MinimapService this$0, MinimapSettings.SettingsChangeType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (type == MinimapSettings.SettingsChangeType.WithUiRebuild) {
            this$0.updateAllEditors();
        }
        return Unit.INSTANCE;
    }

    private static final void addMinimap$lambda$0(EditorImpl $textEditor) {
        MinimapPanel minimapPanel = (MinimapPanel)$textEditor.getUserData(MINI_MAP_PANEL_KEY);
        if (minimapPanel != null) {
            minimapPanel.onClose();
        }
        $textEditor.putUserData(MINI_MAP_PANEL_KEY, null);
    }

    static {
        Key key = Key.create((String)"com.intellij.ide.minimap.panel");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MINI_MAP_PANEL_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/minimap/MinimapService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ide/minimap/MinimapService;", "MINI_MAP_PANEL_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ide/minimap/MinimapPanel;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nMinimapService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinimapService.kt\ncom/intellij/ide/minimap/MinimapService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,102:1\n42#2,3:103\n*S KotlinDebug\n*F\n+ 1 MinimapService.kt\ncom/intellij/ide/minimap/MinimapService$Companion\n*L\n22#1:103,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MinimapService getInstance() {
            boolean $i$f$service = false;
            Class<MinimapService> serviceClass$iv = MinimapService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (MinimapService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

