/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PageContainer;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginNodeVendorDetails;
import com.intellij.ide.plugins.marketplace.PluginReviewComment;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginNode
implements IdeaPluginDescriptor {
    private static final DecimalFormat K_FORMAT = new DecimalFormat("###.#K");
    private static final DecimalFormat M_FORMAT = new DecimalFormat("###.#M");
    @NotNull
    private PluginId id;
    private String name;
    private boolean isPaid;
    private Integer defaultTrialPeriod;
    private Map<String, Integer> customTrialPeriods;
    private String productCode;
    private Date releaseDate;
    private int releaseVersion;
    private boolean licenseOptional;
    private String version;
    private String vendor;
    @Nullable
    private PluginNodeVendorDetails vendorDetails;
    @NlsSafe
    private String description;
    private String sinceBuild;
    private String untilBuild;
    private String changeNotes;
    private String downloads;
    private String category;
    private String size;
    private String vendorEmail;
    private String vendorUrl;
    private String url;
    private String sourceCodeUrl;
    private String forumUrl;
    private String licenseUrl;
    private String bugtrackerUrl;
    private String documentationUrl;
    private String reportPluginUrl;
    private long date;
    private List<IdeaPluginDependency> myDependencies;
    private Status myStatus;
    private boolean myLoaded;
    private String myDownloadUrl;
    private String myChannel;
    @NlsSafe
    private String myRepositoryName;
    private String myInstalledVersion;
    private boolean myEnabled;
    private String myRating;
    private boolean myIncomplete;
    private List<String> myTags;
    private String externalUpdateId;
    private String externalPluginId;
    private PageContainer<PluginReviewComment> reviewComments;
    private List<String> screenShots;
    private String externalPluginIdForScreenShots;
    private String mySuggestedCommercialIde;
    @NotNull
    private Collection<String> suggestedFeatures;
    private boolean myConverted;
    private Collection<String> dependencyNames;
    private FUSEventSource installSource;

    public PluginNode(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginNode.$$$reportNull$$$0(0);
        }
        this.isPaid = false;
        this.defaultTrialPeriod = null;
        this.customTrialPeriods = null;
        this.vendorDetails = null;
        this.date = Long.MAX_VALUE;
        this.myDependencies = new ArrayList<IdeaPluginDependency>();
        this.myStatus = Status.UNKNOWN;
        this.myEnabled = true;
        this.mySuggestedCommercialIde = null;
        this.suggestedFeatures = Collections.emptyList();
        this.id = id2;
    }

    public PluginNode(@NotNull PluginId id2, String name2, String size2) {
        if (id2 == null) {
            PluginNode.$$$reportNull$$$0(1);
        }
        this.isPaid = false;
        this.defaultTrialPeriod = null;
        this.customTrialPeriods = null;
        this.vendorDetails = null;
        this.date = Long.MAX_VALUE;
        this.myDependencies = new ArrayList<IdeaPluginDependency>();
        this.myStatus = Status.UNKNOWN;
        this.myEnabled = true;
        this.mySuggestedCommercialIde = null;
        this.suggestedFeatures = Collections.emptyList();
        this.id = id2;
        this.name = name2;
        this.size = size2;
    }

    public void setCategory(@NotNull String category) {
        if (category == null) {
            PluginNode.$$$reportNull$$$0(2);
        }
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name2) {
        if (name2 == null) {
            PluginNode.$$$reportNull$$$0(3);
        }
        this.name = name2;
    }

    public void setId(@NotNull String id2) {
        if (id2 == null) {
            PluginNode.$$$reportNull$$$0(4);
        }
        this.id = PluginId.getId((String)id2);
    }

    public boolean getIsPaid() {
        return this.isPaid;
    }

    public void setIsPaid(boolean isPaid) {
        this.isPaid = isPaid;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public Integer getTrialPeriod() {
        return this.defaultTrialPeriod;
    }

    @Deprecated(forRemoval=true)
    public void setTrialPeriod(@Nullable Integer trialPeriod) {
        this.defaultTrialPeriod = trialPeriod;
    }

    @Nullable
    public Integer getDefaultTrialPeriod() {
        return this.defaultTrialPeriod;
    }

    public void setDefaultTrialPeriod(@Nullable Integer trialPeriod) {
        this.defaultTrialPeriod = trialPeriod;
    }

    @ApiStatus.Internal
    @Nullable
    public Integer getTrialPeriodByProductCode(@Nullable String ideProductCode) {
        if (ideProductCode == null || this.customTrialPeriods == null) {
            return this.defaultTrialPeriod;
        }
        return this.customTrialPeriods.getOrDefault(ideProductCode, this.defaultTrialPeriod);
    }

    @ApiStatus.Internal
    public void setCustomTrialPeriodMap(@Nullable Map<String, Integer> customTrialPeriodMap) {
        this.customTrialPeriods = customTrialPeriodMap;
    }

    @Nullable
    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(@Nullable String productCode) {
        this.productCode = productCode;
    }

    @Nullable
    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(@Nullable Date date) {
        this.releaseDate = date;
    }

    public int getReleaseVersion() {
        return this.releaseVersion;
    }

    public void setReleaseVersion(int releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    public boolean isLicenseOptional() {
        return this.licenseOptional;
    }

    public void setLicenseOptional(boolean optional) {
        this.licenseOptional = optional;
    }

    @Nullable
    public String getExternalUpdateId() {
        return this.externalUpdateId;
    }

    public void setExternalUpdateId(@Nullable String externalUpdateId) {
        this.externalUpdateId = externalUpdateId;
    }

    @Nullable
    public String getExternalPluginId() {
        return this.externalPluginId;
    }

    public void setExternalPluginId(@Nullable String externalPluginId) {
        this.externalPluginId = externalPluginId;
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Nullable
    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(@Nullable String vendor) {
        this.vendor = vendor;
    }

    @ApiStatus.Internal
    @Nullable
    public PluginNodeVendorDetails getVendorDetails() {
        return this.vendorDetails;
    }

    @ApiStatus.Internal
    public void setVendorDetails(@Nullable PluginNodeVendorDetails vendorDetails) {
        this.vendorDetails = vendorDetails;
    }

    public void setVendorDetails(@NlsSafe @NotNull String vendorName, @Nullable String url, @Nullable Boolean isTrader, @Nullable Boolean isVerified) {
        if (vendorName == null) {
            PluginNode.$$$reportNull$$$0(5);
        }
        this.vendorDetails = new PluginNodeVendorDetails(vendorName, url, isTrader, isVerified);
    }

    public void setVendorDetails(@NlsSafe @Nullable String vendorName) {
        if (vendorName == null) {
            return;
        }
        this.vendorDetails = new PluginNodeVendorDetails(vendorName, null, null, null);
    }

    @Nullable
    public String getOrganization() {
        if (this.vendorDetails == null) {
            return null;
        }
        return this.vendorDetails.getName();
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable @NlsSafe String description) {
        this.description = description;
    }

    @Nullable
    public String getChangeNotes() {
        return this.changeNotes;
    }

    public void setChangeNotes(@Nullable String changeNotes) {
        this.changeNotes = changeNotes;
    }

    @Nullable
    public String getSinceBuild() {
        return this.sinceBuild;
    }

    public void setSinceBuild(@Nullable String sinceBuild) {
        this.sinceBuild = sinceBuild;
    }

    public Status getStatus() {
        return this.myStatus;
    }

    public void setStatus(Status status2) {
        this.myStatus = status2;
    }

    public boolean isLoaded() {
        return this.myLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.myLoaded = loaded;
    }

    @Nullable
    @NlsSafe
    public String getDownloads() {
        return this.downloads;
    }

    public void setDownloads(@Nullable String downloads) {
        this.downloads = downloads;
    }

    @Nullable
    @NlsSafe
    public String getPresentableDownloads() {
        if (!StringUtil.isEmptyOrSpaces((String)this.downloads)) {
            try {
                long value = Long.parseLong(this.downloads);
                return value <= 1000L ? Long.toString(value) : (value < 1000000L ? K_FORMAT.format((double)value / 1000.0) : M_FORMAT.format((double)value / 1000000.0));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size2) {
        this.size = size2;
    }

    public long getIntegerSize() {
        try {
            return Long.parseLong(this.size);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Nullable
    @NlsSafe
    public String getPresentableSize() {
        long size2 = this.getIntegerSize();
        return size2 >= 0L ? StringUtil.formatFileSize((long)size2).toUpperCase(Locale.ENGLISH) : null;
    }

    @Nullable
    public String getVendorEmail() {
        return this.vendorEmail;
    }

    public void setVendorEmail(@Nullable String vendorEmail) {
        this.vendorEmail = vendorEmail;
    }

    @Nullable
    public String getVendorUrl() {
        return this.vendorUrl;
    }

    public void setVendorUrl(@Nullable String vendorUrl) {
        this.vendorUrl = vendorUrl;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    @Nullable
    public String getSourceCodeUrl() {
        return this.sourceCodeUrl;
    }

    public void setSourceCodeUrl(@Nullable String sourceCodeUrl) {
        this.sourceCodeUrl = sourceCodeUrl;
    }

    @Nullable
    public String getForumUrl() {
        return this.forumUrl;
    }

    public void setForumUrl(@Nullable String forumUrl) {
        this.forumUrl = forumUrl;
    }

    @Nullable
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(@Nullable String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    @Nullable
    public String getBugtrackerUrl() {
        return this.bugtrackerUrl;
    }

    public void setBugtrackerUrl(@Nullable String bugtrackerUrl) {
        this.bugtrackerUrl = bugtrackerUrl;
    }

    @Nullable
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public void setDocumentationUrl(@Nullable String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    @Nullable
    public String getReportPluginUrl() {
        return this.reportPluginUrl;
    }

    public void setReportPluginUrl(@Nullable String reportPluginUrl) {
        this.reportPluginUrl = reportPluginUrl;
    }

    public void setDate(String date) {
        this.date = Long.parseLong(date);
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public long getDate() {
        return this.date;
    }

    @Nullable
    @NlsSafe
    public String getPresentableDate() {
        long date = this.getDate();
        return date > 0L && date != Long.MAX_VALUE ? PluginManagerConfigurable.DATE_FORMAT.format(new Date(date)) : null;
    }

    @Deprecated(forRemoval=true)
    public void setDepends(@NotNull List<PluginId> depends, PluginId @Nullable [] optionalDependencies) {
        if (depends == null) {
            PluginNode.$$$reportNull$$$0(6);
        }
        this.myDependencies = new ArrayList<IdeaPluginDependency>();
        for (PluginId id2 : depends) {
            this.myDependencies.add(new PluginNodeDependency(id2, false));
        }
        if (optionalDependencies != null) {
            for (PluginId dependency : optionalDependencies) {
                this.myDependencies.add(new PluginNodeDependency(dependency, true));
            }
        }
    }

    public void setDependencies(@NotNull List<? extends IdeaPluginDependency> dependencies) {
        if (dependencies == null) {
            PluginNode.$$$reportNull$$$0(7);
        }
        this.myDependencies = new ArrayList<IdeaPluginDependency>(dependencies);
    }

    public void addDepends(@NotNull String id2) {
        if (id2 == null) {
            PluginNode.$$$reportNull$$$0(8);
        }
        this.addDepends(id2, false);
    }

    public void addDepends(@NotNull String id2, boolean optional) {
        if (id2 == null) {
            PluginNode.$$$reportNull$$$0(9);
        }
        this.myDependencies.add(new PluginNodeDependency(PluginId.getId((String)id2), optional));
    }

    public void addDepends(@NotNull PluginId id2, boolean optional) {
        if (id2 == null) {
            PluginNode.$$$reportNull$$$0(10);
        }
        this.myDependencies.add(new PluginNodeDependency(id2, optional));
    }

    @NotNull
    public List<IdeaPluginDependency> getDependencies() {
        List<IdeaPluginDependency> list2 = this.myDependencies;
        if (list2 == null) {
            PluginNode.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Nullable
    public String getDescriptorPath() {
        return null;
    }

    public List<String> getTags() {
        return this.myTags;
    }

    public void setTags(@NotNull List<String> tags) {
        if (tags == null) {
            PluginNode.$$$reportNull$$$0(12);
        }
        this.myTags = new ArrayList<String>(tags);
    }

    public void addTags(@NotNull String tag) {
        if (tag == null) {
            PluginNode.$$$reportNull$$$0(13);
        }
        (this.myTags != null ? this.myTags : (this.myTags = new ArrayList<String>())).add(tag);
    }

    @NotNull
    public PluginId getPluginId() {
        PluginId pluginId = this.id;
        if (pluginId == null) {
            PluginNode.$$$reportNull$$$0(14);
        }
        return pluginId;
    }

    @Nullable
    public ClassLoader getPluginClassLoader() {
        return null;
    }

    public Path getPluginPath() {
        return null;
    }

    @Nullable
    public String getResourceBundleBaseName() {
        return null;
    }

    @Nullable
    public String getUntilBuild() {
        return this.untilBuild;
    }

    public void setUntilBuild(@Nullable String untilBuild) {
        this.untilBuild = untilBuild;
    }

    @Deprecated
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Deprecated
    public void setEnabled(boolean enabled2) {
        this.myEnabled = enabled2;
    }

    public String getDownloadUrl() {
        return this.myDownloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.myDownloadUrl = downloadUrl;
    }

    @ApiStatus.Experimental
    public String getChannel() {
        return this.myChannel;
    }

    @ApiStatus.Experimental
    public void setChannel(String channel) {
        this.myChannel = channel;
    }

    @NlsSafe
    public String getRepositoryName() {
        return this.myRepositoryName;
    }

    public void setRepositoryName(@NlsSafe String repositoryName) {
        this.myRepositoryName = repositoryName;
    }

    public String getInstalledVersion() {
        return this.myInstalledVersion;
    }

    public void setInstalledVersion(String installedVersion) {
        this.myInstalledVersion = installedVersion;
    }

    public String getRating() {
        return this.myRating;
    }

    public void setRating(String rating) {
        this.myRating = rating;
    }

    @Nullable
    @NlsSafe
    public String getPresentableRating() {
        String rating = this.getRating();
        if (!StringUtil.isEmptyOrSpaces((String)rating)) {
            try {
                if (Double.parseDouble(rating) > 0.0) {
                    return StringUtil.trimEnd((String)rating, (String)".0");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isIncomplete() {
        return this.myIncomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this.myIncomplete = incomplete;
    }

    public boolean detailsLoaded() {
        return this.externalPluginId == null || this.externalUpdateId == null || this.description != null;
    }

    @ApiStatus.Internal
    @Nullable
    public PageContainer<PluginReviewComment> getReviewComments() {
        return this.reviewComments;
    }

    @ApiStatus.Internal
    public void setReviewComments(@NotNull PageContainer<PluginReviewComment> reviewComments) {
        if (reviewComments == null) {
            PluginNode.$$$reportNull$$$0(15);
        }
        this.reviewComments = reviewComments;
    }

    @Nullable
    public List<String> getScreenShots() {
        return this.screenShots;
    }

    @Nullable
    public String getExternalPluginIdForScreenShots() {
        return this.externalPluginIdForScreenShots;
    }

    public void setExternalPluginIdForScreenShots(@Nullable String externalPluginId) {
        this.externalPluginIdForScreenShots = externalPluginId;
    }

    public void setScreenShots(@NotNull List<String> screenshots) {
        if (screenshots == null) {
            PluginNode.$$$reportNull$$$0(16);
        }
        this.screenShots = screenshots;
    }

    public String getSuggestedCommercialIde() {
        return this.mySuggestedCommercialIde;
    }

    public void setSuggestedCommercialIde(String commercialIdeCode) {
        this.mySuggestedCommercialIde = commercialIdeCode;
    }

    @NotNull
    public Collection<String> getSuggestedFeatures() {
        Collection<String> collection = this.suggestedFeatures;
        if (collection == null) {
            PluginNode.$$$reportNull$$$0(17);
        }
        return collection;
    }

    public void setSuggestedFeatures(@NotNull Collection<String> features) {
        if (features == null) {
            PluginNode.$$$reportNull$$$0(18);
        }
        this.suggestedFeatures = features;
    }

    @Nullable
    public Collection<String> getDependencyNames() {
        return this.dependencyNames;
    }

    public void setDependencyNames(@Nullable Collection<String> dependencyNames) {
        this.dependencyNames = dependencyNames;
    }

    public boolean isConverted() {
        return this.myConverted;
    }

    public void setConverted(boolean converted) {
        this.myConverted = converted;
    }

    @ApiStatus.Internal
    public FUSEventSource getInstallSource() {
        return this.installSource;
    }

    @ApiStatus.Internal
    public void setInstallSource(FUSEventSource installSource) {
        this.installSource = installSource;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof PluginNode && this.id.equals((Object)((PluginNode)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @NotNull
    public String toString() {
        String string = String.format("PluginNode{id=%s, name='%s'}", this.id, this.name);
        if (string == null) {
            PluginNode.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 14, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendorName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depends";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginNode";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reviewComments";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenshots";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "features";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginNode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedFeatures";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCategory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVendorDetails";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDepends";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setDependencies";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDepends";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 19: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTags";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addTags";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setReviewComments";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setScreenShots";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setSuggestedFeatures";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 14, 17, 19 -> new IllegalStateException(string);
        };
    }

    public static enum Status {
        UNKNOWN,
        INSTALLED,
        DOWNLOADED,
        DELETED;

    }

    private static final class PluginNodeDependency
    implements IdeaPluginDependency {
        @NotNull
        private final PluginId myPluginId;
        private final boolean myOptional;

        private PluginNodeDependency(@NotNull PluginId id2, boolean optional) {
            if (id2 == null) {
                PluginNodeDependency.$$$reportNull$$$0(0);
            }
            this.myPluginId = id2;
            this.myOptional = optional;
        }

        @NotNull
        public PluginId getPluginId() {
            PluginId pluginId = this.myPluginId;
            if (pluginId == null) {
                PluginNodeDependency.$$$reportNull$$$0(1);
            }
            return pluginId;
        }

        public boolean isOptional() {
            return this.myOptional;
        }

        public String toString() {
            return "PluginNodeDependency{pluginId=" + String.valueOf(this.myPluginId) + ", optional=" + this.myOptional + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginNode$PluginNodeDependency";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginNode$PluginNodeDependency";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPluginId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

