/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.marketplace.GuessFileParameters;
import com.intellij.ide.plugins.marketplace.MarketplaceRequestsKt;
import com.intellij.ide.plugins.marketplace.PluginChunkDataSource;
import com.intellij.ide.plugins.marketplace.PluginChunkMerger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.PathUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.jetbrains.plugin.blockmap.core.BlockMap;
import com.jetbrains.plugin.blockmap.core.Chunk;
import com.jetbrains.plugin.blockmap.core.FileHash;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 .2\u00020\u0001:\u0001.B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ.\u0010\u0014\u001a\u00020\u000b2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J*\u0010\u001d\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010!\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001aH\u0002J\u001c\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020)0(2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006/"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplacePluginDownloadService;", "", "<init>", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "downloadPlugin", "Ljava/nio/file/Path;", "pluginUrl", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "checkPluginCanBeDownloaded", "", "downloadPluginViaBlockMap", "prevPlugin", "processBlockmapDownloadProblem", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "printStackTrace", "getBlockMapFromZip", "Lcom/jetbrains/plugin/blockmap/core/BlockMap;", "input", "Ljava/io/InputStream;", "guessPluginFilenameAndRenameDownloadedFile", "contentDisposition", "url", "file", "guessFileName", "usedURL", "downloadPercent", "", "oldBlockMap", "newBlockMap", "getPluginFileUrlAndGuessFileParameters", "Lkotlin/Pair;", "Lcom/intellij/ide/plugins/marketplace/GuessFileParameters;", "getPluginFileUrl", "connection", "Ljava/net/URLConnection;", "getPrevPluginArchive", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMarketplacePluginDownloadService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketplacePluginDownloadService.kt\ncom/intellij/ide/plugins/marketplace/MarketplacePluginDownloadService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,250:1\n1#2:251\n774#3:252\n865#3,2:253\n13#4:255\n*S KotlinDebug\n*F\n+ 1 MarketplacePluginDownloadService.kt\ncom/intellij/ide/plugins/marketplace/MarketplacePluginDownloadService\n*L\n221#1:252\n221#1:253,2\n26#1:255\n*E\n"})
public class MarketplacePluginDownloadService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy objectMapper$delegate = LazyKt.lazy(MarketplacePluginDownloadService::objectMapper_delegate$lambda$0);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String BLOCKMAP_ZIP_SUFFIX = ".blockmap.zip";
    @NotNull
    private static final String BLOCKMAP_FILENAME = "blockmap.json";
    @NotNull
    private static final String HASH_FILENAME_SUFFIX = ".hash.json";
    @NotNull
    private static final String FILENAME = "filename=";
    private static final double MAXIMUM_DOWNLOAD_PERCENT = 0.65;

    private final ObjectMapper getObjectMapper() {
        Lazy lazy = this.objectMapper$delegate;
        return (ObjectMapper)lazy.getValue();
    }

    @NotNull
    public Path downloadPlugin(@NotNull String pluginUrl, @Nullable ProgressIndicator indicator2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pluginUrl, (String)"pluginUrl");
        Path file2 = Companion.getPluginTempFile();
        RequestBuilder requestBuilder = HttpRequests.request((String)pluginUrl);
        Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"request(...)");
        Object object = MarketplaceRequestsKt.setHeadersViaTuner(requestBuilder).gzip(false).productNameAsUserAgent().connect(arg_0 -> MarketplacePluginDownloadService.downloadPlugin$lambda$0(file2, indicator2, this, pluginUrl, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
        return (Path)object;
    }

    public final boolean checkPluginCanBeDownloaded(@NotNull String pluginUrl, @Nullable ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)pluginUrl, (String)"pluginUrl");
        try {
            RequestBuilder requestBuilder = HttpRequests.request((String)pluginUrl);
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"request(...)");
            Object object = MarketplaceRequestsKt.setHeadersViaTuner(requestBuilder).gzip(false).productNameAsUserAgent().connect(MarketplacePluginDownloadService::checkPluginCanBeDownloaded$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
            return (Boolean)object;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Path downloadPluginViaBlockMap(@NotNull String pluginUrl, @NotNull Path prevPlugin, @Nullable ProgressIndicator indicator2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pluginUrl, (String)"pluginUrl");
        Intrinsics.checkNotNullParameter((Object)prevPlugin, (String)"prevPlugin");
        Path prevPluginArchive = this.getPrevPluginArchive(prevPlugin);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(prevPluginArchive, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Object[] objectArray = new Object[]{((Object)prevPluginArchive).toString()};
            LOG.info(IdeBundle.message((String)"error.file.not.found.message", (Object[])objectArray));
            return this.downloadPlugin(pluginUrl, indicator2);
        }
        Pair<String, GuessFileParameters> pair = this.getPluginFileUrlAndGuessFileParameters(pluginUrl);
        String pluginFileUrl = (String)pair.component1();
        GuessFileParameters guessFileParameters = (GuessFileParameters)pair.component2();
        String blockMapFileUrl = pluginFileUrl + BLOCKMAP_ZIP_SUFFIX;
        String pluginHashFileUrl = pluginFileUrl + HASH_FILENAME_SUFFIX;
        try {
            FileHash fileHash;
            Object object;
            Object input;
            RequestBuilder requestBuilder = HttpRequests.request((String)blockMapFileUrl);
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"request(...)");
            BlockMap newBlockMap = (BlockMap)MarketplaceRequestsKt.setHeadersViaTuner(requestBuilder).productNameAsUserAgent().connect(arg_0 -> MarketplacePluginDownloadService.downloadPluginViaBlockMap$lambda$0(this, arg_0));
            LOG.info("Plugin's blockmap file downloaded");
            RequestBuilder requestBuilder2 = HttpRequests.request((String)pluginHashFileUrl);
            Intrinsics.checkNotNullExpressionValue((Object)requestBuilder2, (String)"request(...)");
            FileHash newPluginHash = (FileHash)MarketplaceRequestsKt.setHeadersViaTuner(requestBuilder2).productNameAsUserAgent().connect(arg_0 -> MarketplacePluginDownloadService.downloadPluginViaBlockMap$lambda$1(this, arg_0));
            LOG.info("Plugin's hash file downloaded");
            Closeable closeable = new FileInputStream(prevPluginArchive.toFile());
            Throwable throwable = null;
            try {
                input = (FileInputStream)closeable;
                boolean bl = false;
                input = new BlockMap((InputStream)input, newBlockMap.getAlgorithm(), newBlockMap.getMinSize(), newBlockMap.getMaxSize(), newBlockMap.getNormalSize());
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            FileInputStream oldBlockMap = input;
            Intrinsics.checkNotNull((Object)newBlockMap);
            double downloadPercent = this.downloadPercent((BlockMap)oldBlockMap, newBlockMap);
            input = "Plugin's download percent is = %.2f";
            Object[] bl = new Object[]{downloadPercent * (double)100};
            String string = String.format((String)input, Arrays.copyOf(bl, bl.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            LOG.info(string);
            if (downloadPercent > 0.65) {
                LOG.info(IdeBundle.message((String)"too.large.download.size", (Object[])new Object[0]));
                return this.downloadPlugin(pluginUrl, indicator2);
            }
            Path file2 = Companion.getPluginTempFile();
            File file3 = prevPluginArchive.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
            PluginChunkMerger merger = new PluginChunkMerger(file3, (BlockMap)oldBlockMap, newBlockMap, indicator2);
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(file2, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable2 = outputStream;
            Object object2 = null;
            try {
                OutputStream output = (OutputStream)closeable2;
                boolean bl2 = false;
                merger.merge(output, new PluginChunkDataSource((BlockMap)oldBlockMap, newBlockMap, pluginFileUrl));
                object = Unit.INSTANCE;
            }
            catch (Throwable bl2) {
                object2 = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object2);
            }
            OpenOption[] openOptionArray2 = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(file2, Arrays.copyOf(openOptionArray2, openOptionArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            object2 = inputStream;
            object = null;
            try {
                InputStream input2 = (InputStream)object2;
                boolean bl3 = false;
                fileHash = new FileHash(input2, newPluginHash.getAlgorithm());
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            FileHash curFileHash = fileHash;
            if (!Intrinsics.areEqual((Object)curFileHash, (Object)newPluginHash)) {
                LOG.info(IdeBundle.message((String)"hashes.doesnt.match", (Object[])new Object[0]));
                return this.downloadPlugin(pluginUrl, indicator2);
            }
            return StringsKt.endsWith$default((String)pluginFileUrl, (String)".zip", (boolean)false, (int)2, null) ? Companion.renameFileToZipRoot(file2) : this.guessPluginFilenameAndRenameDownloadedFile(guessFileParameters.contentDisposition, guessFileParameters.url, file2, pluginUrl);
        }
        catch (HttpRequests.HttpStatusException e) {
            return this.processBlockmapDownloadProblem((Exception)((Object)e), pluginUrl, indicator2, false);
        }
        catch (Exception e) {
            return this.processBlockmapDownloadProblem(e, pluginUrl, indicator2, true);
        }
    }

    private final Path processBlockmapDownloadProblem(Exception exception, String pluginUrl, ProgressIndicator indicator2, boolean printStackTrace) {
        Object[] objectArray = new Object[]{pluginUrl};
        String string = IdeBundle.message((String)"error.download.plugin.via.blockmap", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        if (printStackTrace) {
            LOG.info(message, (Throwable)exception);
        } else {
            LOG.info(message + ": " + exception.getMessage());
        }
        return this.downloadPlugin(pluginUrl, indicator2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BlockMap getBlockMapFromZip(InputStream input) throws IOException {
        BlockMap blockMap;
        Closeable closeable = input;
        int n = 8192;
        closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
        Throwable throwable = null;
        try {
            ZipInputStream zip;
            block6: {
                zip = (ZipInputStream)closeable;
                boolean bl = false;
                while (zip.getNextEntry() != null) {
                    ZipEntry entry;
                    if (!Intrinsics.areEqual((Object)entry.getName(), (Object)BLOCKMAP_FILENAME)) continue;
                    break block6;
                }
                throw new IOException("There is no entry blockmap.json");
            }
            BlockMap blockMap2 = (BlockMap)this.getObjectMapper().readValue(ByteStreamsKt.readBytes((InputStream)zip), BlockMap.class);
            blockMap = blockMap2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)blockMap, (String)"use(...)");
        return blockMap;
    }

    private final Path guessPluginFilenameAndRenameDownloadedFile(String contentDisposition, String url, Path file2, String pluginUrl) {
        String fileName = this.guessFileName(contentDisposition, url, file2, pluginUrl);
        Path newFile = file2.resolveSibling(fileName);
        Path path = file2;
        Intrinsics.checkNotNull((Object)newFile);
        Path path2 = newFile;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        CopyOption[] copyOptionArray2 = copyOptionArray;
        Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, path2, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"move(...)");
        return newFile;
    }

    private final String guessFileName(String contentDisposition, String usedURL, Path file2, String pluginUrl) throws IOException {
        String fileName = null;
        LOG.debug("header: " + contentDisposition);
        if (contentDisposition != null && StringsKt.contains$default((CharSequence)contentDisposition, (CharSequence)FILENAME, (boolean)false, (int)2, null)) {
            int startIdx;
            int endIdx = StringsKt.indexOf$default((CharSequence)contentDisposition, (char)';', (int)(startIdx = StringsKt.indexOf$default((CharSequence)contentDisposition, (String)FILENAME, (int)0, (boolean)false, (int)6, null)), (boolean)false, (int)4, null);
            String string = contentDisposition.substring(startIdx + 9, endIdx > 0 ? endIdx : contentDisposition.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            fileName = string;
            if (StringsKt.startsWith$default((CharSequence)fileName, (char)'\"', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)fileName, (char)'\"', (boolean)false, (int)2, null)) {
                String string2 = fileName.substring(1, fileName.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                fileName = string2;
            }
        }
        if (fileName == null) {
            LOG.debug("url: " + usedURL);
            String string = usedURL.substring(StringsKt.lastIndexOf$default((CharSequence)usedURL, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            fileName = string;
            if (((CharSequence)fileName).length() == 0 || StringsKt.contains$default((CharSequence)fileName, (CharSequence)"?", (boolean)false, (int)2, null)) {
                String string3 = pluginUrl.substring(StringsKt.lastIndexOf$default((CharSequence)pluginUrl, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                fileName = string3;
            }
        }
        if (!PathUtil.isValidFileName(fileName)) {
            LOG.debug("fileName: " + fileName);
            Files.deleteIfExists(file2);
            throw new IOException("Invalid filename returned by a server");
        }
        return fileName;
    }

    /*
     * WARNING - void declaration
     */
    private final double downloadPercent(BlockMap oldBlockMap, BlockMap newBlockMap) {
        int n;
        void $this$filterTo$iv$iv;
        Set oldSet = CollectionsKt.toSet((Iterable)oldBlockMap.getChunks());
        Iterable $this$filter$iv = newBlockMap.getChunks();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Chunk chunk = (Chunk)element$iv$iv;
            boolean bl = false;
            if (!(!oldSet.contains(chunk))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newChunks = (List)destination$iv$iv;
        Iterable iterable = newChunks;
        int n2 = 0;
        for (Object object : iterable) {
            void chunk;
            Chunk $i$f$filterTo2 = (Chunk)object;
            int n3 = n2;
            boolean bl = false;
            int n4 = chunk.getLength();
            n2 = n3 + n4;
        }
        iterable = newBlockMap.getChunks();
        double d = n2;
        n2 = 0;
        for (Object object : iterable) {
            Chunk chunk = (Chunk)object;
            n = n2;
            boolean bl = false;
            int n5 = chunk.getLength();
            n2 = n + n5;
        }
        n = n2;
        return d / (double)n;
    }

    private final Pair<String, GuessFileParameters> getPluginFileUrlAndGuessFileParameters(String pluginUrl) {
        RequestBuilder requestBuilder = HttpRequests.request((String)pluginUrl);
        Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"request(...)");
        Object object = MarketplaceRequestsKt.setHeadersViaTuner(requestBuilder).productNameAsUserAgent().connect(arg_0 -> MarketplacePluginDownloadService.getPluginFileUrlAndGuessFileParameters$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
        return (Pair)object;
    }

    private final String getPluginFileUrl(URLConnection connection) {
        URL url = connection.getURL();
        boolean bl = false;
        return url.getPort() == -1 ? url.getProtocol() + "://" + url.getHost() + url.getPath() : url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + url.getPath();
    }

    private final Path getPrevPluginArchive(Path prevPlugin) {
        String suffix = prevPlugin.endsWith(".jar") ? "" : ".zip";
        Path path = PathManager.getStartupScriptDir().resolve(prevPlugin.getFileName() + suffix);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final ObjectMapper objectMapper_delegate$lambda$0() {
        return new ObjectMapper();
    }

    private static final Path downloadPlugin$lambda$0(Path $file, ProgressIndicator $indicator, MarketplacePluginDownloadService this$0, String $pluginUrl, HttpRequests.Request request) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        request.saveToFile($file, $indicator);
        URLConnection uRLConnection = request.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"getConnection(...)");
        String pluginFileUrl = this$0.getPluginFileUrl(uRLConnection);
        if (StringsKt.endsWith$default((String)pluginFileUrl, (String)".zip", (boolean)false, (int)2, null)) {
            path = Companion.renameFileToZipRoot($file);
        } else {
            String contentDisposition = request.getConnection().getHeaderField("Content-Disposition");
            String string = request.getConnection().getURL().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String url = string;
            path = this$0.guessPluginFilenameAndRenameDownloadedFile(contentDisposition, url, $file, $pluginUrl);
        }
        return path;
    }

    private static final Boolean checkPluginCanBeDownloaded$lambda$0(HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return request.readError() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final BlockMap downloadPluginViaBlockMap$lambda$0(MarketplacePluginDownloadService this$0, HttpRequests.Request request) {
        BlockMap blockMap;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Closeable closeable = request.getInputStream();
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)input);
            blockMap = this$0.getBlockMapFromZip(input);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return blockMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final FileHash downloadPluginViaBlockMap$lambda$1(MarketplacePluginDownloadService this$0, HttpRequests.Request request) {
        FileHash fileHash;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        InputStream inputStream = request.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Closeable closeable = inputStream;
        Charset charset = Charsets.UTF_8;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        int n = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        Throwable throwable = null;
        try {
            BufferedReader input = (BufferedReader)closeable;
            boolean bl = false;
            fileHash = (FileHash)this$0.getObjectMapper().readValue(TextStreamsKt.readText((Reader)input), FileHash.class);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return fileHash;
    }

    private static final Pair getPluginFileUrlAndGuessFileParameters$lambda$0(MarketplacePluginDownloadService this$0, HttpRequests.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        URLConnection uRLConnection = request.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"getConnection(...)");
        URLConnection connection = uRLConnection;
        String string = this$0.getPluginFileUrl(connection);
        String string2 = connection.getHeaderField("Content-Disposition");
        String string3 = connection.getURL().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return TuplesKt.to((Object)string, (Object)new GuessFileParameters(string2, string3));
    }

    @JvmStatic
    @NotNull
    public static final Path getPluginTempFile() throws IOException {
        return Companion.getPluginTempFile();
    }

    @JvmStatic
    @NotNull
    public static final Path renameFileToZipRoot(@NotNull Path zip) throws IOException {
        return Companion.renameFileToZipRoot(zip);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MarketplacePluginDownloadService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/plugins/marketplace/MarketplacePluginDownloadService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "BLOCKMAP_ZIP_SUFFIX", "", "BLOCKMAP_FILENAME", "HASH_FILENAME_SUFFIX", "FILENAME", "MAXIMUM_DOWNLOAD_PERCENT", "", "getPluginTempFile", "Ljava/nio/file/Path;", "renameFileToZipRoot", "zip", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Path getPluginTempFile() throws IOException {
            Path path = PathManager.getStartupScriptDir();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getStartupScriptDir(...)");
            Path path2 = path;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
            return PathsKt.createTempFile((Path)path3, (String)"plugin_", (String)"_download", (FileAttribute[])new FileAttribute[0]);
        }

        @JvmStatic
        @NotNull
        public final Path renameFileToZipRoot(@NotNull Path zip) throws IOException {
            Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
            String newName = PluginInstaller.rootEntryName(zip) + ".zip";
            Path newZip = zip.resolveSibling(newName);
            Path path = zip;
            Intrinsics.checkNotNull((Object)newZip);
            Path path2 = newZip;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, path2, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"move(...)");
            return newZip;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

