/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelBuilder;
import com.intellij.ide.plugins.newui.PluginUiModelBuilderFactory;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class RepositoryContentHandler
extends DefaultHandler {
    @NonNls
    private static final String CATEGORY = "category";
    @NonNls
    private static final String PLUGIN = "plugin";
    @NonNls
    private static final String IDEA_PLUGIN = "idea-plugin";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String VERSION = "version";
    @NonNls
    private static final String VENDOR = "vendor";
    @NonNls
    private static final String EMAIL = "email";
    @NonNls
    private static final String URL = "url";
    @NonNls
    private static final String IDEA_VERSION = "idea-version";
    @NonNls
    private static final String SINCE_BUILD = "since-build";
    @NonNls
    private static final String UNTIL_BUILD = "until-build";
    @NonNls
    private static final String CHANGE_NOTES = "change-notes";
    @NonNls
    private static final String DEPENDS = "depends";
    @NonNls
    private static final String DOWNLOADS = "downloads";
    @NonNls
    private static final String DOWNLOAD_URL = "downloadUrl";
    @NonNls
    private static final String DOWNLOAD_URL_NEW_STYLE = "download-url";
    @NonNls
    private static final String SIZE = "size";
    @NonNls
    private static final String RATING = "rating";
    @NonNls
    private static final String DATE = "date";
    @NonNls
    private static final String PLUGIN_UPDATED_DATE = "updatedDate";
    @NonNls
    private static final String TAGS = "tags";
    @NonNls
    private static final String PRODUCT_CODE = "productCode";
    private final StringBuilder currentValue = new StringBuilder();
    private final PluginUiModelBuilderFactory factory;
    private PluginUiModelBuilder builder = null;
    private List<PluginUiModel> plugins;
    private Stack<String> categories;
    private String categoryName;

    RepositoryContentHandler(PluginUiModelBuilderFactory factory) {
        this.factory = factory;
    }

    @NotNull
    List<PluginUiModel> getPluginsList() {
        List<Object> list2 = this.plugins == null ? Collections.emptyList() : this.plugins;
        if (list2 == null) {
            RepositoryContentHandler.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    public void startDocument() {
        this.plugins = new ArrayList<PluginUiModel>();
        this.categories = new Stack();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(CATEGORY)) {
            String category = attributes.getValue(NAME);
            if (!StringUtil.isEmptyOrSpaces((String)category)) {
                this.categories.push((Object)category);
                this.categoryName = null;
            }
        } else if (qName.equals(IDEA_PLUGIN)) {
            String dateString;
            this.builder = this.factory.createBuilder(PluginId.getId((String)"unknown")).setCategory(this.buildCategoryName()).setDownloads(attributes.getValue(DOWNLOADS)).setSize(attributes.getValue(SIZE)).setUrl(attributes.getValue(URL));
            String string = dateString = attributes.getValue(PLUGIN_UPDATED_DATE) != null ? attributes.getValue(PLUGIN_UPDATED_DATE) : attributes.getValue(DATE);
            if (dateString != null) {
                this.builder.setDate(dateString);
            }
            this.builder.setIncomplete(false);
        } else if (qName.equals(IDEA_VERSION)) {
            this.builder.setSinceBuild(attributes.getValue(SINCE_BUILD)).setUntilBuild(PluginManager.convertExplicitBigNumberInUntilBuildToStar((String)attributes.getValue(UNTIL_BUILD)));
        } else if (qName.equals(VENDOR)) {
            this.builder.setVendorEmail(attributes.getValue(EMAIL)).setVendorUrl(attributes.getValue(URL));
        } else if (qName.equals(PLUGIN)) {
            String id2 = attributes.getValue(ID);
            this.builder = id2 == null ? this.factory.createBuilder(PluginId.getId((String)"unknown")) : this.factory.createBuilder(PluginId.getId((String)id2));
            this.builder.setDownloadUrl(attributes.getValue(URL)).setVersion(attributes.getValue(VERSION)).setIncomplete(true);
        }
        this.currentValue.setLength(0);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        String currentValueString = this.currentValue.toString();
        this.currentValue.setLength(0);
        switch (qName) {
            case "id": {
                this.builder.setId(currentValueString);
                break;
            }
            case "name": {
                this.builder.setName(currentValueString);
                break;
            }
            case "description": {
                this.builder.setDescription(currentValueString);
                break;
            }
            case "version": {
                this.builder.setVersion(currentValueString);
                break;
            }
            case "vendor": {
                this.builder.setVendor(currentValueString);
                break;
            }
            case "depends": {
                this.builder.addDependency(currentValueString, false);
                break;
            }
            case "change-notes": {
                this.builder.setChangeNotes(currentValueString);
                break;
            }
            case "category": {
                this.categories.pop();
                this.categoryName = null;
                break;
            }
            case "rating": {
                this.builder.setRating(currentValueString);
                break;
            }
            case "downloadUrl": 
            case "download-url": {
                this.builder.setDownloadUrl(currentValueString);
                break;
            }
            case "idea-plugin": 
            case "plugin": {
                if (this.builder != null) {
                    this.builder.setIsFromMarketPlace(true);
                    this.plugins.add(this.builder.build());
                }
                this.builder = null;
                break;
            }
            case "tags": {
                this.builder.addTag(currentValueString);
                break;
            }
            case "productCode": {
                this.builder.setProductCode(currentValueString);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start2, int length) {
        this.currentValue.append(ch, start2, length);
    }

    @NotNull
    private String buildCategoryName() {
        if (this.categoryName == null) {
            this.categoryName = String.join((CharSequence)"/", this.categories);
        }
        String string = this.categoryName;
        if (string == null) {
            RepositoryContentHandler.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/plugins/marketplace/RepositoryContentHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCategoryName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

