/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.marketplace.statistics.collectors;

import com.intellij.ide.plugins.marketplace.statistics.collectors.PluginManagerFUSCollector;
import com.intellij.ide.plugins.marketplace.statistics.collectors.PluginManagerMPCollectorKt;
import com.intellij.ide.plugins.marketplace.statistics.features.PluginManagerLocalSearchFeatureProvider;
import com.intellij.ide.plugins.marketplace.statistics.features.PluginManagerMarketplaceSearchFeatureProvider;
import com.intellij.ide.plugins.marketplace.statistics.features.PluginManagerSearchResultsFeatureProvider;
import com.intellij.ide.plugins.marketplace.statistics.features.PluginManagerUserQueryFeatureProvider;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BaseEventId;
import com.intellij.internal.statistic.eventLog.events.EventDataCollector;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.events.ObjectEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016JN\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0016\b\u0002\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dJN\u0010\u001f\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020 2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0016\b\u0002\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dJ\u000e\u0010!\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ide/plugins/marketplace/statistics/collectors/PluginManagerMPCollector;", "Lcom/intellij/ide/plugins/marketplace/statistics/collectors/PluginManagerFUSCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "USER_QUERY_FEATURES_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/ObjectEventField;", "MARKETPLACE_SEARCH_FEATURES_DATA_KEY", "LOCAL_SEARCH_FEATURES_DATA_KEY", "SEARCH_RESULTS_FEATURES_DATA_KEY", "MARKETPLACE_TAB_SEARCH_PERFORMED", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "INSTALLED_TAB_SEARCH_PERFORMED", "SEARCH_RESET", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "performMarketplaceSearch", "", "project", "Lcom/intellij/openapi/project/Project;", "query", "Lcom/intellij/ide/plugins/newui/SearchQueryParser$Marketplace;", "results", "", "Lcom/intellij/ide/plugins/newui/PluginUiModel;", "searchIndex", "sessionId", "pluginToScore", "", "", "performInstalledTabSearch", "Lcom/intellij/ide/plugins/newui/SearchQueryParser$Installed;", "searchReset", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class PluginManagerMPCollector
extends PluginManagerFUSCollector {
    @NotNull
    private final ObjectEventField USER_QUERY_FEATURES_DATA_KEY;
    @NotNull
    private final ObjectEventField MARKETPLACE_SEARCH_FEATURES_DATA_KEY;
    @NotNull
    private final ObjectEventField LOCAL_SEARCH_FEATURES_DATA_KEY;
    @NotNull
    private final ObjectEventField SEARCH_RESULTS_FEATURES_DATA_KEY;
    @NotNull
    private final VarargEventId MARKETPLACE_TAB_SEARCH_PERFORMED;
    @NotNull
    private final VarargEventId INSTALLED_TAB_SEARCH_PERFORMED;
    @NotNull
    private final EventId1<Integer> SEARCH_RESET;

    public PluginManagerMPCollector() {
        EventField<?>[] eventFieldArray = PluginManagerUserQueryFeatureProvider.INSTANCE.getFeaturesDefinition();
        this.USER_QUERY_FEATURES_DATA_KEY = new ObjectEventField("userQueryFeatures", Arrays.copyOf(eventFieldArray, eventFieldArray.length));
        eventFieldArray = PluginManagerMarketplaceSearchFeatureProvider.INSTANCE.getFeaturesDefinition();
        this.MARKETPLACE_SEARCH_FEATURES_DATA_KEY = new ObjectEventField("marketplaceSearchFeatures", Arrays.copyOf(eventFieldArray, eventFieldArray.length));
        eventFieldArray = PluginManagerLocalSearchFeatureProvider.INSTANCE.getFeaturesDefinition();
        this.LOCAL_SEARCH_FEATURES_DATA_KEY = new ObjectEventField("localSearchFeatures", Arrays.copyOf(eventFieldArray, eventFieldArray.length));
        eventFieldArray = PluginManagerSearchResultsFeatureProvider.INSTANCE.getFeaturesDefinition();
        this.SEARCH_RESULTS_FEATURES_DATA_KEY = new ObjectEventField("resultsFeatures", Arrays.copyOf(eventFieldArray, eventFieldArray.length));
        eventFieldArray = new EventField[]{this.USER_QUERY_FEATURES_DATA_KEY, this.MARKETPLACE_SEARCH_FEATURES_DATA_KEY, this.SEARCH_RESULTS_FEATURES_DATA_KEY, this.getPLUGIN_MANAGER_SESSION_ID(), this.getPLUGIN_MANAGER_SEARCH_INDEX()};
        this.MARKETPLACE_TAB_SEARCH_PERFORMED = this.getGroup().registerVarargEvent("marketplace.tab.search", eventFieldArray);
        eventFieldArray = new EventField[]{this.USER_QUERY_FEATURES_DATA_KEY, this.LOCAL_SEARCH_FEATURES_DATA_KEY, this.SEARCH_RESULTS_FEATURES_DATA_KEY, this.getPLUGIN_MANAGER_SESSION_ID(), this.getPLUGIN_MANAGER_SEARCH_INDEX()};
        this.INSTALLED_TAB_SEARCH_PERFORMED = this.getGroup().registerVarargEvent("installed.tab.search", eventFieldArray);
        this.SEARCH_RESET = this.getGroup().registerEvent("search.reset", (EventField)this.getPLUGIN_MANAGER_SESSION_ID());
    }

    @Override
    @NotNull
    public EventLogGroup getGroup() {
        return PluginManagerMPCollectorKt.access$getEVENT_GROUP$p();
    }

    public final void performMarketplaceSearch(@Nullable Project project2, @NotNull SearchQueryParser.Marketplace query, @NotNull List<? extends PluginUiModel> results, int searchIndex, int sessionId, @Nullable Map<PluginUiModel, Double> pluginToScore) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter(results, (String)"results");
            VarargEventId varargEventId = (VarargEventId)this.getIfInitializedOrNull((BaseEventId)this.MARKETPLACE_TAB_SEARCH_PERFORMED);
            if (varargEventId == null) break block0;
            varargEventId.log(project2, arg_0 -> PluginManagerMPCollector.performMarketplaceSearch$lambda$0(this, query, results, pluginToScore, sessionId, searchIndex, arg_0));
        }
    }

    public static /* synthetic */ void performMarketplaceSearch$default(PluginManagerMPCollector pluginManagerMPCollector, Project project2, SearchQueryParser.Marketplace marketplace, List list2, int n, int n2, Map map2, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            map2 = null;
        }
        pluginManagerMPCollector.performMarketplaceSearch(project2, marketplace, list2, n, n2, map2);
    }

    public final void performInstalledTabSearch(@Nullable Project project2, @NotNull SearchQueryParser.Installed query, @NotNull List<? extends PluginUiModel> results, int searchIndex, int sessionId, @Nullable Map<PluginUiModel, Double> pluginToScore) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            Intrinsics.checkNotNullParameter(results, (String)"results");
            VarargEventId varargEventId = (VarargEventId)this.getIfInitializedOrNull((BaseEventId)this.INSTALLED_TAB_SEARCH_PERFORMED);
            if (varargEventId == null) break block0;
            varargEventId.log(project2, arg_0 -> PluginManagerMPCollector.performInstalledTabSearch$lambda$0(this, query, results, pluginToScore, sessionId, searchIndex, arg_0));
        }
    }

    public static /* synthetic */ void performInstalledTabSearch$default(PluginManagerMPCollector pluginManagerMPCollector, Project project2, SearchQueryParser.Installed installed, List list2, int n, int n2, Map map2, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            map2 = null;
        }
        pluginManagerMPCollector.performInstalledTabSearch(project2, installed, list2, n, n2, map2);
    }

    public final void searchReset(int sessionId) {
        this.SEARCH_RESET.log((Object)sessionId);
    }

    private static final Unit performMarketplaceSearch$lambda$0(PluginManagerMPCollector this$0, SearchQueryParser.Marketplace $query, List $results, Map $pluginToScore, int $sessionId, int $searchIndex, EventDataCollector $this$log) {
        Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
        $this$log.add((Object)this$0.USER_QUERY_FEATURES_DATA_KEY.with((Object)new ObjectEventData(PluginManagerUserQueryFeatureProvider.INSTANCE.getSearchStateFeatures($query.searchQuery))));
        $this$log.add((Object)this$0.MARKETPLACE_SEARCH_FEATURES_DATA_KEY.with((Object)new ObjectEventData(PluginManagerMarketplaceSearchFeatureProvider.INSTANCE.getSearchStateFeatures($query))));
        $this$log.add((Object)this$0.SEARCH_RESULTS_FEATURES_DATA_KEY.with((Object)new ObjectEventData(PluginManagerSearchResultsFeatureProvider.INSTANCE.getSearchStateFeatures($query.searchQuery, $results, $pluginToScore))));
        $this$log.add((Object)this$0.getPLUGIN_MANAGER_SESSION_ID().with((Object)$sessionId));
        $this$log.add((Object)this$0.getPLUGIN_MANAGER_SEARCH_INDEX().with((Object)$searchIndex));
        return Unit.INSTANCE;
    }

    private static final Unit performInstalledTabSearch$lambda$0(PluginManagerMPCollector this$0, SearchQueryParser.Installed $query, List $results, Map $pluginToScore, int $sessionId, int $searchIndex, EventDataCollector $this$log) {
        Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
        $this$log.add((Object)this$0.USER_QUERY_FEATURES_DATA_KEY.with((Object)new ObjectEventData(PluginManagerUserQueryFeatureProvider.INSTANCE.getSearchStateFeatures($query.searchQuery))));
        $this$log.add((Object)this$0.LOCAL_SEARCH_FEATURES_DATA_KEY.with((Object)new ObjectEventData((List)PluginManagerLocalSearchFeatureProvider.INSTANCE.getSearchStateFeatures($query))));
        $this$log.add((Object)this$0.SEARCH_RESULTS_FEATURES_DATA_KEY.with((Object)new ObjectEventData(PluginManagerSearchResultsFeatureProvider.INSTANCE.getSearchStateFeatures($query.searchQuery, $results, $pluginToScore))));
        $this$log.add((Object)this$0.getPLUGIN_MANAGER_SESSION_ID().with((Object)$sessionId));
        $this$log.add((Object)this$0.getPLUGIN_MANAGER_SEARCH_INDEX().with((Object)$searchIndex));
        return Unit.INSTANCE;
    }
}

