/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.ColorButton;
import com.intellij.ide.plugins.newui.PluginInstallButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.JBColor;
import java.awt.Color;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class InstallButton
extends ColorButton
implements PluginInstallButton {
    private static final Color GreenColor = new JBColor(6134599, 2849616);
    private static final Color FillForegroundColor = JBColor.namedColor((String)"Plugins.Button.installFillForeground", (Color)WhiteForeground);
    private static final Color FillBackgroundColor = JBColor.namedColor((String)"Plugins.Button.installFillBackground", (Color)GreenColor);
    private static final Color ForegroundColor = JBColor.namedColor((String)"Plugins.Button.installForeground", (Color)GreenColor);
    private static final Color BackgroundColor = JBColor.namedColor((String)"Plugins.Button.installBackground", (Color)PluginManagerConfigurable.MAIN_BG_COLOR);
    private static final Color FocusedBackground = JBColor.namedColor((String)"Plugins.Button.installFocusedBackground", (Color)new Color(14808794));
    private static final Color BorderColor = JBColor.namedColor((String)"Plugins.Button.installBorderColor", (Color)GreenColor);
    private final boolean myIsUpgradeRequired;

    public InstallButton(boolean fill) {
        this(fill, false);
    }

    public InstallButton(boolean fill, boolean isUpgradeRequired) {
        this.myIsUpgradeRequired = isUpgradeRequired;
        this.setButtonColors(fill);
    }

    public InstallButton(@NlsContexts.Button String text2, boolean fill) {
        this(fill, false);
        this.setText(text2);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getParent() != null) {
            this.setEnabled(this.isEnabled(), this.getText());
        }
    }

    @Override
    public void setButtonColors(boolean fill) {
        if (fill) {
            this.setTextColor(FillForegroundColor);
            this.setBgColor(FillBackgroundColor);
        } else {
            this.setTextColor(ForegroundColor);
            this.setFocusedTextColor(ForegroundColor);
            this.setBgColor(BackgroundColor);
        }
        this.setFocusedBgColor(FocusedBackground);
        this.setBorderColor(BorderColor);
        this.setFocusedBorderColor(BorderColor);
        this.setTextAndSize();
    }

    protected void setTextAndSize() {
        this.setText(IdeBundle.message((String)"action.AnActionButton.text.install", (Object[])new Object[0]));
        this.setEnabled(!this.myIsUpgradeRequired);
        InstallButton.setWidth72(this);
    }

    @Override
    public void setEnabled(boolean enabled2, @Nullable @Nls String statusText) {
        super.setEnabled(enabled2);
        if (enabled2) {
            this.setTextAndSize();
        } else {
            this.setText(statusText);
            InstallButton.setWidth(this, 80);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        InstallButton installButton = this;
        if (installButton == null) {
            InstallButton.$$$reportNull$$$0(0);
        }
        return installButton;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/newui/InstallButton", "getComponent"));
    }
}

