/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.TabHeaderListener;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.TabbedPaneUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TabbedPaneHeaderComponent
extends JPanel
implements UiDataProvider {
    private final JBValue myHeight;
    private final JBValue myGap;
    private final JBTabbedPane myTabbedPane;
    private final TabHeaderListener myListener;

    public TabbedPaneHeaderComponent(@NotNull DefaultActionGroup actions, @NotNull TabHeaderListener listener2) {
        if (actions == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(1);
        }
        this.myHeight = new JBValue.Float(30.0f);
        this.myGap = new JBValue.Float(10.0f);
        this.myTabbedPane = new JBTabbedPane(){

            public void setUI(TabbedPaneUI ui) {
                boolean value = UIManager.getBoolean("TabbedPane.contentOpaque");
                UIManager.getDefaults().put("TabbedPane.contentOpaque", Boolean.FALSE);
                try {
                    super.setUI(ui);
                }
                finally {
                    UIManager.getDefaults().put("TabbedPane.contentOpaque", (Object)value);
                }
            }
        };
        this.myListener = listener2;
        this.setLayout((LayoutManager)new AbstractLayoutManager(){

            public Dimension preferredLayoutSize(Container parent) {
                assert (parent.getComponentCount() == 2);
                int width = parent.getComponent((int)0).getPreferredSize().width * 2 + TabbedPaneHeaderComponent.this.myGap.get() + parent.getComponent((int)1).getPreferredSize().width;
                return new Dimension(width, TabbedPaneHeaderComponent.this.myHeight.get());
            }

            public void layoutContainer(Container parent) {
                assert (parent.getComponentCount() == 2);
                Component tabbedPane = parent.getComponent(0);
                Component toolbar2 = parent.getComponent(1);
                Dimension toolbarSize = toolbar2.getPreferredSize();
                int width = tabbedPane.getPreferredSize().width * 2;
                int height = parent.getHeight();
                int gap = TabbedPaneHeaderComponent.this.myGap.get();
                int x = (parent.getWidth() - width - gap - toolbarSize.width) / 2 - width / 4;
                int y = height > 0 ? height - JBUI.CurrentTheme.TabbedPane.TAB_HEIGHT.get() : 0;
                int toolbarY = (y + height - toolbarSize.height) / 2;
                tabbedPane.setBounds(x, y, width, height - y);
                toolbar2.setBounds(x + width + gap, toolbarY - JBUI.scale((int)1), toolbarSize.width, height);
            }
        });
        this.setOpaque(false);
        this.myTabbedPane.setOpaque(false);
        this.add((Component)this.myTabbedPane);
        this.add((Component)TabbedPaneHeaderComponent.createToolbar(actions, IdeBundle.message((String)"plugin.manager.tooltip", (Object[])new Object[0]), AllIcons.General.GearPlain), "East");
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(2);
        }
    }

    @NotNull
    static JComponent createToolbar(final @NotNull DefaultActionGroup actions, @Nullable @NlsActions.ActionText String tooltip, @NotNull Icon icon2) {
        if (actions == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(3);
        }
        if (icon2 == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(4);
        }
        DefaultActionGroup toolbarActionGroup = new DefaultActionGroup();
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("PluginsHeaderToolbar", (ActionGroup)toolbarActionGroup, true);
        toolbar2.setTargetComponent(toolbar2.getComponent());
        toolbar2.setReservePlaceAutoPopupIcon(false);
        toolbar2.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        final JComponent toolbarComponent = toolbar2.getComponent();
        toolbarActionGroup.add((AnAction)new DumbAwareAction(tooltip, tooltip, icon2){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                final ListPopup actionGroupPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actions, e.getDataContext(), true, null, Integer.MAX_VALUE);
                HelpTooltip.setMasterPopup((Component)e.getInputEvent().getComponent(), (JBPopup)actionGroupPopup);
                final Component component2 = toolbarComponent.getComponent(0);
                final Container dialogComponent = ((JComponent)component2).getRootPane().getParent();
                if (dialogComponent != null) {
                    final ComponentAdapter listener2 = new ComponentAdapter(){

                        @Override
                        public void componentResized(ComponentEvent e) {
                            this.movePopup();
                        }

                        @Override
                        public void componentMoved(ComponentEvent e) {
                            this.movePopup();
                        }

                        private void movePopup() {
                            if (actionGroupPopup.isVisible()) {
                                actionGroupPopup.setLocation(new RelativePoint(component2, this.getPopupPoint()).getScreenPoint());
                                actionGroupPopup.pack(true, true);
                            }
                        }
                    };
                    dialogComponent.addComponentListener(listener2);
                    actionGroupPopup.addListener(new JBPopupListener(){

                        public void onClosed(@NotNull LightweightWindowEvent event) {
                            if (event == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            dialogComponent.removeComponentListener(listener2);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/newui/TabbedPaneHeaderComponent$3$2", "onClosed"));
                        }
                    });
                }
                actionGroupPopup.show(new RelativePoint(component2, this.getPopupPoint()));
            }

            private Point getPopupPoint() {
                int dH = UIUtil.isUnderWin10LookAndFeel() ? JBUIScale.scale((int)1) : 0;
                return new Point(JBUIScale.scale((int)2), toolbarComponent.getComponent(0).getHeight() - dH);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/newui/TabbedPaneHeaderComponent$3", "actionPerformed"));
            }
        });
        toolbarComponent.setBorder((Border)JBUI.Borders.empty());
        JComponent jComponent = toolbarComponent;
        if (jComponent == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, 0, width, height + y);
    }

    public void setListener() {
        this.myTabbedPane.addChangeListener(e -> this.myListener.selectionChanged(this.myTabbedPane.getSelectedIndex()));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getParent() != null) {
            this.update();
        }
    }

    public void update() {
        this.setPreferredSize(null);
        this.doLayout();
        this.revalidate();
        this.myTabbedPane.doLayout();
        this.myTabbedPane.revalidate();
        this.repaint();
    }

    public void addTab(@NotNull @Nls String title2, @Nullable Icon icon2) {
        if (title2 == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(6);
        }
        this.myTabbedPane.addTab(title2, icon2, (Component)new JLabel());
        if (icon2 != null) {
            Component tab = this.myTabbedPane.getTabComponentAt(this.myTabbedPane.getTabCount() - 1);
            ((JLabel)tab).setHorizontalTextPosition(2);
        }
    }

    public void setTabTooltip(int index, @Nullable @Nls String tooltip) {
        this.myTabbedPane.setToolTipTextAt(index, tooltip);
    }

    public int getSelectionTab() {
        return this.myTabbedPane.getSelectedIndex();
    }

    public void setSelection(int index) {
        this.myTabbedPane.setSelectedIndex(index);
    }

    public void setSelectionWithEvents(int index) {
        this.setSelection(index);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Runnable action2 = () -> this.setSelectionWithEvents(this.myTabbedPane.getSelectedIndex() == 0 ? 1 : 0);
        this.addTabSelectionAction("NextTab", action2);
        this.addTabSelectionAction("PreviousTab", action2);
    }

    private void addTabSelectionAction(@NotNull String actionId, @NotNull Runnable callback) {
        if (actionId == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(7);
        }
        if (callback == null) {
            TabbedPaneHeaderComponent.$$$reportNull$$$0(8);
        }
        EventHandler.addGlobalAction(this, actionId, () -> {
            if (this.myTabbedPane.getTabCount() > 0) {
                callback.run();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/TabbedPaneHeaderComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/TabbedPaneHeaderComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createToolbar";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTab";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTabSelectionAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

