/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.troubleshooting;

import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.troubleshooting.GeneralTroubleInfoCollector;
import com.intellij.util.system.CpuArch;
import com.jetbrains.JBR;
import java.awt.Toolkit;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class AboutTroubleInfoCollector
implements GeneralTroubleInfoCollector {
    AboutTroubleInfoCollector() {
    }

    @Override
    @NotNull
    public String getTitle() {
        return "About";
    }

    @Override
    @NotNull
    public String collectInfo(@NotNull Project project2) {
        if (project2 == null) {
            AboutTroubleInfoCollector.$$$reportNull$$$0(0);
        }
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        Calendar cal = appInfo.getBuildDate();
        Object output = "Build version: ";
        output = (String)output + appInfo.getFullApplicationName();
        String buildInfo = "Build: #" + String.valueOf(appInfo.getBuild());
        Object buildDate = "";
        if (appInfo.getBuild().isSnapshot()) {
            buildDate = new SimpleDateFormat("HH:mm, ").format(cal.getTime());
        }
        buildDate = (String)buildDate + DateFormat.getDateInstance(1, Locale.US).format(cal.getTime());
        output = (String)output + " " + buildInfo + " " + (String)buildDate;
        output = (String)output + "\n";
        if (LafManager.getInstance().getCurrentUIThemeLookAndFeel() != null) {
            output = (String)output + "Theme: ";
            output = (String)output + LafManager.getInstance().getCurrentUIThemeLookAndFeel().getName();
            output = (String)output + "\n";
        }
        output = (String)output + "JRE: ";
        output = (String)output + System.getProperty("java.runtime.version", System.getProperty("java.version", "unknown"));
        output = (String)output + ", " + System.getProperty("java.vendor", "unknown");
        output = (String)output + "\n";
        output = (String)output + "JVM: ";
        output = (String)output + System.getProperty("java.vm.version", "unknown");
        output = (String)output + ", " + System.getProperty("java.vm.name", "unknown");
        output = (String)output + ", " + System.getProperty("java.vm.vendor", "unknown");
        output = (String)output + "\n";
        output = (String)output + "Operating System: ";
        output = (String)output + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION;
        output = (String)output + " (" + SystemInfo.OS_ARCH + (CpuArch.isEmulated() ? ", emulated" : "") + ")";
        output = (String)output + "\n";
        output = (String)output + "Toolkit: ";
        output = (String)output + Toolkit.getDefaultToolkit().getClass().getName();
        output = (String)output + "\n";
        if (JBR.isVulkanSupported()) {
            output = (String)output + "Vulkan Rendering is ON:\n";
            output = (String)output + "  Presentation is " + (JBR.getVulkan().isPresentationEnabled() ? "ON" : "OFF") + "\n";
            output = (String)output + Stream.of(JBR.getVulkan().getDevices()).map(device -> "  " + device.getName() + " (" + device.getTypeString() + "), caps=0x" + Integer.toHexString(device.getCapabilities()) + "\n").collect(Collectors.joining());
        }
        output = (String)output + "idea.config.path=" + AboutTroubleInfoCollector.logPath(PathManager.getConfigPath()) + "\n";
        output = (String)output + "idea.system.path=" + AboutTroubleInfoCollector.logPath(PathManager.getSystemPath()) + "\n";
        output = (String)output + "idea.plugins.path=" + AboutTroubleInfoCollector.logPath(PathManager.getPluginsPath()) + "\n";
        output = (String)output + "idea.log.path=" + AboutTroubleInfoCollector.logPath(PathManager.getLogPath()) + "\n";
        output = (String)output + AboutTroubleInfoCollector.logEnvVar("_JAVA_OPTIONS");
        output = (String)output + AboutTroubleInfoCollector.logEnvVar("JDK_JAVA_OPTIONS");
        Object object = output = (String)output + AboutTroubleInfoCollector.logEnvVar("JAVA_TOOL_OPTIONS");
        if (object == null) {
            AboutTroubleInfoCollector.$$$reportNull$$$0(1);
        }
        return object;
    }

    private static String logPath(String path) {
        try {
            Path configured = Paths.get(path, new String[0]);
            Path real = configured.toRealPath(new LinkOption[0]);
            if (!configured.equals(real)) {
                return path + " -> " + String.valueOf(real);
            }
        }
        catch (IOException | InvalidPathException exception) {
            // empty catch block
        }
        return path;
    }

    private static String logEnvVar(String var) {
        String value = System.getenv(var);
        return value != null ? var + "=" + value + "\n" : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/troubleshooting/AboutTroubleInfoCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/troubleshooting/AboutTroubleInfoCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

