/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.PaletteKeys;
import com.intellij.ui.svg.SvgAttributePatcher;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fH\u0016JE\u0010\r\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/ui/NewThemeCheckboxPatcher;", "Lcom/intellij/ui/svg/SvgAttributePatcher;", "palette", "", "", "alphas", "", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "patchColors", "", "attributes", "", "patchAttributes", "attributeName", "opacityAttributeName", "newColor", "newOpacity", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)V", "intellij.platform.ide.impl"})
final class NewThemeCheckboxPatcher
implements SvgAttributePatcher {
    @NotNull
    private final Map<String, String> palette;
    @NotNull
    private final Map<String, Integer> alphas;

    public NewThemeCheckboxPatcher(@NotNull Map<String, String> palette, @NotNull Map<String, Integer> alphas) {
        Intrinsics.checkNotNullParameter(palette, (String)"palette");
        Intrinsics.checkNotNullParameter(alphas, (String)"alphas");
        this.palette = palette;
        this.alphas = alphas;
    }

    public void patchColors(@NotNull Map<String, String> attributes) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        String string = attributes.get("id");
        if (string == null) {
            return;
        }
        PaletteKeys paletteKeys = new PaletteKeys(string);
        this.patchAttributes(attributes, "fill", "fill-opacity", this.palette.get(paletteKeys.getFillKey()), this.alphas.get(paletteKeys.getFillKey()));
        this.patchAttributes(attributes, "stroke", "stroke-opacity", this.palette.get(paletteKeys.getStrokeKey()), this.alphas.get(paletteKeys.getStrokeKey()));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void patchAttributes(Map<String, String> attributes, String attributeName, String opacityAttributeName, String newColor, Integer newOpacity) {
        if (!attributes.containsKey(attributeName)) return;
        if (newColor == null) {
            return;
        }
        attributes.put(attributeName, newColor);
        if (newOpacity != null) {
            int n = 255;
            if (newOpacity != n) {
                attributes.put(opacityAttributeName, String.valueOf((float)newOpacity.intValue() / 255.0f));
                return;
            }
        }
        attributes.remove(opacityAttributeName);
    }
}

