/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ExperimentalFeatureBooleanOptionDescriptor;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.ide.ui.RegistryTextOptionDescriptor;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryManagerImpl;
import com.intellij.openapi.util.registry.RegistryValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class RegistryOptionsTopHitProvider
implements OptionsSearchTopHitProvider.ApplicationLevelProvider {
    RegistryOptionsTopHitProvider() {
        if (!ApplicationManager.getApplication().isInternal()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    @Override
    @NotNull
    public Collection<OptionDescription> getOptions() {
        ArrayList<OptionDescription> result2 = new ArrayList<OptionDescription>();
        for (RegistryValue value : ((RegistryManagerImpl)RegistryManager.getInstance()).getAll()) {
            if (value.isBoolean()) {
                String key = value.getKey();
                RegistryBooleanOptionDescriptor optionDescriptor = new RegistryBooleanOptionDescriptor(key, key);
                if (value.isChangedFromDefault()) {
                    result2.add(0, (OptionDescription)optionDescriptor);
                    continue;
                }
                result2.add((OptionDescription)optionDescriptor);
                continue;
            }
            result2.add(new RegistryTextOptionDescriptor(value));
        }
        List experimentalFeatureList = Experiments.EP_NAME.getExtensionList();
        if (!experimentalFeatureList.isEmpty()) {
            Experiments experiments = Experiments.getInstance();
            for (ExperimentalFeature feature : experimentalFeatureList) {
                @NlsSafe String optionName = feature.id;
                ExperimentalFeatureBooleanOptionDescriptor descriptor = new ExperimentalFeatureBooleanOptionDescriptor(optionName, feature.id);
                if (experiments.isChanged(feature.id)) {
                    result2.add(0, (OptionDescription)descriptor);
                    continue;
                }
                result2.add((OptionDescription)descriptor);
            }
        }
        ArrayList<OptionDescription> arrayList = result2;
        if (arrayList == null) {
            RegistryOptionsTopHitProvider.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getId() {
        return "registry";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/RegistryOptionsTopHitProvider", "getOptions"));
    }
}

