/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.Icon;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;

public abstract class RoundedActionButton
extends JButton {
    private int myHGap = JBUIScale.scale((int)4);
    private final int myTopBottomBorder;
    private final int myLeftRightBorder;
    private int myArc = JBUIScale.scale((int)7);

    public RoundedActionButton(int topBottomBorder, int leftRightBorder) {
        this.setOpaque(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.myTopBottomBorder = JBUIScale.scale((int)topBottomBorder);
        this.myLeftRightBorder = JBUIScale.scale((int)leftRightBorder);
    }

    @Override
    public Dimension getPreferredSize() {
        Icon icon2 = this.getIcon();
        int iconSize = icon2 == null ? 0 : icon2.getIconWidth();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int textWidth = metrics.stringWidth(this.getText());
        int width = this.myLeftRightBorder + iconSize + this.myHGap + textWidth + this.myLeftRightBorder;
        int height = this.myTopBottomBorder + Math.max(iconSize, metrics.getHeight()) + this.myTopBottomBorder;
        return new Dimension(width, height);
    }

    @Override
    public void paint(Graphics g2) {
        Icon icon2 = this.getIcon();
        int iconSize = icon2 == null ? 0 : icon2.getIconWidth();
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        int w = g.getClipBounds().width;
        int h = g.getClipBounds().height;
        int borderArc = this.myArc;
        int border = JBUIScale.scale((int)1);
        int buttonArc = borderArc - border;
        g.setPaint(this.getBackgroundBorderPaint());
        g.fillRoundRect(0, 0, w, h, borderArc, borderArc);
        g.setPaint(this.getBackgroundPaint());
        g.fillRoundRect(border, border, w - 2 * border, h - 2 * border, buttonArc, buttonArc);
        g.setColor(this.getButtonForeground());
        g.drawString(this.getText(), this.myLeftRightBorder + iconSize + this.myHGap, this.getBaseline(w, h));
        if (icon2 != null) {
            icon2.paintIcon(this, g, this.myLeftRightBorder, (this.getHeight() - icon2.getIconHeight()) / 2);
        }
        config.restore();
    }

    public int getArc() {
        return this.myArc;
    }

    public void setArc(int arc) {
        this.myArc = arc;
    }

    public int getHGap() {
        return this.myHGap;
    }

    public void setHGap(int hGap) {
        this.myHGap = hGap;
    }

    @NotNull
    protected abstract Paint getBackgroundBorderPaint();

    @NotNull
    protected abstract Paint getBackgroundPaint();

    @NotNull
    protected abstract Color getButtonForeground();
}

