/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.UIThemeBean;
import com.intellij.ide.ui.UIThemeKt;
import com.intellij.ide.ui.UiThemePaletteCheckBoxScope;
import com.intellij.ide.ui.UiThemePaletteScope;
import com.intellij.ide.ui.UiThemePaletteScopeImpl;
import com.intellij.ide.ui.UiThemeParserKt;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.svg.SvgAttributePatcher;
import com.intellij.util.InsecureHashBuilder;
import com.intellij.util.SVGLoader;
import java.awt.Color;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/ui/UiThemePaletteScopeManager;", "", "theme", "Lcom/intellij/ide/ui/UIThemeBean;", "<init>", "(Lcom/intellij/ide/ui/UIThemeBean;)V", "isBasedOnExperimentalTheme", "", "ui", "Lcom/intellij/ide/ui/UiThemePaletteScopeImpl;", "checkBoxes", "trees", "checkBoxesExperimentalThemes", "Lcom/intellij/ide/ui/UiThemePaletteCheckBoxScope;", "configureIcons", "Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;", "iconMap", "", "", "computeDigest", "Lcom/intellij/util/InsecureHashBuilder;", "builder", "getScope", "Lcom/intellij/ide/ui/UiThemePaletteScope;", "colorKey", "getScopeByPath", "path", "intellij.platform.ide.impl"})
public final class UiThemePaletteScopeManager {
    private final boolean isBasedOnExperimentalTheme;
    @NotNull
    private final UiThemePaletteScopeImpl ui;
    @NotNull
    private final UiThemePaletteScopeImpl checkBoxes;
    @NotNull
    private final UiThemePaletteScopeImpl trees;
    @NotNull
    private final UiThemePaletteCheckBoxScope checkBoxesExperimentalThemes;

    public UiThemePaletteScopeManager(@NotNull UIThemeBean theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.isBasedOnExperimentalTheme = UITheme.Companion.isBasedOnExperimentalTheme$intellij_platform_ide_impl(theme);
        this.ui = new UiThemePaletteScopeImpl();
        this.checkBoxes = new UiThemePaletteScopeImpl();
        this.trees = new UiThemePaletteScopeImpl();
        this.checkBoxesExperimentalThemes = new UiThemePaletteCheckBoxScope(theme);
    }

    @Nullable
    public final SVGLoader.SvgElementColorPatcherProvider configureIcons(@NotNull UIThemeBean theme, @NotNull Map<String, ? extends Object> iconMap) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter(iconMap, (String)"iconMap");
        Object object = iconMap.get("ColorPalette");
        Map map2 = object instanceof Map ? (Map)object : null;
        if (map2 == null) {
            return null;
        }
        Map palette = map2;
        for (String colorKey : palette.keySet()) {
            UiThemePaletteScope scope;
            Object v = palette.get(colorKey);
            if (v instanceof String) {
                v = theme.colorMap.map.get(v);
            }
            if ((scope = this.getScope(colorKey)) instanceof UiThemePaletteScopeImpl) {
                Color colorFromKey;
                String key = UIThemeKt.toColorString(colorKey, theme.dark);
                if (v == null) {
                    v = UiThemeParserKt.parseColorOrNull(key, null);
                }
                if ((colorFromKey = UiThemeParserKt.parseColorOrNull(key, null)) == null || !(v instanceof Color)) continue;
                int fillTransparency = ((Color)v).getAlpha();
                String colorHex = "#" + ColorUtil.toHex((Color)((Color)v), (boolean)false);
                ((UiThemePaletteScopeImpl)scope).getNewPalette().put(key, colorHex);
                ((UiThemePaletteScopeImpl)scope).getAlphas().put(colorHex, fillTransparency);
                continue;
            }
            if (scope instanceof UiThemePaletteCheckBoxScope) {
                ((UiThemePaletteCheckBoxScope)scope).registerPalette(colorKey, v);
                continue;
            }
            if (scope == null) continue;
            throw new NoWhenBranchMatchedException();
        }
        long[] digest = this.computeDigest(new InsecureHashBuilder()).build();
        return new SVGLoader.SvgElementColorPatcherProvider(digest, this){
            final /* synthetic */ long[] $digest;
            final /* synthetic */ UiThemePaletteScopeManager this$0;
            {
                this.$digest = $digest;
                this.this$0 = $receiver;
            }

            public long[] digest() {
                return this.$digest;
            }

            public SvgAttributePatcher attributeForPath(String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                UiThemePaletteScope uiThemePaletteScope = this.this$0.getScopeByPath(path);
                return uiThemePaletteScope != null ? uiThemePaletteScope.getSvgColorIconPatcher() : null;
            }
        };
    }

    @NotNull
    public final InsecureHashBuilder computeDigest(@NotNull InsecureHashBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.putLong(453973057740471735L).putBoolean(this.isBasedOnExperimentalTheme);
        this.ui.updateHash(builder);
        this.checkBoxes.updateHash(builder);
        this.trees.updateHash(builder);
        this.checkBoxesExperimentalThemes.updateHash(builder);
        return builder;
    }

    private final UiThemePaletteScope getScope(String colorKey) {
        return StringsKt.startsWith$default((String)colorKey, (String)"Checkbox.", (boolean)false, (int)2, null) ? (this.isBasedOnExperimentalTheme ? (UiThemePaletteScope)this.checkBoxesExperimentalThemes : (UiThemePaletteScope)this.checkBoxes) : (StringsKt.startsWith$default((String)colorKey, (String)"Tree.iconColor", (boolean)false, (int)2, null) ? (UiThemePaletteScope)this.trees : (StringsKt.startsWith$default((String)colorKey, (String)"Objects.", (boolean)false, (int)2, null) ? (UiThemePaletteScope)this.ui : (StringsKt.startsWith$default((String)colorKey, (String)"Actions.", (boolean)false, (int)2, null) ? (UiThemePaletteScope)this.ui : (StringsKt.startsWith$default((CharSequence)colorKey, (char)'#', (boolean)false, (int)2, null) ? (UiThemePaletteScope)this.ui : (UiThemePaletteScope)this.ui))));
    }

    @Nullable
    public final UiThemePaletteScope getScopeByPath(@Nullable String path) {
        if (path != null) {
            if (this.isBasedOnExperimentalTheme && StringsKt.contains$default((CharSequence)path, (CharSequence)"themes/expUI/icons/dark/", (boolean)false, (int)2, null)) {
                return this.checkBoxesExperimentalThemes;
            }
            if (StringsKt.contains$default((CharSequence)path, (CharSequence)"com/intellij/ide/ui/laf/icons/", (boolean)false, (int)2, null)) {
                String string = path.substring(StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String file2 = string;
                return Intrinsics.areEqual((Object)file2, (Object)"treeCollapsed.svg") || Intrinsics.areEqual((Object)file2, (Object)"treeExpanded.svg") ? (UiThemePaletteScope)this.trees : (StringsKt.startsWith$default((String)file2, (String)"check", (boolean)false, (int)2, null) ? (UiThemePaletteScope)this.checkBoxes : (StringsKt.startsWith$default((String)file2, (String)"radio", (boolean)false, (int)2, null) ? (UiThemePaletteScope)this.checkBoxes : null));
            }
        }
        return this.ui;
    }
}

