/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.openapi.util.SystemInfo;
import java.awt.Component;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001bB\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u0014*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/ui/laf/MouseDragSelectionEventHandler;", "", "mouseDraggedOriginal", "Lkotlin/Function1;", "Ljava/awt/event/MouseEvent;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "isNativeSelectionEnabled", "", "()Z", "setNativeSelectionEnabled", "(Z)V", "mouseDragged", "e", "dragSelectionMode", "Lcom/intellij/ide/ui/laf/MouseDragSelectionEventHandler$DragSelectionMode;", "mouseDraggedWindows", "mouseDraggedUnix", "sourceWidth", "", "getSourceWidth", "(Ljava/awt/event/MouseEvent;)Ljava/lang/Integer;", "sourceHeight", "getSourceHeight", "x", "y", "DragSelectionMode", "intellij.platform.ide.impl"})
public final class MouseDragSelectionEventHandler {
    @NotNull
    private final Function1<MouseEvent, Unit> mouseDraggedOriginal;
    private boolean isNativeSelectionEnabled;

    public MouseDragSelectionEventHandler(@NotNull Function1<? super MouseEvent, Unit> mouseDraggedOriginal) {
        Intrinsics.checkNotNullParameter(mouseDraggedOriginal, (String)"mouseDraggedOriginal");
        this.mouseDraggedOriginal = mouseDraggedOriginal;
    }

    public final boolean isNativeSelectionEnabled() {
        return this.isNativeSelectionEnabled;
    }

    public final void setNativeSelectionEnabled(boolean bl) {
        this.isNativeSelectionEnabled = bl;
    }

    public final void mouseDragged(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        switch (WhenMappings.$EnumSwitchMapping$0[this.dragSelectionMode().ordinal()]) {
            case 1: {
                this.mouseDraggedOriginal.invoke((Object)e);
                break;
            }
            case 2: {
                this.mouseDraggedWindows(e);
                break;
            }
            case 3: {
                this.mouseDraggedUnix(e);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final DragSelectionMode dragSelectionMode() {
        return !this.isNativeSelectionEnabled ? DragSelectionMode.ORIGINAL : (SystemInfo.isWindows ? DragSelectionMode.WINDOWS : DragSelectionMode.UNIX);
    }

    private final void mouseDraggedWindows(MouseEvent e) {
        Integer n = this.getSourceHeight(e);
        this.mouseDragged(e, e.getX(), n != null ? n / 2 : e.getY());
    }

    private final void mouseDraggedUnix(MouseEvent e) {
        Integer height = this.getSourceHeight(e);
        Integer width = this.getSourceWidth(e);
        if (height == null || width == null) {
            this.mouseDraggedOriginal.invoke((Object)e);
            return;
        }
        int normalizedY = height / 2;
        if (e.getY() < 0) {
            this.mouseDragged(e, -9999, normalizedY);
        } else if (e.getY() > height) {
            this.mouseDragged(e, width + 9999, normalizedY);
        } else {
            this.mouseDragged(e, e.getX(), e.getY());
        }
    }

    private final Integer getSourceWidth(MouseEvent $this$sourceWidth) {
        Object object = $this$sourceWidth.getSource();
        Component component2 = object instanceof Component ? (Component)object : null;
        return component2 != null ? Integer.valueOf(component2.getWidth()) : null;
    }

    private final Integer getSourceHeight(MouseEvent $this$sourceHeight) {
        Object object = $this$sourceHeight.getSource();
        Component component2 = object instanceof Component ? (Component)object : null;
        return component2 != null ? Integer.valueOf(component2.getHeight()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mouseDragged(MouseEvent e, int x, int y) {
        int originalX = e.getX();
        int originalY = e.getY();
        e.translatePoint(x - originalX, y - originalY);
        try {
            this.mouseDraggedOriginal.invoke((Object)e);
        }
        finally {
            e.translatePoint(originalX - x, originalY - y);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/ui/laf/MouseDragSelectionEventHandler$DragSelectionMode;", "", "<init>", "(Ljava/lang/String;I)V", "ORIGINAL", "WINDOWS", "UNIX", "intellij.platform.ide.impl"})
    private static final class DragSelectionMode
    extends Enum<DragSelectionMode> {
        public static final /* enum */ DragSelectionMode ORIGINAL = new DragSelectionMode();
        public static final /* enum */ DragSelectionMode WINDOWS = new DragSelectionMode();
        public static final /* enum */ DragSelectionMode UNIX = new DragSelectionMode();
        private static final /* synthetic */ DragSelectionMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DragSelectionMode[] values() {
            return (DragSelectionMode[])$VALUES.clone();
        }

        public static DragSelectionMode valueOf(String value) {
            return Enum.valueOf(DragSelectionMode.class, value);
        }

        @NotNull
        public static EnumEntries<DragSelectionMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = dragSelectionModeArray = new DragSelectionMode[]{DragSelectionMode.ORIGINAL, DragSelectionMode.WINDOWS, DragSelectionMode.UNIX};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DragSelectionMode.values().length];
            try {
                nArray[DragSelectionMode.ORIGINAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DragSelectionMode.WINDOWS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DragSelectionMode.UNIX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

