/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.LookAndFeelThemeAdapter;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.AbstractButtonLayout;
import com.intellij.ide.ui.laf.darcula.ui.DarculaRadioButtonBorder;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class DarculaRadioButtonUI
extends MetalRadioButtonUI {
    private static Icon defaultIconCache;
    private final PropertyChangeListener textChangedListener = e -> DarculaRadioButtonUI.updateTextPosition((AbstractButton)e.getSource());

    public static ComponentUI createUI(JComponent c) {
        return new DarculaRadioButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setIconTextGap(this.textIconGap(b));
        DarculaRadioButtonUI.updateTextPosition(b);
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener("text", this.textChangedListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton button2) {
        super.uninstallListeners(button2);
        button2.removePropertyChangeListener("text", this.textChangedListener);
    }

    protected int textIconGap(AbstractButton b) {
        Object gap = UIManager.get("RadioButton.iconTextGap");
        if (gap != null) {
            try {
                return JBUIScale.scale((int)Integer.parseInt(gap.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return JBUIScale.scale((int)4);
    }

    private static void updateTextPosition(AbstractButton b) {
        b.setVerticalTextPosition(DarculaUIUtil.isMultiLineHTML(b.getText()) ? 1 : 0);
    }

    @Override
    public void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        AbstractButton button2 = (AbstractButton)c;
        AbstractButtonLayout layout2 = this.createLayout(button2, button2.getSize());
        layout2.paint(g, this.getDisabledTextColor(), this.getMnemonicIndex(button2));
        this.paintFocus(button2, g, layout2.textRect);
        this.paintIcon(c, g, layout2.iconRect);
    }

    @ApiStatus.Internal
    @NotNull
    public Rectangle getTextRect(@NotNull JRadioButton b) {
        if (b == null) {
            DarculaRadioButtonUI.$$$reportNull$$$0(0);
        }
        Rectangle rectangle = this.createLayout((JComponent)b, (Dimension)b.getSize()).textRect;
        if (rectangle == null) {
            DarculaRadioButtonUI.$$$reportNull$$$0(1);
        }
        return rectangle;
    }

    protected boolean removeInsetsBeforeLayout(AbstractButton b) {
        return !(b.getBorder() instanceof DarculaRadioButtonBorder);
    }

    protected void paintIcon(JComponent c, Graphics2D g, Rectangle iconRect) {
        Icon icon2 = LafIconLookup.getIcon((String)"radio", (boolean)((AbstractButton)c).isSelected(), (boolean)c.hasFocus(), (boolean)c.isEnabled());
        icon2.paintIcon(c, g, iconRect.x, iconRect.y);
    }

    private void paintFocus(AbstractButton b, Graphics2D g, Rectangle textRect) {
        if (b.hasFocus() && b.isFocusPainted() && textRect.width > 0 && textRect.height > 0) {
            this.paintFocus(g, textRect, b.getSize());
        }
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        AbstractButtonLayout layout2 = this.createLayout(c, new Dimension(width, height));
        return layout2.getBaseline();
    }

    protected int getMnemonicIndex(AbstractButton b) {
        return LookAndFeelThemeAdapter.isAltPressed() ? b.getDisplayedMnemonicIndex() : -1;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButtonLayout layout2 = this.createLayout(c, new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        return layout2.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
    }

    @Override
    public Icon getDefaultIcon() {
        int iconSize = JBUI.getInt((String)"RadioButton.iconSize", (int)19);
        if (defaultIconCache == null || defaultIconCache.getIconWidth() != iconSize || defaultIconCache.getIconHeight() != iconSize) {
            defaultIconCache = ((EmptyIcon)JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)iconSize))).asUIResource();
        }
        return defaultIconCache;
    }

    @NotNull
    private AbstractButtonLayout createLayout(JComponent c, Dimension size2) {
        AbstractButton button2 = (AbstractButton)c;
        return new AbstractButtonLayout(button2, size2, this.removeInsetsBeforeLayout(button2), this.getDefaultIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/darcula/ui/DarculaRadioButtonUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/DarculaRadioButtonUI";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTextRect";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

