/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.jetbrains.annotations.NotNull;

public class DarculaTextAreaUI
extends BasicTextAreaUI {
    private RoundedBorderSupportHandler helper;

    public static ComponentUI createUI(JComponent c) {
        return new DarculaTextAreaUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.helper = new RoundedBorderSupportHandler(this.getComponent());
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.helper != null) {
            this.helper.dispose();
            this.helper = null;
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (ClientSystemInfo.isMac()) {
            InputMap inputMap = this.getComponent().getInputMap();
            inputMap.put(KeyStroke.getKeyStroke(38, 0), "caret-up");
            inputMap.put(KeyStroke.getKeyStroke(40, 0), "caret-down");
            inputMap.put(KeyStroke.getKeyStroke(33, 0), "page-up");
            inputMap.put(KeyStroke.getKeyStroke(34, 0), "page-down");
        }
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int position = DarculaUIUtil.getPatchedNextVisualPositionFrom(t, pos, direction);
        return position != -1 ? position : super.getNextVisualPositionFrom(t, pos, b, direction, biasRet);
    }

    @Override
    protected Caret createCaret() {
        return new TextFieldWithPopupHandlerUI.MouseDragAwareCaret();
    }

    @Override
    protected void paintSafely(Graphics g) {
        if (SystemInfo.isMacOSCatalina) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        super.paintSafely(g);
    }

    private static class RoundedBorderSupportHandler {
        private final JTextComponent component;
        private final FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                this.repaintParentScrollPane();
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.repaintParentScrollPane();
            }
        };
        private final DocumentListener documentListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.repaintParentScrollPane();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/ui/laf/darcula/ui/DarculaTextAreaUI$RoundedBorderSupportHandler$2", "textChanged"));
            }
        };
        private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("JComponent.outline".equals(evt.getPropertyName())) {
                    this.repaintParentScrollPane();
                }
                if ("document".equals(evt.getPropertyName())) {
                    Document document2;
                    Object object = evt.getOldValue();
                    if (object instanceof Document) {
                        document2 = (Document)object;
                        document2.removeDocumentListener(documentListener);
                    }
                    if ((object = evt.getNewValue()) instanceof Document) {
                        document2 = (Document)object;
                        document2.addDocumentListener(documentListener);
                    }
                }
            }
        };

        private RoundedBorderSupportHandler(JTextComponent component2) {
            this.component = component2;
            component2.addFocusListener(this.focusListener);
            component2.addPropertyChangeListener(this.propertyChangeListener);
            component2.getDocument().addDocumentListener(this.documentListener);
        }

        public void dispose() {
            this.component.removeFocusListener(this.focusListener);
            this.component.removePropertyChangeListener(this.propertyChangeListener);
            this.component.getDocument().removeDocumentListener(this.documentListener);
        }

        private void repaintParentScrollPane() {
            JViewport viewport;
            Container container = this.component.getParent();
            if (container instanceof JViewport && (container = (viewport = (JViewport)container).getParent()) instanceof JBScrollPane) {
                JBScrollPane scrollPane = (JBScrollPane)container;
                scrollPane.repaint();
            }
        }
    }
}

