/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.ui.JBColor;
import com.intellij.ui.hover.HoverListener;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class MainToolbarComboBoxButtonUI
extends DarculaButtonUI {
    private static final Icon EXPAND_ICON = AllIcons.General.ChevronDown;
    @NotNull
    private static final JBColor HOVER_COLOR = JBColor.namedColor((String)"MainToolbar.Dropdown.hoverBackground", (Color)JBColor.background());
    @NotNull
    private static final JBColor TRANSPARENT_HOVER_COLOR = JBColor.namedColor((String)"MainToolbar.Dropdown.transparentHoverBackground", (Color)JBColor.background());
    @NotNull
    private static final JBColor COLOR = JBColor.namedColor((String)"MainToolbar.Dropdown.background", (Color)JBColor.foreground());
    private static final Object HOVER_PROP = "MainToolbarComboBoxButtonUI.isHovered";
    private final HoverListener listener = new HoverListener(this){

        public void mouseEntered(@NotNull Component component2, int x, int y) {
            if (component2 == null) {
                1.$$$reportNull$$$0(0);
            }
            component2.setBackground((Color)HOVER_COLOR);
            ((JComponent)component2).putClientProperty(HOVER_PROP, Boolean.TRUE);
            component2.repaint();
        }

        public void mouseExited(@NotNull Component component2) {
            if (component2 == null) {
                1.$$$reportNull$$$0(1);
            }
            component2.setBackground((Color)COLOR);
            ((JComponent)component2).putClientProperty(HOVER_PROP, null);
            component2.repaint();
        }

        public void mouseMoved(@NotNull Component component2, int x, int y) {
            if (component2 == null) {
                1.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "component";
            objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/MainToolbarComboBoxButtonUI$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new MainToolbarComboBoxButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        c.setForeground((Color)JBColor.namedColor((String)"MainToolbar.Dropdown.foreground", (Color)JBColor.foreground()));
        c.setBackground((Color)COLOR);
        Insets insets = JBUI.CurrentTheme.MainToolbar.Dropdown.borderInsets();
        EmptyBorder border = new EmptyBorder(insets);
        c.setBorder(border);
        c.setOpaque(true);
        this.listener.addTo(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.listener.removeFrom(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (!(c instanceof ComboBoxAction.ComboBoxButton)) {
            return;
        }
        ComboBoxAction.ComboBoxButton button2 = (ComboBoxAction.ComboBoxButton)c;
        if (c.isOpaque()) {
            MainToolbarComboBoxButtonUI.paintBackground(g, (JComponent)button2, button2.getBackground());
        }
        if (button2.isEnabled() && button2.getClientProperty(HOVER_PROP) == Boolean.TRUE) {
            MainToolbarComboBoxButtonUI.paintHover(g, (JComponent)button2);
        }
        this.paintContents(g, (AbstractButton)button2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintContents(Graphics g, AbstractButton c) {
        if (!(c instanceof ComboBoxAction.ComboBoxButton)) {
            return;
        }
        ComboBoxAction.ComboBoxButton button2 = (ComboBoxAction.ComboBoxButton)c;
        FontMetrics fm = UIUtilities.getFontMetrics((JComponent)button2, (Graphics)g);
        int width = button2.getWidth();
        int height = button2.getHeight();
        if (button2.isArrowVisible()) {
            width -= button2.getIconTextGap() + EXPAND_ICON.getIconWidth();
        }
        String text2 = this.layout((AbstractButton)button2, button2.getText(), button2.getIcon(), fm, width, height);
        Graphics g2 = g.create();
        try {
            g2.setColor(button2.getForeground());
            if (button2.getIcon() != null) {
                this.paintIcon(g, (JComponent)button2, this.iconRect);
            }
            if (text2 != null && !text2.isEmpty()) {
                View v = (View)button2.getClientProperty((Object)"html");
                if (v != null) {
                    v.paint(g, this.textRect);
                } else {
                    UISettings.setupAntialiasing((Graphics)g);
                    this.paintText(g, (AbstractButton)button2, this.textRect, text2);
                }
            }
            if (button2.isArrowVisible()) {
                int x = (int)this.textRect.getMaxX() + button2.getIconTextGap();
                int y = height / 2 - EXPAND_ICON.getIconHeight() / 2;
                EXPAND_ICON.paintIcon((Component)button2, g2, x, y);
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    protected Dimension getDarculaButtonSize(JComponent c, Dimension prefSize) {
        Dimension size2 = super.getDarculaButtonSize(c, prefSize);
        if (!(c instanceof ComboBoxAction.ComboBoxButton)) {
            return size2;
        }
        ComboBoxAction.ComboBoxButton button2 = (ComboBoxAction.ComboBoxButton)c;
        if (button2.isArrowVisible()) {
            size2.width += ((AbstractButton)c).getIconTextGap() + EXPAND_ICON.getIconWidth();
        }
        JBInsets.addTo((Dimension)size2, (Insets)button2.getMargin());
        size2.height = Integer.min(size2.height, JBUI.CurrentTheme.Toolbar.experimentalToolbarButtonSize().height);
        return size2;
    }

    private static void paintHover(Graphics g, JComponent c) {
        JBColor color = ProjectWindowCustomizerService.Companion.getInstance().isActive() ? TRANSPARENT_HOVER_COLOR : HOVER_COLOR;
        MainToolbarComboBoxButtonUI.doFill(g, c, (Color)color, true);
    }

    private static void paintBackground(Graphics g, JComponent c, Color color) {
        MainToolbarComboBoxButtonUI.doFill(g, c, color, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doFill(Graphics g, JComponent c, Color color, boolean rounded) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setColor(color);
            Rectangle bounds = c.getVisibleRect();
            if (rounded) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                int arc = JBUI.CurrentTheme.MainToolbar.Dropdown.hoverArc().get();
                g2.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, arc, arc);
            } else {
                g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
        finally {
            g2.dispose();
        }
    }
}

