/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.ide.ui.laf.darcula.ui.AbstractToolbarComboUI;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.AbstractToolbarCombo;
import com.intellij.openapi.wm.impl.ToolbarSplitButton;
import com.intellij.ui.ClickListener;
import com.intellij.ui.hover.HoverListener;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0003#$%B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002J\f\u0010!\u001a\u00020\"*\u00020\"H\u0002R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarSplitButtonUI;", "Lcom/intellij/ide/ui/laf/darcula/ui/AbstractToolbarComboUI;", "Ljava/beans/PropertyChangeListener;", "<init>", "()V", "clickListener", "Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarSplitButtonUI$MyClickListener;", "hoverListener", "Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarSplitButtonUI$MyHoverListener;", "installUI", "", "c", "Ljavax/swing/JComponent;", "uninstallUI", "setUIDefaults", "Lcom/intellij/openapi/wm/impl/AbstractToolbarCombo;", "paint", "g", "Ljava/awt/Graphics;", "getPreferredSize", "Ljava/awt/Dimension;", "calcMaxTextWidth", "", "button", "Lcom/intellij/openapi/wm/impl/ToolbarSplitButton;", "innerRect", "Ljava/awt/Rectangle;", "paintBackground", "getZones", "Lkotlin/Pair;", "getZoneType", "point", "Ljava/awt/Point;", "getTopBottom", "Ljava/awt/Insets;", "Companion", "MyClickListener", "MyHoverListener", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nToolbarSplitButtonUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolbarSplitButtonUI.kt\ncom/intellij/ide/ui/laf/darcula/ui/ToolbarSplitButtonUI\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1#2:286\n*E\n"})
public final class ToolbarSplitButtonUI
extends AbstractToolbarComboUI
implements PropertyChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MyClickListener clickListener = new MyClickListener();
    @NotNull
    private final MyHoverListener hoverListener = new MyHoverListener();

    @Override
    public void installUI(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ToolbarSplitButton widget2 = (ToolbarSplitButton)c;
        this.setUIDefaults(widget2);
        widget2.addPropertyChangeListener(this);
        this.tryUpdateHtmlRenderer(widget2, widget2.getText());
        this.hoverListener.addTo(widget2);
        this.clickListener.installOn(widget2);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ToolbarSplitButton widget2 = (ToolbarSplitButton)c;
        widget2.removePropertyChangeListener(this);
        this.tryUpdateHtmlRenderer(widget2, "");
        this.hoverListener.removeFrom(widget2);
        this.clickListener.uninstall(widget2);
    }

    @Override
    protected void setUIDefaults(@NotNull AbstractToolbarCombo c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        super.setUIDefaults(c);
        ToolbarSplitButton toolbarSplitButton = c instanceof ToolbarSplitButton ? (ToolbarSplitButton)c : null;
        if (toolbarSplitButton == null) {
            return;
        }
        ToolbarSplitButton button2 = toolbarSplitButton;
        Insets insets = JBUI.CurrentTheme.MainToolbar.SplitDropdown.separatorMargin();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"separatorMargin(...)");
        button2.setSeparatorMargin(insets);
        Insets insets2 = JBUI.CurrentTheme.MainToolbar.SplitDropdown.leftPartMargin();
        Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"leftPartMargin(...)");
        button2.setLeftPartMargin(insets2);
        Insets insets3 = JBUI.CurrentTheme.MainToolbar.SplitDropdown.rightPartMargin();
        Intrinsics.checkNotNullExpressionValue((Object)insets3, (String)"rightPartMargin(...)");
        button2.setRightPartMargin(insets3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ToolbarSplitButton toolbarSplitButton = c instanceof ToolbarSplitButton ? (ToolbarSplitButton)c : null;
        if (toolbarSplitButton == null) {
            return;
        }
        ToolbarSplitButton button2 = toolbarSplitButton;
        this.paintBackground(g, button2);
        List<Icon> leftIcons = button2.getLeftIcons();
        List<Icon> rightIcons = button2.getRightIcons();
        String text2 = button2.getText();
        boolean bl2 = bl = !StringUtil.isEmpty((String)text2) || rightIcons.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ToolbarSplitButtonUI$paint$22 = false;
            String $i$a$-assert-ToolbarSplitButtonUI$paint$22 = "Right icons are only allowed when text is not empty";
            throw new AssertionError((Object)$i$a$-assert-ToolbarSplitButtonUI$paint$22);
        }
        Rectangle innerRect = SwingUtilities.calculateInnerArea(c, null);
        Rectangle paintRect = new Rectangle(innerRect);
        JBInsets.removeFrom((Rectangle)paintRect, (Insets)this.getTopBottom(button2.getLeftPartMargin()));
        this.cutLeft(paintRect, ((ToolbarSplitButton)c).getLeftPartMargin().left);
        Intrinsics.checkNotNull((Object)innerRect);
        int maxTextWidth = this.calcMaxTextWidth(button2, innerRect);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            Rectangle iconsRect;
            g2.clip(paintRect);
            GraphicsUtil.setupAAPainting((Graphics)g2);
            if (!leftIcons.isEmpty()) {
                iconsRect = this.paintIcons(leftIcons, button2, g2, paintRect);
                this.cutLeft(paintRect, iconsRect.width);
            }
            if (!StringUtil.isEmpty((String)text2) && maxTextWidth > 0) {
                if (!leftIcons.isEmpty()) {
                    this.cutLeft(paintRect, button2.getIconTextGap());
                }
                Rectangle textRect = new Rectangle(paintRect.x, paintRect.y, maxTextWidth, paintRect.height);
                AbstractToolbarCombo abstractToolbarCombo = button2;
                String string = text2;
                Intrinsics.checkNotNull((Object)string);
                this.drawText(abstractToolbarCombo, string, g2, textRect);
                this.cutLeft(paintRect, maxTextWidth);
            }
            if (!rightIcons.isEmpty()) {
                this.cutLeft(paintRect, button2.getIconTextGap());
                iconsRect = this.paintIcons(rightIcons, button2, g2, paintRect);
                this.cutLeft(paintRect, iconsRect.width);
            }
            this.cutLeft(paintRect, button2.getLeftPartMargin().right);
            JBInsets.addTo((Rectangle)paintRect, (Insets)this.getTopBottom(button2.getLeftPartMargin()));
            Insets sMargin = button2.getSeparatorMargin();
            int sHeight = paintRect.height - sMargin.top - sMargin.bottom;
            g2.setColor(c.isEnabled() ? UIManager.getColor("MainToolbar.separatorColor") : UIUtil.getLabelDisabledForeground());
            g2.fillRect(paintRect.x + sMargin.left, paintRect.y + sMargin.top, 1, sHeight);
            this.cutLeft(paintRect, sMargin.left + sMargin.right + 1);
            this.cutLeft(paintRect, button2.getRightPartMargin().left);
            JBInsets.removeFrom((Rectangle)paintRect, (Insets)this.getTopBottom(button2.getRightPartMargin()));
            this.paintIcons(CollectionsKt.listOf((Object)AllIcons.General.ChevronDown), button2, g2, paintRect);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@NotNull JComponent c) {
        Object text22;
        int n;
        Dimension dimension;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Dimension res = new Dimension();
        ToolbarSplitButton toolbarSplitButton = c instanceof ToolbarSplitButton ? (ToolbarSplitButton)c : null;
        if (toolbarSplitButton == null) {
            return res;
        }
        ToolbarSplitButton button2 = toolbarSplitButton;
        List<Icon> leftIcons = button2.getLeftIcons();
        List<Icon> rightIcons = button2.getRightIcons();
        Insets lMargin = ((ToolbarSplitButton)c).getLeftPartMargin();
        Insets rMargin = ((ToolbarSplitButton)c).getRightPartMargin();
        boolean bl2 = bl = !StringUtil.isEmpty((String)button2.getText()) || rightIcons.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ToolbarSplitButtonUI$getPreferredSize$22 = false;
            String $i$a$-assert-ToolbarSplitButtonUI$getPreferredSize$22 = "Right icons are only allowed when text is not empty";
            throw new AssertionError((Object)$i$a$-assert-ToolbarSplitButtonUI$getPreferredSize$22);
        }
        if (!leftIcons.isEmpty()) {
            res.width += this.calcIconsWidth(leftIcons, button2.getBetweenIconsGap());
            Iterable iterable = leftIcons;
            dimension = res;
            Iterator $i$a$-assert-ToolbarSplitButtonUI$getPreferredSize$22 = iterable.iterator();
            if (!$i$a$-assert-ToolbarSplitButtonUI$getPreferredSize$22.hasNext()) {
                throw new NoSuchElementException();
            }
            Icon it = (Icon)$i$a$-assert-ToolbarSplitButtonUI$getPreferredSize$22.next();
            boolean bl3 = false;
            int n2 = it.getIconHeight();
            while ($i$a$-assert-ToolbarSplitButtonUI$getPreferredSize$22.hasNext()) {
                Icon it22 = (Icon)$i$a$-assert-ToolbarSplitButtonUI$getPreferredSize$22.next();
                $i$a$-maxOf-ToolbarSplitButtonUI$getPreferredSize$2 = false;
                int it22 = it22.getIconHeight();
                if (n2 >= it22) continue;
                n2 = it22;
            }
            n = n2;
            dimension.height = n + lMargin.top + lMargin.bottom;
        }
        if (!StringUtil.isEmpty((String)button2.getText())) {
            if (!leftIcons.isEmpty()) {
                res.width += button2.getIconTextGap();
            }
            FontMetrics metrics = c.getFontMetrics(c.getFont());
            text22 = this.getText(button2);
            int n3 = res.width;
            String string = text22;
            Intrinsics.checkNotNull((Object)string);
            res.width = n3 + metrics.stringWidth(string);
            res.height = Math.max(res.height, metrics.getHeight());
        }
        if (!rightIcons.isEmpty()) {
            res.width += button2.getIconTextGap();
            res.width += this.calcIconsWidth(rightIcons, button2.getBetweenIconsGap());
            int metrics = res.height;
            text22 = rightIcons;
            dimension = res;
            Iterator iterator = text22.iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Icon it = (Icon)iterator.next();
            boolean bl4 = false;
            int n4 = it.getIconHeight();
            while (iterator.hasNext()) {
                Icon it2 = (Icon)iterator.next();
                $i$a$-maxOf-ToolbarSplitButtonUI$getPreferredSize$3 = false;
                int n5 = it2.getIconHeight();
                if (n4 >= n5) continue;
                n4 = n5;
            }
            n = n4;
            int text22 = n + lMargin.top + lMargin.bottom;
            dimension.height = Math.max(metrics, text22);
        }
        res.width += lMargin.left + lMargin.right;
        Insets sMargin = button2.getSeparatorMargin();
        res.width += sMargin.left + 1 + sMargin.right;
        res.width += rMargin.left + AllIcons.General.ChevronDown.getIconWidth() + rMargin.right;
        res.height = Math.max(res.height, AllIcons.General.ChevronDown.getIconHeight() + rMargin.top + rMargin.bottom);
        Insets insets = c.getInsets();
        res.height += insets.top + insets.bottom;
        res.width += insets.left + insets.right;
        return res;
    }

    private final int calcMaxTextWidth(ToolbarSplitButton button2, Rectangle innerRect) {
        int otherElementsWidth = 0;
        int left = this.calcIconsWidth(button2.getLeftIcons(), button2.getBetweenIconsGap());
        if (left > 0) {
            left += button2.getIconTextGap();
        }
        otherElementsWidth += left;
        int right = this.calcIconsWidth(button2.getRightIcons(), button2.getBetweenIconsGap());
        if (right > 0) {
            right += button2.getIconTextGap();
        }
        otherElementsWidth += right;
        Insets sMargin = button2.getSeparatorMargin();
        otherElementsWidth += sMargin.left + 1 + sMargin.right + AllIcons.General.ChevronDown.getIconWidth();
        Insets lMargin = button2.getLeftPartMargin();
        Insets rMargin = button2.getRightPartMargin();
        return innerRect.width - (otherElementsWidth += lMargin.left + lMargin.right + rMargin.left + rMargin.right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void paintBackground(Graphics g, ToolbarSplitButton button2) {
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        try {
            if (button2.isOpaque()) {
                g2.setColor(button2.getBackground());
                Rectangle bounds = g2.getClipBounds();
                g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            if (button2.isEnabled()) {
                g2.setColor(ProjectWindowCustomizerService.Companion.getInstance().isActive() ? button2.getTransparentHoverBackground() : button2.getHoverBackground());
                int arc = JBUI.CurrentTheme.MainToolbar.Dropdown.hoverArc().get();
                Pair<Rectangle, Rectangle> pair = this.getZones(button2);
                Rectangle actionZone = (Rectangle)pair.component1();
                Rectangle expandZone = (Rectangle)pair.component2();
                if (button2.getModel().isActionButtonSelected()) {
                    g2.fillRoundRect(actionZone.x, actionZone.y, actionZone.width, actionZone.height, arc, arc);
                }
                if (button2.getModel().isExpandButtonSelected()) {
                    g2.fillRoundRect(expandZone.x, expandZone.y, expandZone.width, expandZone.height, arc, arc);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    private final Pair<Rectangle, Rectangle> getZones(ToolbarSplitButton button2) {
        Insets insets = button2.getInsets();
        Insets separatorMargin = button2.getSeparatorMargin();
        Insets rightPartMargin = button2.getRightPartMargin();
        int zoneHeight = button2.getHeight() - insets.top - insets.bottom;
        int expandZoneStart = button2.getWidth() - insets.right - rightPartMargin.right - AllIcons.General.ChevronDown.getIconWidth() - rightPartMargin.left;
        Rectangle expandRect = new Rectangle(expandZoneStart, insets.top, AllIcons.General.ChevronDown.getIconWidth() + rightPartMargin.left + rightPartMargin.right, zoneHeight);
        int actionZoneWidth = button2.getWidth() - expandRect.width - separatorMargin.right - 1 - separatorMargin.left - insets.left - insets.right;
        Rectangle actionRect = new Rectangle(insets.left, insets.top, actionZoneWidth, zoneHeight);
        return new Pair((Object)actionRect, (Object)expandRect);
    }

    private final int getZoneType(ToolbarSplitButton button2, Point point) {
        Pair<Rectangle, Rectangle> pair = this.getZones(button2);
        Rectangle action2 = (Rectangle)pair.component1();
        Rectangle expand = (Rectangle)pair.component2();
        return action2.contains(point) ? 1 : (expand.contains(point) ? 2 : 0);
    }

    private final Insets getTopBottom(Insets $this$getTopBottom) {
        return new Insets($this$getTopBottom.top, 0, $this$getTopBottom.bottom, 0);
    }

    @JvmStatic
    @NotNull
    public static final ToolbarSplitButtonUI createUI(@NotNull JComponent c) {
        return Companion.createUI(c);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarSplitButtonUI$Companion;", "", "<init>", "()V", "createUI", "Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarSplitButtonUI;", "c", "Ljavax/swing/JComponent;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ToolbarSplitButtonUI createUI(@NotNull JComponent c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return new ToolbarSplitButtonUI();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarSplitButtonUI$MyClickListener;", "Lcom/intellij/ui/ClickListener;", "<init>", "(Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarSplitButtonUI;)V", "onClick", "", "e", "Ljava/awt/event/MouseEvent;", "clickCount", "", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nToolbarSplitButtonUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolbarSplitButtonUI.kt\ncom/intellij/ide/ui/laf/darcula/ui/ToolbarSplitButtonUI$MyClickListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1869#2,2:286\n1869#2,2:288\n*S KotlinDebug\n*F\n+ 1 ToolbarSplitButtonUI.kt\ncom/intellij/ide/ui/laf/darcula/ui/ToolbarSplitButtonUI$MyClickListener\n*L\n253#1:286,2\n254#1:288,2\n*E\n"})
    private final class MyClickListener
    extends ClickListener {
        public boolean onClick(@NotNull MouseEvent e, int clickCount) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Component component2 = e.getComponent();
            ToolbarSplitButton toolbarSplitButton = component2 instanceof ToolbarSplitButton ? (ToolbarSplitButton)component2 : null;
            if (toolbarSplitButton != null) {
                component2 = toolbarSplitButton;
                ToolbarSplitButtonUI toolbarSplitButtonUI = ToolbarSplitButtonUI.this;
                Component button2 = component2;
                boolean bl = false;
                if (button2.isEnabled()) {
                    ActionEvent ae = new ActionEvent(button2, 0, null, System.currentTimeMillis(), e.getModifiersEx());
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    int zone = toolbarSplitButtonUI.getZoneType((ToolbarSplitButton)button2, point);
                    switch (zone) {
                        case 2: {
                            Iterable $this$forEach$iv = ((ToolbarSplitButton)button2).getModel().getExpandListeners();
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                ActionListener l = (ActionListener)element$iv;
                                boolean bl2 = false;
                                l.actionPerformed(ae);
                            }
                            break;
                        }
                        case 1: {
                            Iterable $this$forEach$iv = ((ToolbarSplitButton)button2).getModel().getActionListeners();
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                ActionListener l = (ActionListener)element$iv;
                                boolean bl3 = false;
                                l.actionPerformed(ae);
                            }
                            break;
                        }
                    }
                    return true;
                }
            }
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarSplitButtonUI$MyHoverListener;", "Lcom/intellij/ui/hover/HoverListener;", "<init>", "(Lcom/intellij/ide/ui/laf/darcula/ui/ToolbarSplitButtonUI;)V", "mouseEntered", "", "c", "Ljava/awt/Component;", "x", "", "y", "mouseMoved", "mouseExited", "updateSelectedZone", "intellij.platform.ide.impl"})
    private final class MyHoverListener
    extends HoverListener {
        public void mouseEntered(@NotNull Component c, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            this.updateSelectedZone(c, x, y);
        }

        public void mouseMoved(@NotNull Component c, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            this.updateSelectedZone(c, x, y);
        }

        public void mouseExited(@NotNull Component c) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Object object = c instanceof ToolbarSplitButton ? (ToolbarSplitButton)c : null;
                if (object == null || (object = ((ToolbarSplitButton)object).getModel()) == null) break block0;
                Object it = object;
                boolean bl = false;
                it.setActionButtonSelected(false);
                it.setExpandButtonSelected(false);
            }
        }

        private final void updateSelectedZone(Component c, int x, int y) {
            ToolbarSplitButton toolbarSplitButton = c instanceof ToolbarSplitButton ? (ToolbarSplitButton)c : null;
            if (toolbarSplitButton == null) {
                return;
            }
            ToolbarSplitButton button2 = toolbarSplitButton;
            int zone = ToolbarSplitButtonUI.this.getZoneType(button2, new Point(x, y));
            button2.getModel().setActionButtonSelected(zone == 1);
            button2.getModel().setExpandButtonSelected(zone == 2);
        }
    }
}

