/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.text.paragraph;

import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.ide.ui.text.parts.RegularTextPart;
import com.intellij.ide.ui.text.parts.TextPart;
import java.awt.Font;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J6\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J8\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\tH\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/ui/text/paragraph/ListParagraph;", "Lcom/intellij/ide/ui/text/paragraph/TextParagraph;", "items", "", "<init>", "(Ljava/util/List;)V", "getItems", "()Ljava/util/List;", "insertToDocument", "", "textPane", "Ljavax/swing/JTextPane;", "startOffset", "isLast", "", "insertListItem", "itemParagraphs", "spaceAbove", "", "insertParagraph", "paragraph", "leftIndent", "findPartByOffset", "Lkotlin/Pair;", "Lcom/intellij/ide/ui/text/parts/TextPart;", "Lkotlin/ranges/IntRange;", "offset", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nListParagraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListParagraph.kt\ncom/intellij/ide/ui/text/paragraph/ListParagraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1869#2:74\n1870#2:76\n1#3:75\n*S KotlinDebug\n*F\n+ 1 ListParagraph.kt\ncom/intellij/ide/ui/text/paragraph/ListParagraph\n*L\n64#1:74\n64#1:76\n*E\n"})
public final class ListParagraph
extends TextParagraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<List<TextParagraph>> items;
    @NotNull
    private static final String LIST_POINT = "\u2022  ";

    public ListParagraph(@NotNull List<? extends List<? extends TextParagraph>> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        super(CollectionsKt.emptyList());
        this.items = items2;
    }

    @NotNull
    public final List<List<TextParagraph>> getItems() {
        return this.items;
    }

    @Override
    public int insertToDocument(@NotNull JTextPane textPane, int startOffset, boolean isLast) {
        Intrinsics.checkNotNullParameter((Object)textPane, (String)"textPane");
        int curOffset = startOffset;
        Iterator iterator = ((Iterable)this.items).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int ind = n++;
            List itemParagraphs = (List)iterator.next();
            float indent = ind == 0 ? 12.0f : 8.0f;
            boolean last = isLast && ind == CollectionsKt.getLastIndex(this.items);
            curOffset = this.insertListItem(itemParagraphs, indent, textPane, curOffset, last);
        }
        return curOffset;
    }

    private final int insertListItem(List<? extends TextParagraph> itemParagraphs, float spaceAbove, JTextPane textPane, int startOffset, boolean isLast) {
        int curOffset = startOffset;
        RegularTextPart pointPart = new RegularTextPart(LIST_POINT, false, 2, null);
        int additionalIndent = textPane.getFontMetrics((Font)pointPart.getFontGetter().invoke()).stringWidth(LIST_POINT);
        Iterator iterator = ((Iterable)itemParagraphs).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            boolean last;
            int ind = n++;
            TextParagraph paragraph = (TextParagraph)iterator.next();
            boolean bl = last = isLast && ind == CollectionsKt.getLastIndex(itemParagraphs);
            if (ind == 0) {
                curOffset = pointPart.insertToTextPane(textPane, curOffset);
                curOffset = this.insertParagraph(paragraph, spaceAbove, 8.0f, textPane, curOffset, last);
                continue;
            }
            curOffset = this.insertParagraph(paragraph, 4.0f, 8.0f + (float)additionalIndent, textPane, curOffset, last);
        }
        return curOffset;
    }

    private final int insertParagraph(TextParagraph paragraph, float spaceAbove, float leftIndent, JTextPane textPane, int startOffset, boolean isLast) {
        paragraph.editAttributes((Function1<? super SimpleAttributeSet, Unit>)((Function1)arg_0 -> ListParagraph.insertParagraph$lambda$0(spaceAbove, leftIndent, arg_0)));
        return paragraph.insertToDocument(textPane, startOffset, isLast);
    }

    @Override
    @Nullable
    public Pair<TextPart, IntRange> findPartByOffset(int offset) {
        Iterable $this$forEach$iv = CollectionsKt.flatten((Iterable)this.items);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TextParagraph paragraph = (TextParagraph)element$iv;
            boolean bl = false;
            Pair<TextPart, IntRange> pair = paragraph.findPartByOffset(offset);
            if (pair == null) continue;
            Pair<TextPart, IntRange> it = pair;
            boolean bl2 = false;
            return it;
        }
        return null;
    }

    private static final Unit insertParagraph$lambda$0(float $spaceAbove, float $leftIndent, SimpleAttributeSet $this$editAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$editAttributes, (String)"$this$editAttributes");
        StyleConstants.setSpaceAbove($this$editAttributes, $spaceAbove);
        StyleConstants.setLeftIndent($this$editAttributes, $leftIndent);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/ui/text/paragraph/ListParagraph$Companion;", "", "<init>", "()V", "LIST_POINT", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

