/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupWrapper;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.ActionUpdateThreadAware;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionGroupUtil {
    public static boolean isGroupEmpty(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e) {
        if (actionGroup == null) {
            ActionGroupUtil.$$$reportNull$$$0(0);
        }
        if (e == null) {
            ActionGroupUtil.$$$reportNull$$$0(1);
        }
        return ActionGroupUtil.getActiveActions(actionGroup, e).isEmpty();
    }

    @Nullable
    public static AnAction getSingleActiveAction(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e) {
        if (actionGroup == null) {
            ActionGroupUtil.$$$reportNull$$$0(2);
        }
        if (e == null) {
            ActionGroupUtil.$$$reportNull$$$0(3);
        }
        return (AnAction)ActionGroupUtil.getActiveActions(actionGroup, e).single();
    }

    @NotNull
    public static JBIterable<? extends AnAction> getActiveActions(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e) {
        if (actionGroup == null) {
            ActionGroupUtil.$$$reportNull$$$0(4);
        }
        if (e == null) {
            ActionGroupUtil.$$$reportNull$$$0(5);
        }
        UpdateSession session = e.getUpdateSession();
        JBIterable jBIterable = JBIterable.from((Iterable)session.expandedChildren(actionGroup)).filter(o -> !(o instanceof Separator) && session.presentation(o).isEnabledAndVisible());
        if (jBIterable == null) {
            ActionGroupUtil.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<? extends AnAction> getVisibleActions(@NotNull ActionGroup actionGroup, @NotNull AnActionEvent e) {
        if (actionGroup == null) {
            ActionGroupUtil.$$$reportNull$$$0(7);
        }
        if (e == null) {
            ActionGroupUtil.$$$reportNull$$$0(8);
        }
        UpdateSession session = e.getUpdateSession();
        JBIterable jBIterable = JBIterable.from((Iterable)session.expandedChildren(actionGroup)).filter(o -> !(o instanceof Separator) && session.presentation(o).isVisible());
        if (jBIterable == null) {
            ActionGroupUtil.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @ApiStatus.Experimental
    @NotNull
    public static ActionGroup forceHideDisabledChildren(@NotNull ActionGroup actionGroup) {
        if (actionGroup == null) {
            ActionGroupUtil.$$$reportNull$$$0(10);
        }
        final class Compact
        extends ActionGroupWrapper
        implements PresentationFactory.TransparentWrapper {
            Compact(@NotNull ActionGroup action2) {
                if (action2 == null) {
                    Compact.$$$reportNull$$$0(0);
                }
                super(action2);
            }

            @NotNull
            @ApiStatus.Internal
            public Presentation createTemplatePresentation() {
                Presentation presentation2 = super.createTemplatePresentation();
                presentation2.putClientProperty(ActionUtil.HIDE_DISABLED_CHILDREN, (Object)true);
                Presentation presentation3 = presentation2;
                if (presentation3 == null) {
                    Compact.$$$reportNull$$$0(1);
                }
                return presentation3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/actionSystem/ActionGroupUtil$1Compact";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/actionSystem/ActionGroupUtil$1Compact";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTemplatePresentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
        return new Compact(actionGroup);
    }

    @ApiStatus.Experimental
    @NotNull
    public static ActionGroup forceRecursiveUpdateInBackground(@NotNull ActionGroup actionGroup) {
        if (actionGroup == null) {
            ActionGroupUtil.$$$reportNull$$$0(11);
        }
        final class MyGroup
        extends ActionGroup
        implements ActionUpdateThreadAware.Recursive,
        PresentationFactory.TransparentWrapper {
            final /* synthetic */ ActionGroup val$actionGroup;

            MyGroup(ActionGroup actionGroup) {
                this.val$actionGroup = actionGroup;
                this.setPopup(false);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    MyGroup.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = new AnAction[]{this.val$actionGroup};
                if (anActionArray == null) {
                    MyGroup.$$$reportNull$$$0(1);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/actionSystem/ActionGroupUtil$1MyGroup";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
        return actionGroup instanceof ActionUpdateThreadAware.Recursive ? actionGroup : new MyGroup(actionGroup);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ActionGroupUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ActionGroupUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isGroupEmpty";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSingleActiveAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActiveActions";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleActions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "forceHideDisabledChildren";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forceRecursiveUpdateInBackground";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9 -> new IllegalStateException(string);
        };
    }
}

