/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.AbstractBundle;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QuickList
extends ExternalizableSchemeAdapter
implements SerializableScheme {
    public static final String QUICK_LIST_PREFIX = "QuickList.";
    @NonNls
    public static final String SEPARATOR_ID = "QuickList.$Separator$";
    private static final String ID_TAG = "id";
    private static final String ACTION_TAG = "action";
    static final String DISPLAY_NAME_TAG = "display";
    private static final String DESCRIPTION_TAG = "description";
    private String myDescription;
    private String[] myActionIds;
    private SchemeState schemeState;
    @Nullable
    private ResourceBundle myBundle;

    QuickList() {
        this.myActionIds = ArrayUtilRt.EMPTY_STRING_ARRAY;
        this.setName("");
    }

    public QuickList(@NotNull QuickList other) {
        if (other == null) {
            QuickList.$$$reportNull$$$0(0);
        }
        this.myActionIds = ArrayUtilRt.EMPTY_STRING_ARRAY;
        this.setName(other.getName());
        this.myDescription = StringUtil.nullize((String)other.myDescription);
        this.myBundle = other.myBundle;
        this.myActionIds = other.getActionIds();
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if (this.myBundle != null) {
            String string = AbstractBundle.messageOrDefault((ResourceBundle)this.myBundle, (String)(this.getActionId() + ".text"), (String)this.getName(), (Object[])new Object[0]);
            if (string == null) {
                QuickList.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = super.getDisplayName();
        if (string == null) {
            QuickList.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        if (StringUtil.isEmpty((String)this.myDescription) && this.myBundle != null) {
            this.myDescription = AbstractBundle.messageOrNull((ResourceBundle)this.myBundle, (String)(this.getActionId() + ".description"), (Object[])new Object[0]);
        }
        return this.myDescription;
    }

    void localizeWithBundle(@Nullable ResourceBundle resourceBundle) {
        this.myBundle = resourceBundle;
    }

    public void setDescription(@Nullable String value) {
        this.myDescription = StringUtil.nullize((String)value);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public String[] getActionIds() {
        return this.myActionIds;
    }

    public void setActionIds(String @NotNull [] value) {
        if (value == null) {
            QuickList.$$$reportNull$$$0(3);
        }
        this.myActionIds = value;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QuickList)) {
            return false;
        }
        QuickList quickList = (QuickList)((Object)o);
        return Arrays.equals(this.myActionIds, quickList.myActionIds) && Comparing.strEqual((String)this.myDescription, (String)quickList.myDescription) && this.getName().equals(quickList.getName());
    }

    public int hashCode() {
        return 29 * this.getName().hashCode() + Comparing.hashcode((Object)this.myDescription);
    }

    @NotNull
    public String toString() {
        String string = this.getName() + " " + this.getDescription();
        if (string == null) {
            QuickList.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getActionId() {
        String string = QUICK_LIST_PREFIX + this.getName();
        if (string == null) {
            QuickList.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            QuickList.$$$reportNull$$$0(6);
        }
        this.setName(element.getAttributeValue(DISPLAY_NAME_TAG));
        this.myDescription = StringUtil.nullize((String)element.getAttributeValue(DESCRIPTION_TAG));
        List actionElements = element.getChildren(ACTION_TAG);
        this.myActionIds = new String[actionElements.size()];
        int n = actionElements.size();
        for (int i2 = 0; i2 < n; ++i2) {
            this.myActionIds[i2] = ((Element)actionElements.get(i2)).getAttributeValue(ID_TAG);
        }
    }

    @NotNull
    public Element writeScheme() {
        Element element = new Element("list");
        element.setAttribute(DISPLAY_NAME_TAG, this.getName());
        if (this.myDescription != null) {
            element.setAttribute(DESCRIPTION_TAG, this.myDescription);
        }
        for (String actionId : this.getActionIds()) {
            element.addContent(new Element(ACTION_TAG).setAttribute(ID_TAG, actionId));
        }
        this.schemeState = SchemeState.UNCHANGED;
        Element element2 = element;
        if (element2 == null) {
            QuickList.$$$reportNull$$$0(7);
        }
        return element2;
    }

    @Nullable
    public SchemeState getSchemeState() {
        return this.schemeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/QuickList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/QuickList";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "writeScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setActionIds";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

