/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\t\u0010\nJ$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/actionSystem/impl/ActionGroupStub;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionStubBase;", "id", "", "actionClass", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "iconPath", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ide/plugins/IdeaPluginDescriptor;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getPlugin", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getIconPath", "classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "()Ljava/lang/ClassLoader;", "popupDefinedInXml", "", "getPopupDefinedInXml", "()Z", "setPopupDefinedInXml", "(Z)V", "initGroup", "", "target", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "actionToId", "Ljava/util/function/Function;", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.platform.ide.impl"})
public final class ActionGroupStub
extends DefaultActionGroup
implements ActionStubBase {
    @NotNull
    private final String id;
    @JvmField
    @NotNull
    public final String actionClass;
    @NotNull
    private final IdeaPluginDescriptor plugin;
    @Nullable
    private final String iconPath;
    private boolean popupDefinedInXml;

    public ActionGroupStub(@NotNull String id2, @NotNull String actionClass, @NotNull IdeaPluginDescriptor plugin, @Nullable String iconPath) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)actionClass, (String)"actionClass");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.id = id2;
        this.actionClass = actionClass;
        this.plugin = plugin;
        this.iconPath = iconPath;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public IdeaPluginDescriptor getPlugin() {
        return this.plugin;
    }

    @Nullable
    public String getIconPath() {
        return this.iconPath;
    }

    @NotNull
    public final ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getPlugin().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return classLoader;
    }

    public final boolean getPopupDefinedInXml() {
        return this.popupDefinedInXml;
    }

    public final void setPopupDefinedInXml(boolean bl) {
        this.popupDefinedInXml = bl;
    }

    public final void initGroup(@NotNull ActionGroup target, @NotNull Function<AnAction, String> actionToId) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(actionToId, (String)"actionToId");
        ActionStub.copyTemplatePresentation((Presentation)this.getTemplatePresentation(), (Presentation)target.getTemplatePresentation());
        if (this.popupDefinedInXml) {
            target.setPopup(this.isPopup());
        }
        this.copyActionTextOverrides((AnAction)target);
        target.setSearchable(this.isSearchable());
        target.setShortcutSet(this.getShortcutSet());
        AnAction[] anActionArray = this.getChildActionsOrStubs();
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"getChildActionsOrStubs(...)");
        AnAction[] children2 = anActionArray;
        if (!(children2.length == 0)) {
            if (!(target instanceof DefaultActionGroup)) {
                throw new PluginException("To accept children action group class must extend DefaultActionGroup, got `" + this.actionClass + "`", this.getPlugin().getPluginId());
            }
            for (AnAction action2 : children2) {
                ((DefaultActionGroup)target).addAction(action2, Constraints.LAST, actionToId);
            }
        }
    }
}

