/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.diagnostic.UILatencyLogger;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.inspector.UiInspectorActionUtil;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.MainMenuPresentationAware;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.ActionMenuItemKt;
import com.intellij.openapi.actionSystem.impl.ActionPresentationDecorator;
import com.intellij.openapi.actionSystem.impl.ActualActionUiKind;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.StubItem;
import com.intellij.openapi.actionSystem.impl.SubElementSelector;
import com.intellij.openapi.actionSystem.impl.UsabilityHelper;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRef;
import com.intellij.openapi.actionSystem.impl.actionholder.ActionRefKt;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBMenu;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.mac.MacMenuSettings;
import com.intellij.ui.plaf.beg.BegMenuItemUI;
import com.intellij.ui.plaf.beg.IdeaMenuUI;
import com.intellij.util.FontUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.EdtScheduler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0002;<BC\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u001dH\u0016J\b\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020#H\u0002J\u0015\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b*J\b\u0010+\u001a\u00020#H\u0002J\u0010\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020.H\u0016J\b\u00101\u001a\u00020#H\u0002J\u0010\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u000bH\u0016J\u0010\u00104\u001a\u00020#2\u0006\u00105\u001a\u000206H\u0014J\u0010\u00107\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0006\u00108\u001a\u00020#J\b\u00109\u001a\u00020\u0003H\u0002J\u0006\u0010:\u001a\u00020#R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010'\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010!\u00a8\u0006="}, d2={"Lcom/intellij/openapi/actionSystem/impl/ActionMenu;", "Lcom/intellij/ui/components/JBMenu;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "place", "", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "presentationFactory", "Lcom/intellij/openapi/actionSystem/impl/PresentationFactory;", "isMnemonicEnabled", "", "useDarkIcons", "isHeaderMenuItem", "<init>", "(Lcom/intellij/openapi/actionSystem/DataContext;Ljava/lang/String;Lcom/intellij/openapi/actionSystem/ActionGroup;Lcom/intellij/openapi/actionSystem/impl/PresentationFactory;ZZZ)V", "Lcom/intellij/openapi/actionSystem/impl/actionholder/ActionRef;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "Lorg/jetbrains/annotations/NotNull;", "disposable", "Lcom/intellij/openapi/Disposable;", "subElementSelector", "Lcom/intellij/openapi/actionSystem/impl/SubElementSelector;", "anAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getAnAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "specialMenu", "Ljavax/swing/JPopupMenu;", "value", "isTryingToShowPopupMenu", "isTryingToShowPopupMenu$intellij_platform_ide_impl", "()Z", "removeNotify", "", "getPopupMenu", "updateUI", "init", "isMainMenuPlace", "updateFromPresentation", "enableMnemonics", "updateFromPresentation$intellij_platform_ide_impl", "addStubItem", "setDisplayedMnemonicIndex", "index", "", "setMnemonic", "mnemonic", "updateIcon", "menuSelectionChanged", "isIncluded", "processMouseEvent", "e", "Ljava/awt/event/MouseEvent;", "setPopupMenuVisible", "clearItems", "getDataContext", "fillMenu", "Companion", "MenuListenerImpl", "intellij.platform.ide.impl"})
public final class ActionMenu
extends JBMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final DataContext context;
    @NotNull
    private final String place;
    @NotNull
    private final PresentationFactory presentationFactory;
    private boolean isMnemonicEnabled;
    private final boolean useDarkIcons;
    @JvmField
    public final boolean isHeaderMenuItem;
    @NotNull
    private final ActionRef<ActionGroup> group;
    @NotNull
    private final Presentation presentation;
    @Nullable
    private Disposable disposable;
    @Nullable
    private final SubElementSelector subElementSelector;
    @Nullable
    private JPopupMenu specialMenu;
    private boolean isTryingToShowPopupMenu;

    public ActionMenu(@Nullable DataContext context, @NotNull String place, @NotNull ActionGroup group2, @NotNull PresentationFactory presentationFactory, boolean isMnemonicEnabled, boolean useDarkIcons, boolean isHeaderMenuItem) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)presentationFactory, (String)"presentationFactory");
        this.context = context;
        this.place = place;
        this.presentationFactory = presentationFactory;
        this.isMnemonicEnabled = isMnemonicEnabled;
        this.useDarkIcons = useDarkIcons;
        this.isHeaderMenuItem = isHeaderMenuItem;
        this.group = ActionRefKt.createActionRef((AnAction)group2);
        Presentation presentation2 = this.presentationFactory.getPresentation((AnAction)group2);
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        this.presentation = presentation2;
        this.subElementSelector = SubElementSelector.Companion.isForceDisabled() ? null : new SubElementSelector(this);
        this.updateUI();
        this.init();
        BegMenuItemUI.registerMultiChoiceSupport(this.getPopupMenu(), arg_0 -> ActionMenu._init_$lambda$1(arg_0 -> ActionMenu._init_$lambda$0(this, arg_0), arg_0));
    }

    public /* synthetic */ ActionMenu(DataContext dataContext2, String string, ActionGroup actionGroup, PresentationFactory presentationFactory, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            bl3 = false;
        }
        this(dataContext2, string, actionGroup, presentationFactory, bl, bl2, bl3);
    }

    @NotNull
    public final AnAction getAnAction() {
        return this.group.getAction();
    }

    public final boolean isTryingToShowPopupMenu$intellij_platform_ide_impl() {
        return this.isTryingToShowPopupMenu;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.disposable != null) {
            Disposable disposable = this.disposable;
            Intrinsics.checkNotNull((Object)disposable);
            Disposer.dispose((Disposable)disposable);
            this.disposable = null;
        }
    }

    @NotNull
    public JPopupMenu getPopupMenu() {
        JPopupMenu specialMenu = this.specialMenu;
        if (specialMenu == null) {
            this.specialMenu = specialMenu = (JPopupMenu)new JBPopupMenu();
            ((JBPopupMenu)specialMenu).setInvoker((Component)((Object)this));
            this.popupListener = this.createWinListener(specialMenu);
            ReflectionUtil.setField(JMenu.class, (Object)((Object)this), JPopupMenu.class, (String)"popupMenu", (Object)specialMenu);
            UiInspectorUtil.registerProvider((JComponent)specialMenu, () -> ActionMenu.getPopupMenu$lambda$0(this));
        }
        JPopupMenu jPopupMenu = super.getPopupMenu();
        Intrinsics.checkNotNullExpressionValue((Object)jPopupMenu, (String)"getPopupMenu(...)");
        return jPopupMenu;
    }

    public void updateUI() {
        if (this.place == null) {
            return;
        }
        this.setUI(IdeaMenuUI.createUI((JComponent)((Object)this)));
        this.setFont(FontUtil.getMenuFont());
        this.getPopupMenu().updateUI();
    }

    private final void init() {
        if (this.subElementSelector != null) {
            this.subElementSelector.stubItem = MacMenuSettings.isSystemMenu && this.isMainMenuPlace() ? null : new StubItem();
        }
        this.addStubItem();
        this.setBorderPainted(false);
        MenuListenerImpl menuListener = new MenuListenerImpl();
        this.addMenuListener(menuListener);
        this.getModel().addChangeListener(menuListener);
        this.updateFromPresentation$intellij_platform_ide_impl(this.isMnemonicEnabled);
    }

    public final boolean isMainMenuPlace() {
        return Intrinsics.areEqual((Object)this.place, (Object)"MainMenu");
    }

    public final void updateFromPresentation$intellij_platform_ide_impl(boolean enableMnemonics) {
        this.isMnemonicEnabled = enableMnemonics;
        this.setVisible(this.presentation.isVisible());
        this.setEnabled(this.presentation.isEnabled());
        this.setText(ActionPresentationDecorator.decorateTextIfNeeded(this.getAnAction(), this.presentation.getText(this.isMnemonicEnabled)));
        this.setMnemonic(this.presentation.getMnemonic());
        this.setDisplayedMnemonicIndex(this.presentation.getDisplayedMnemonicIndex());
        this.updateIcon();
    }

    private final void addStubItem() {
        block0: {
            Object object = this.subElementSelector;
            if (object == null || (object = ((SubElementSelector)object).stubItem) == null) break block0;
            Object it = object;
            boolean bl = false;
            this.add((JMenuItem)it);
        }
    }

    public void setDisplayedMnemonicIndex(int index) {
        super.setDisplayedMnemonicIndex(this.isMnemonicEnabled ? index : -1);
    }

    public void setMnemonic(int mnemonic) {
        super.setMnemonic(this.isMnemonicEnabled ? mnemonic : 0);
    }

    private final void updateIcon() {
        if (this.getAnAction() instanceof Toggleable && Toggleable.isSelected((Presentation)this.presentation)) {
            ActionMenuItemKt.setToggledIcon((JMenuItem)((Object)this));
            return;
        }
        Icon icon2 = this.presentation.getIcon();
        if (icon2 == null) {
            return;
        }
        Icon icon3 = icon2;
        if (!UISettings.Companion.getInstance().getShowIconsInMenus()) {
            return;
        }
        if (MacMenuSettings.isSystemMenu && Intrinsics.areEqual((Object)"MainMenu", (Object)this.place)) {
            icon3 = IconUtilKt.getMenuBarIcon((Icon)icon3, (boolean)this.useDarkIcons);
        } else if (Companion.shouldConvertIconToDarkVariant()) {
            icon3 = IconLoader.getDarkIcon((Icon)icon3, (boolean)true);
        }
        if (Companion.isShowNoIcons() && !Companion.isShowNoIcons((AnAction)this.group.getAction(), this.presentation)) {
            this.setIcon(null);
            this.setDisabledIcon(null);
        } else {
            this.setIcon(icon3);
            Icon presentationDisabledIcon = this.presentation.getDisabledIcon();
            Icon icon4 = presentationDisabledIcon;
            if (icon4 == null) {
                icon4 = IconLoader.getDisabledIcon((Icon)icon3);
            }
            this.setDisabledIcon(icon4);
        }
    }

    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        Companion.showDescriptionInStatusBar(isIncluded, (Component)((Object)this), this.presentation.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMouseEvent(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean shouldCancelIgnoringOfNextSelectionRequest = false;
        SubElementSelector subElementSelector = this.subElementSelector;
        if (subElementSelector != null) {
            switch (e.getID()) {
                case 501: {
                    subElementSelector.ignoreNextSelectionRequest();
                    shouldCancelIgnoringOfNextSelectionRequest = true;
                    break;
                }
                case 504: {
                    subElementSelector.ignoreNextSelectionRequest(this.getDelay() * 2);
                }
            }
        }
        try {
            super.processMouseEvent(e);
        }
        finally {
            if (shouldCancelIgnoringOfNextSelectionRequest) {
                SubElementSelector subElementSelector2 = subElementSelector;
                if (subElementSelector2 != null) {
                    subElementSelector2.cancelIgnoringOfNextSelectionRequest();
                }
            }
        }
    }

    public void setPopupMenuVisible(boolean value) {
        block4: {
            this.isTryingToShowPopupMenu = value;
            if (!(!value || MacMenuSettings.isSystemMenu && Intrinsics.areEqual((Object)"MainMenu", (Object)this.place))) {
                this.fillMenu();
                if (!this.isSelected()) {
                    return;
                }
            }
            if (!MacMenuSettings.isSystemMenu && this.getParent() instanceof JMenuBar) {
                this.getPopupMenu().setSize(new Dimension(0, 0));
            }
            super.setPopupMenuVisible(value);
            if (!value) break block4;
            SubElementSelector subElementSelector = this.subElementSelector;
            if (subElementSelector != null) {
                subElementSelector.selectSubElementIfNecessary();
            }
        }
    }

    public final void clearItems() {
        if (MacMenuSettings.isSystemMenu && this.isMainMenuPlace()) {
            Component[] componentArray = this.getMenuComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getMenuComponents(...)");
            for (Component menuComponent : componentArray) {
                if (menuComponent instanceof ActionMenu) {
                    ((ActionMenu)((Object)menuComponent)).clearItems();
                    continue;
                }
                if (!(menuComponent instanceof ActionMenuItem) || SystemInfoRt.isMac) continue;
                ((ActionMenuItem)((Object)menuComponent)).setAccelerator(KeyStroke.getKeyStroke(61451, 0));
            }
        }
        this.removeAll();
        this.validate();
    }

    private final DataContext getDataContext() {
        DataContext context = this.context;
        if (context != null) {
            return context;
        }
        DataManager dataManager = DataManager.getInstance();
        context = dataManager.getDataContext();
        if (PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context) == null) {
            IdeFrame frame = (IdeFrame)ComponentUtil.getParentOfType(IdeFrame.class, (Component)((Component)((Object)this)));
            context = dataManager.getDataContext(IdeFocusManager.getGlobalInstance().getLastFocusedFor((Window)frame));
        }
        return context;
    }

    public final void fillMenu() {
        DataContext context = this.getDataContext();
        Utils.INSTANCE.fillMenu$intellij_platform_ide_impl(new ActualActionUiKind.Menu((MenuElement)((Object)this), this.isMainMenuPlace()), this.group.getAction(), this.isMnemonicEnabled, this.presentationFactory, context, this.place, RelativePoint.getNorthEastOf((JComponent)((JComponent)((Object)this))), (Function0<Boolean>)((Function0)() -> ActionMenu.fillMenu$lambda$0(this)));
    }

    private static final Unit _init_$lambda$0(ActionMenu this$0, JPopupMenu popupMenu) {
        Intrinsics.checkNotNull((Object)popupMenu);
        Utils.updateMenuItems(popupMenu, this$0.getDataContext(), this$0.place, this$0.presentationFactory);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final List getPopupMenu$lambda$0(ActionMenu this$0) {
        return UiInspectorActionUtil.collectActionGroupInfo("Menu", this$0.group.getAction(), this$0.place, this$0.presentationFactory);
    }

    private static final boolean fillMenu$lambda$0(ActionMenu this$0) {
        return !this$0.isSelected();
    }

    @JvmStatic
    public static final boolean shouldConvertIconToDarkVariant() {
        return Companion.shouldConvertIconToDarkVariant();
    }

    public static final boolean isShowNoIcons() {
        return Companion.isShowNoIcons();
    }

    @JvmStatic
    public static final boolean isShowNoIcons(@NotNull AnAction action2, @NotNull Presentation presentation2) {
        return Companion.isShowNoIcons(action2, presentation2);
    }

    public static final boolean isAligned() {
        return Companion.isAligned();
    }

    public static final boolean isAlignedInGroup() {
        return Companion.isAlignedInGroup();
    }

    @JvmStatic
    public static final void showDescriptionInStatusBar(boolean isIncluded, @Nullable Component component2, @Nullable String description) {
        Companion.showDescriptionInStatusBar(isIncluded, component2, description);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J)\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\r\u0010\u0016\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b\u0018H\u0007R\u001a\u0010\u0006\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\u0006\u0010\bR\u001a\u0010\r\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\r\u0010\bR\u001a\u0010\u000f\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/actionSystem/impl/ActionMenu$Companion;", "", "<init>", "()V", "shouldConvertIconToDarkVariant", "", "isShowNoIcons", "isShowNoIcons$annotations", "()Z", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "isAligned", "isAligned$annotations", "isAlignedInGroup", "isAlignedInGroup$annotations", "showDescriptionInStatusBar", "", "isIncluded", "component", "Ljava/awt/Component;", "description", "", "Lcom/intellij/openapi/util/NlsContexts$StatusBarText;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean shouldConvertIconToDarkVariant() {
            return JBColor.isBright() && ColorUtil.isDark((Color)((Color)JBColor.namedColor((String)"MenuItem.background", (int)0xFFFFFF)));
        }

        public final boolean isShowNoIcons() {
            return SystemInfoRt.isMac && (ExperimentalUI.Companion.isNewUI() || Registry.Companion.get("ide.macos.main.menu.alignment.options").isOptionEnabled("No icons"));
        }

        @JvmStatic
        public static /* synthetic */ void isShowNoIcons$annotations() {
        }

        @JvmStatic
        public final boolean isShowNoIcons(@NotNull AnAction action2, @NotNull Presentation presentation2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            return Intrinsics.areEqual((Object)presentation2.getClientProperty(ActionUtil.SHOW_ICON_IN_MAIN_MENU), (Object)true) ? false : (action2 instanceof MainMenuPresentationAware && ((MainMenuPresentationAware)action2).alwaysShowIconInMainMenu() ? false : this.isShowNoIcons());
        }

        public final boolean isAligned() {
            return SystemInfoRt.isMac && Registry.Companion.get("ide.macos.main.menu.alignment.options").isOptionEnabled("Aligned");
        }

        @JvmStatic
        public static /* synthetic */ void isAligned$annotations() {
        }

        public final boolean isAlignedInGroup() {
            return SystemInfoRt.isMac && Registry.Companion.get("ide.macos.main.menu.alignment.options").isOptionEnabled("Aligned in group");
        }

        @JvmStatic
        public static /* synthetic */ void isAlignedInGroup$annotations() {
        }

        @JvmStatic
        public final void showDescriptionInStatusBar(boolean isIncluded, @Nullable Component component2, @Nullable String description) {
            block0: {
                Component component3 = component2 instanceof IdeFrame ? component2 : (Component)SwingUtilities.getAncestorOfClass(IdeFrame.class, component2);
                IdeFrame frame = component3 instanceof IdeFrame ? (IdeFrame)component3 : null;
                IdeFrame ideFrame = frame;
                if (ideFrame == null || (ideFrame = ideFrame.getStatusBar()) == null) break block0;
                ideFrame.setInfo(isIncluded ? description : null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/actionSystem/impl/ActionMenu$MenuListenerImpl;", "Ljavax/swing/event/ChangeListener;", "Ljavax/swing/event/MenuListener;", "<init>", "(Lcom/intellij/openapi/actionSystem/impl/ActionMenu;)V", "delayedClear", "Lkotlinx/coroutines/Job;", "getDelayedClear", "()Lkotlinx/coroutines/Job;", "setDelayedClear", "(Lkotlinx/coroutines/Job;)V", "isSelected", "", "()Z", "setSelected", "(Z)V", "stateChanged", "", "e", "Ljavax/swing/event/ChangeEvent;", "menuCanceled", "Ljavax/swing/event/MenuEvent;", "menuDeselected", "menuSelected", "onMenuHidden", "intellij.platform.ide.impl"})
    private final class MenuListenerImpl
    implements ChangeListener,
    MenuListener {
        @Nullable
        private Job delayedClear;
        private boolean isSelected;

        @Nullable
        public final Job getDelayedClear() {
            return this.delayedClear;
        }

        public final void setDelayedClear(@Nullable Job job2) {
            this.delayedClear = job2;
        }

        public final boolean isSelected() {
            return this.isSelected;
        }

        public final void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        @Override
        public void stateChanged(@NotNull ChangeEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.ButtonModel");
            ButtonModel model2 = (ButtonModel)object;
            boolean modelSelected = model2.isSelected();
            if (modelSelected != this.isSelected) {
                this.isSelected = modelSelected;
                if (modelSelected) {
                    this.menuSelected();
                } else {
                    this.menuDeselected();
                }
            }
        }

        @Override
        public void menuCanceled(@NotNull MenuEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.onMenuHidden();
        }

        @Override
        public void menuDeselected(@NotNull MenuEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        @Override
        public void menuSelected(@NotNull MenuEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        private final void menuDeselected() {
            block1: {
                if (ActionMenu.this.disposable != null) {
                    Disposable disposable = ActionMenu.this.disposable;
                    Intrinsics.checkNotNull((Object)disposable);
                    Disposer.dispose((Disposable)disposable);
                    ActionMenu.this.disposable = null;
                }
                this.onMenuHidden();
                SubElementSelector subElementSelector = ActionMenu.this.subElementSelector;
                if (subElementSelector == null) break block1;
                subElementSelector.cancelNextSelection();
            }
        }

        private final void onMenuHidden() {
            Runnable clearSelf = () -> MenuListenerImpl.onMenuHidden$lambda$0(ActionMenu.this);
            if (MacMenuSettings.isSystemMenu && ActionMenu.this.isMainMenuPlace()) {
                this.delayedClear = EdtScheduler.Companion.getInstance().schedule-VtjQ1oo(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS), clearSelf);
            } else {
                clearSelf.run();
            }
        }

        private final void menuSelected() {
            if (!ActionMenu.this.isShowing()) {
                return;
            }
            long startMs = System.currentTimeMillis();
            UsabilityHelper helper = new UsabilityHelper((Component)((Object)ActionMenu.this));
            if (ActionMenu.this.disposable == null) {
                ActionMenu.this.disposable = Disposer.newDisposable();
            }
            Disposable disposable = ActionMenu.this.disposable;
            Intrinsics.checkNotNull((Object)disposable);
            Disposer.register((Disposable)disposable, (Disposable)helper);
            if (this.delayedClear != null) {
                Job job2 = this.delayedClear;
                Intrinsics.checkNotNull((Object)job2);
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                this.delayedClear = null;
                ActionMenu.this.clearItems();
            }
            if (MacMenuSettings.isSystemMenu && Intrinsics.areEqual((Object)"MainMenu", (Object)ActionMenu.this.place)) {
                ActionMenu.this.fillMenu();
            } else {
                UILatencyLogger.MAIN_MENU_LATENCY.log((Object)(System.currentTimeMillis() - startMs));
            }
        }

        private static final void onMenuHidden$lambda$0(ActionMenu this$0) {
            this$0.clearItems();
            this$0.addStubItem();
        }
    }
}

