/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public final class FieldInplaceActionButtonLook
extends IdeaActionButtonLook {
    @Override
    public void paintBorder(Graphics g, JComponent component2, @ActionButtonComponent.ButtonState int state2) {
        if (component2.isFocusOwner() && component2.isEnabled()) {
            Rectangle rect = new Rectangle(component2.getSize());
            JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
            SYSTEM_LOOK.paintLookBorder(g, rect, JBUI.CurrentTheme.ActionButton.focusedBorder());
        } else {
            super.paintBorder(g, component2, 0);
        }
    }

    @Override
    public void paintBackground(Graphics g, JComponent component2, int state2) {
        if (!(component2 instanceof ActionButton)) {
            FieldInplaceActionButtonLook.failBecauseOfWrongComponent();
        }
        ActionButton actionButton = (ActionButton)component2;
        boolean isSelected = actionButton.isSelected();
        boolean isRollover = actionButton.isRollover();
        if (isRollover) {
            super.paintBackground(g, component2, state2);
        } else if (state2 == 2 && component2.isEnabled()) {
            Rectangle rect = new Rectangle(component2.getSize());
            JBInsets.removeFrom((Rectangle)rect, (Insets)component2.getInsets());
            if (!ExperimentalUI.isNewUI() || isSelected) {
                this.paintLookBackground(g, rect, (Color)JBUI.CurrentTheme.SearchOption.BUTTON_SELECTED_BACKGROUND);
            }
        }
    }

    @Override
    protected Color getStateBackground(JComponent component2, int state2) {
        if (!(component2 instanceof ActionButton)) {
            FieldInplaceActionButtonLook.failBecauseOfWrongComponent();
        }
        if (ExperimentalUI.isNewUI() && state2 == 2) {
            ActionButton actionButton = (ActionButton)component2;
            boolean isMouseDown = actionButton.isMouseDown();
            return isMouseDown ? JBUI.CurrentTheme.SearchOption.BUTTON_SELECTED_PRESSED_BACKGROUND : JBUI.CurrentTheme.SearchOption.BUTTON_SELECTED_HOVERED_BACKGROUND;
        }
        return super.getStateBackground(component2, state2);
    }

    private static void failBecauseOfWrongComponent() {
        throw new IllegalStateException(String.format("The look&feel %s can works only with %s, don't use it with other components", FieldInplaceActionButtonLook.class.getSimpleName(), ActionButton.class.getSimpleName()));
    }
}

