/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000fJ\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/actionSystem/impl/ToolbarUtils;", "", "<init>", "()V", "createImmediatelyUpdatedToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "place", "", "targetComponent", "Ljavax/swing/JComponent;", "horizontal", "", "onUpdated", "Lkotlin/Function1;", "", "createTargetComponent", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataProvider", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "component", "MyComponent", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ToolbarUtils {
    @NotNull
    public static final ToolbarUtils INSTANCE = new ToolbarUtils();

    private ToolbarUtils() {
    }

    @NotNull
    public final ActionToolbar createImmediatelyUpdatedToolbar(@NotNull ActionGroup group2, @NotNull String place, @NotNull JComponent targetComponent, boolean horizontal, @NotNull Function1<? super ActionToolbar, Unit> onUpdated) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
        Intrinsics.checkNotNullParameter(onUpdated, (String)"onUpdated");
        ActionToolbarImpl toolbar2 = new ActionToolbarImpl(targetComponent, place, group2, horizontal, onUpdated){
            final /* synthetic */ Function1<ActionToolbar, Unit> $onUpdated;
            {
                this.$onUpdated = $onUpdated;
                super($place, $group, $horizontal, false, false, 24, null);
                this.setTargetComponent($targetComponent);
                ClientProperty.put((JComponent)this, ActionToolbarImpl.Companion.getSUPPRESS_FAST_TRACK(), (Object)true);
                this.setReservePlaceAutoPopupIcon(false);
                ComponentUtil.markAsShowing((JComponent)this, (boolean)true);
                this.updateActionsImmediately(true);
            }

            protected void actionsUpdated(boolean forced, List<? extends AnAction> newVisibleActions) {
                Intrinsics.checkNotNullParameter(newVisibleActions, (String)"newVisibleActions");
                boolean firstTime = forced && !this.hasVisibleActions();
                super.actionsUpdated(forced, newVisibleActions);
                if (firstTime) {
                    ComponentUtil.markAsShowing((JComponent)this, (boolean)false);
                    this.$onUpdated.invoke((Object)this);
                }
            }
        };
        return toolbar2;
    }

    public static /* synthetic */ ActionToolbar createImmediatelyUpdatedToolbar$default(ToolbarUtils toolbarUtils, ActionGroup actionGroup, String string, JComponent jComponent, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return toolbarUtils.createImmediatelyUpdatedToolbar(actionGroup, string, jComponent, bl, (Function1<? super ActionToolbar, Unit>)function1);
    }

    @NotNull
    public final JComponent createTargetComponent(@NotNull Editor editor2, @NotNull UiDataProvider dataProvider) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        JComponent jComponent = editor2.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        return new MyComponent(jComponent, dataProvider);
    }

    @NotNull
    public final JComponent createTargetComponent(@NotNull JComponent component2, @NotNull UiDataProvider dataProvider) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        return new MyComponent(component2, dataProvider);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/actionSystem/impl/ToolbarUtils$MyComponent;", "Ljavax/swing/JComponent;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "base", "provider", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/openapi/actionSystem/UiDataProvider;)V", "getBase", "()Ljavax/swing/JComponent;", "getProvider", "()Lcom/intellij/openapi/actionSystem/UiDataProvider;", "getParent", "Ljava/awt/Container;", "isShowing", "", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.platform.ide.impl"})
    private static final class MyComponent
    extends JComponent
    implements UiDataProvider {
        @NotNull
        private final JComponent base;
        @NotNull
        private final UiDataProvider provider;

        public MyComponent(@NotNull JComponent base, @NotNull UiDataProvider provider) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            this.base = base;
            this.provider = provider;
        }

        @NotNull
        public final JComponent getBase() {
            return this.base;
        }

        @NotNull
        public final UiDataProvider getProvider() {
            return this.provider;
        }

        @Override
        @NotNull
        public Container getParent() {
            return this.base;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            DataSink.Companion.uiDataSnapshot(sink, (Object)this.provider);
        }
    }
}

