/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.JBUI;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/actionSystem/impl/UsabilityHelper;", "Lcom/intellij/ide/IdeEventQueue$NonLockedEventDispatcher;", "Ljava/awt/event/AWTEventListener;", "Lcom/intellij/openapi/Disposable;", "component", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Component;)V", "startMousePoint", "Ljava/awt/Point;", "xClosestToTargetSoFar", "", "closestHorizontalDistanceSoFar", "upperTargetPoint", "lowerTargetPoint", "callbackAlarm", "Lcom/intellij/util/SingleAlarm;", "eventToRedispatch", "Ljava/awt/event/MouseEvent;", "eventDispatched", "", "event", "Ljava/awt/AWTEvent;", "dispatch", "", "e", "dispose", "intellij.platform.ide.impl"})
final class UsabilityHelper
implements IdeEventQueue.NonLockedEventDispatcher,
AWTEventListener,
Disposable {
    @Nullable
    private Component component;
    @Nullable
    private Point startMousePoint;
    private int xClosestToTargetSoFar;
    private int closestHorizontalDistanceSoFar;
    @Nullable
    private Point upperTargetPoint;
    @Nullable
    private Point lowerTargetPoint;
    @Nullable
    private SingleAlarm callbackAlarm;
    @Nullable
    private MouseEvent eventToRedispatch;

    public UsabilityHelper(@NotNull Component component2) {
        PointerInfo info;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Runnable runnable2 = () -> UsabilityHelper._init_$lambda$0(this);
        Disposable disposable = this;
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        this.callbackAlarm = new SingleAlarm(runnable2, 50, disposable, modalityState);
        this.component = component2;
        PointerInfo pointerInfo = info = MouseInfo.getPointerInfo();
        Point point = this.startMousePoint = pointerInfo != null ? pointerInfo.getLocation() : null;
        if (this.startMousePoint != null) {
            Point point2 = this.startMousePoint;
            Intrinsics.checkNotNull((Object)point2);
            this.xClosestToTargetSoFar = point2.x;
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 1L);
            IdeEventQueue.Companion.getInstance().addDispatcher((IdeEventQueue.NonLockedEventDispatcher)this, (Disposable)this);
        }
    }

    @Override
    public void eventDispatched(@NotNull AWTEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof ComponentEvent)) {
            return;
        }
        Component component2 = ((ComponentEvent)event).getComponent();
        JPopupMenu popup2 = (JPopupMenu)ComponentUtil.getParentOfType(JPopupMenu.class, (Component)component2);
        if (popup2 != null && popup2.getInvoker() == this.component && popup2.isShowing()) {
            Rectangle bounds = popup2.getBounds();
            if (bounds.isEmpty()) {
                return;
            }
            bounds.setLocation(popup2.getLocationOnScreen());
            Point point = this.startMousePoint;
            Intrinsics.checkNotNull((Object)point);
            if (point.x < bounds.x) {
                this.upperTargetPoint = new Point(bounds.x, bounds.y);
                this.lowerTargetPoint = new Point(bounds.x, bounds.y + bounds.height);
                Point point2 = this.upperTargetPoint;
                Intrinsics.checkNotNull((Object)point2);
                this.closestHorizontalDistanceSoFar = Math.abs(point2.x - this.xClosestToTargetSoFar);
            }
            Point point3 = this.startMousePoint;
            Intrinsics.checkNotNull((Object)point3);
            if (point3.x > bounds.x + bounds.width) {
                this.upperTargetPoint = new Point(bounds.x + bounds.width, bounds.y);
                this.lowerTargetPoint = new Point(bounds.x + bounds.width, bounds.y + bounds.height);
                Point point4 = this.upperTargetPoint;
                Intrinsics.checkNotNull((Object)point4);
                this.closestHorizontalDistanceSoFar = Math.abs(point4.x - this.xClosestToTargetSoFar);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        callbackAlarm = this.callbackAlarm;
        if (!(e instanceof MouseEvent) || this.upperTargetPoint == null || this.lowerTargetPoint == null || callbackAlarm == null) {
            return false;
        }
        if (e.getID() == 501 || e.getID() == 502 || e.getID() == 500) {
            return false;
        }
        point = ((MouseEvent)e).getLocationOnScreen();
        v0 = this.component;
        Intrinsics.checkNotNull((Object)v0);
        bounds = v0.getBounds();
        v1 = this.component;
        Intrinsics.checkNotNull((Object)v1);
        bounds.setLocation(v1.getLocationOnScreen());
        insideTarget = bounds.contains(point);
        v2 = this.upperTargetPoint;
        Intrinsics.checkNotNull((Object)v2);
        horizontalDistance = Math.abs(v2.x - point.x);
        if (!insideTarget && horizontalDistance < this.closestHorizontalDistanceSoFar) {
            this.closestHorizontalDistanceSoFar = horizontalDistance;
        }
        v3 = startedToMoveAway = insideTarget == false && horizontalDistance >= this.closestHorizontalDistanceSoFar + JBUI.scale((int)16);
        if (insideTarget) ** GOTO lbl-1000
        if (!startedToMoveAway) {
            var9_8 = new int[3];
            v4 = this.startMousePoint;
            Intrinsics.checkNotNull((Object)v4);
            var9_8[0] = v4.x;
            v5 = this.upperTargetPoint;
            Intrinsics.checkNotNull((Object)v5);
            var9_8[1] = v5.x;
            v6 = this.lowerTargetPoint;
            Intrinsics.checkNotNull((Object)v6);
            var9_8[2] = v6.x;
            v7 = var9_8;
            var9_8 = new int[3];
            v8 = this.startMousePoint;
            Intrinsics.checkNotNull((Object)v8);
            var9_8[0] = v8.y;
            v9 = this.upperTargetPoint;
            Intrinsics.checkNotNull((Object)v9);
            var9_8[1] = v9.y;
            v10 = this.lowerTargetPoint;
            Intrinsics.checkNotNull((Object)v10);
            var9_8[2] = v10.y;
            ** if (!new Polygon((int[])v7, (int[])var9_8, (int)3).contains((Point)point)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v11 = true;
            ** GOTO lbl49
        }
lbl-1000:
        // 2 sources

        {
            v11 = false;
        }
lbl49:
        // 2 sources

        isMouseMovingTowardsSubmenu = v11;
        this.eventToRedispatch = (MouseEvent)e;
        if (!isMouseMovingTowardsSubmenu) {
            callbackAlarm.request();
        } else {
            callbackAlarm.cancel();
        }
        return true;
    }

    public void dispose() {
        this.component = null;
        this.eventToRedispatch = null;
        this.lowerTargetPoint = null;
        this.upperTargetPoint = null;
        this.startMousePoint = null;
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    private static final void _init_$lambda$0(UsabilityHelper this$0) {
        SingleAlarm singleAlarm2 = this$0.callbackAlarm;
        Intrinsics.checkNotNull((Object)singleAlarm2);
        Disposer.dispose((Disposable)((Disposable)singleAlarm2));
        this$0.callbackAlarm = null;
        if (this$0.eventToRedispatch != null) {
            IdeEventQueue ideEventQueue = IdeEventQueue.Companion.getInstance();
            MouseEvent mouseEvent = this$0.eventToRedispatch;
            Intrinsics.checkNotNull((Object)mouseEvent);
            ideEventQueue.dispatchEvent(mouseEvent);
        }
    }
}

