/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl.segmentedActionBar;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class PillBorder
extends LineBorder {
    private final float myArcSize;

    public PillBorder(@NotNull Color color, int thickness) {
        if (color == null) {
            PillBorder.$$$reportNull$$$0(0);
        }
        this(color, thickness, DarculaUIUtil.BUTTON_ARC.getFloat());
    }

    @ApiStatus.Internal
    public PillBorder(@NotNull Color color, int thickness, float arcSize) {
        if (color == null) {
            PillBorder.$$$reportNull$$$0(1);
        }
        super(color, thickness);
        this.myArcSize = arcSize;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        int scl = JBUIScale.scale((int)this.thickness);
        insets.set(scl, scl, scl, scl);
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.lineColor);
        RoundRectangle2D.Float area = new RoundRectangle2D.Float(x, y, width, height, this.myArcSize, this.myArcSize);
        g2d.fill(area);
        config.restore();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/actionSystem/impl/segmentedActionBar/PillBorder", "<init>"));
    }
}

