/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.application.constraints.ConstrainedExecution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/application/impl/InSmartMode;", "Lcom/intellij/openapi/application/constraints/ConstrainedExecution$ContextConstraint;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isCorrectContext", "", "schedule", "", "runnable", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "toString", "", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nAppUIExecutorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppUIExecutorImpl.kt\ncom/intellij/openapi/application/impl/InSmartMode\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,202:1\n23#2:203\n*S KotlinDebug\n*F\n+ 1 AppUIExecutorImpl.kt\ncom/intellij/openapi/application/impl/InSmartMode\n*L\n187#1:203\n*E\n"})
public final class InSmartMode
implements ConstrainedExecution.ContextConstraint {
    @NotNull
    private final Project project;

    public InSmartMode(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        if (!(!LightEdit.owns((Project)this.project))) {
            boolean bl = false;
            String string = "InSmartMode can't be used in LightEdit mode, check that LightEdit.owns(project)==false before calling";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public boolean isCorrectContext() {
        boolean correctContext;
        boolean bl = correctContext = !this.project.isDisposed() && DumbService.Companion.getInstance(this.project).canRunSmart();
        if (!correctContext) {
            InSmartMode $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(InSmartMode.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("InSmartMode dispatched");
        }
        return correctContext;
    }

    @Override
    public void schedule(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        DumbService.Companion.getInstance(this.project).runWhenSmart(runnable2);
    }

    @Override
    @NotNull
    public String toString() {
        return "inSmartMode";
    }
}

