/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl.islands;

import com.intellij.ide.ProjectWindowCustomizerService;
import com.intellij.openapi.application.impl.islands.IslandsGradientPainterKt;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/application/impl/islands/IslandsGradientPainter;", "Lcom/intellij/openapi/ui/AbstractPainter;", "frame", "Lcom/intellij/openapi/wm/IdeFrame;", "mainColor", "Ljava/awt/Color;", "enabled", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/wm/IdeFrame;Ljava/awt/Color;Lkotlin/jvm/functions/Function0;)V", "islandsGradientColors", "", "", "projectWindowCustomizer", "Lcom/intellij/ide/ProjectWindowCustomizerService;", "doPaint", "needsRepaint", "executePaint", "", "component", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics2D;", "intellij.platform.ide.impl"})
public final class IslandsGradientPainter
extends AbstractPainter {
    @NotNull
    private final IdeFrame frame;
    @NotNull
    private final Color mainColor;
    @NotNull
    private final Function0<Boolean> enabled;
    @NotNull
    private final Set<String> islandsGradientColors;
    @NotNull
    private final ProjectWindowCustomizerService projectWindowCustomizer;
    private boolean doPaint;

    public IslandsGradientPainter(@NotNull IdeFrame frame, @NotNull Color mainColor, @NotNull Function0<Boolean> enabled2) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)mainColor, (String)"mainColor");
        Intrinsics.checkNotNullParameter(enabled2, (String)"enabled");
        this.frame = frame;
        this.mainColor = mainColor;
        this.enabled = enabled2;
        Object[] objectArray = new String[]{"MainWindow.background", "MainToolbar.background", "MainToolbar.inactiveBackground", "ToolWindow.Stripe.background", "StatusBar.background"};
        this.islandsGradientColors = SetsKt.setOf((Object[])objectArray);
        this.projectWindowCustomizer = ProjectWindowCustomizerService.Companion.getInstance();
        this.doPaint = true;
    }

    public boolean needsRepaint() {
        return (Boolean)this.enabled.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executePaint(@NotNull Component component2, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.doPaint) {
            try {
                String colorName;
                this.doPaint = false;
                Paint paint = g.getPaint();
                JBColor jBColor = paint instanceof JBColor ? (JBColor)paint : null;
                String string = colorName = jBColor != null ? jBColor.getName() : null;
                if (CollectionsKt.contains((Iterable)this.islandsGradientColors, (Object)colorName)) {
                    IslandsGradientPainterKt.islandsGradientPaint(this.frame, this.mainColor, this.projectWindowCustomizer, component2, g);
                }
            }
            finally {
                this.doPaint = true;
            }
        }
    }
}

