/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CannotUndoReportDialog
extends DialogWrapper
implements UiDataProvider {
    private static final int FILE_TEXT_PREVIEW_CHARS_LIMIT = 40;
    private final Project myProject;
    private JList<DocumentReference> myProblemFilesList;
    private JPanel myPanel;
    private JLabel myProblemMessageLabel;

    public CannotUndoReportDialog(Project project2, @Nls String problemText, Collection<? extends DocumentReference> files2) {
        super(project2, false);
        this.myProject = project2;
        this.$$$setupUI$$$();
        DefaultListModel<DocumentReference> model2 = new DefaultListModel<DocumentReference>();
        for (DocumentReference documentReference : files2) {
            model2.addElement(documentReference);
        }
        this.myProblemFilesList.setCellRenderer((ListCellRenderer<DocumentReference>)new SimpleListCellRenderer<DocumentReference>(){

            public void customize(@NotNull JList<? extends DocumentReference> list2, DocumentReference file2, int index, boolean selected, boolean hasFocus) {
                VirtualFile vFile;
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((vFile = file2.getFile()) != null) {
                    this.setText(vFile.getPresentableUrl());
                } else {
                    Object content2;
                    Document document2 = file2.getDocument();
                    Object object = content2 = document2 == null ? null : document2.getImmutableCharSequence();
                    if (content2 != null && content2.length() > 40) {
                        content2 = String.valueOf(content2.subSequence(0, 40)) + "...";
                    }
                    this.setText(IdeBundle.message((String)"list.item.temporary.file.0", (Object[])new Object[]{content2 == null ? "" : " [" + String.valueOf(content2) + "]"}));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/command/impl/CannotUndoReportDialog$1", "customize"));
            }
        });
        this.myProblemFilesList.setModel(model2);
        EditSourceOnDoubleClickHandler.install(this.myProblemFilesList, () -> this.doOKAction());
        EditSourceOnEnterKeyHandler.install(this.myProblemFilesList, () -> this.doOKAction());
        this.setTitle(IdeBundle.message((String)"cannot.undo.title", (Object[])new Object[0]));
        this.myProblemMessageLabel.setText(problemText);
        this.myProblemMessageLabel.setIcon(Messages.getErrorIcon());
        this.init();
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            CannotUndoReportDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            CannotUndoReportDialog.$$$reportNull$$$0(1);
        }
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
            DocumentReference value = this.myProblemFilesList.getSelectedValue();
            VirtualFile file2 = value != null ? value.getFile() : null;
            return file2 != null ? new OpenFileDescriptor(this.myProject, file2) : null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/CannotUndoReportDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/CannotUndoReportDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myProblemMessageLabel = jLabel = new JLabel();
        jLabel.setText("%%Cannot undo reason%");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/IdeBundle", CannotUndoReportDialog.class).getString("border.title.problem.files"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myProblemFilesList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

